/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression;

import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.OperationExpression;
import org.datayoo.moql.operand.expression.OperatorGetter;

public abstract class AbstractOperationExpression
extends AbstractExpression
implements OperationExpression {
    protected OperatorType operatorType;
    protected OperatorGetter operator;
    protected Operand lOperand;
    protected Operand rOperand;

    public AbstractOperationExpression(OperatorType operatorType, OperatorGetter operator, Operand lOperand, Operand rOperand) {
        Validate.notNull((Object)operatorType, (String)"Parameter 'operatorType' is null!", (Object[])new Object[0]);
        Validate.notNull((Object)operator, (String)"Parameter 'operator' is null!", (Object[])new Object[0]);
        if (operatorType == OperatorType.BINARY) {
            Validate.notNull((Object)lOperand, (String)"Parameter 'lOperand' is null!", (Object[])new Object[0]);
        }
        Validate.notNull((Object)rOperand, (String)"Parameter 'rOperand' is null!", (Object[])new Object[0]);
        this.operatorType = operatorType;
        this.operator = operator;
        this.lOperand = lOperand;
        this.rOperand = rOperand;
        this.name = this.buildNameString();
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        if (this.lOperand != null) {
            sbuf.append(this.lOperand.toString());
            sbuf.append(' ');
            sbuf.append(this.operator.getOperator());
            sbuf.append(' ');
            sbuf.append(this.rOperand.toString());
        } else {
            sbuf.append(this.operator.getOperator());
            sbuf.append(' ');
            sbuf.append('(');
            sbuf.append(this.rOperand.toString());
            sbuf.append(')');
        }
        return sbuf.toString();
    }

    @Override
    public OperatorGetter getOperator() {
        return this.operator;
    }

    @Override
    public Operand getLeftOperand() {
        return this.lOperand;
    }

    @Override
    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    @Override
    public Operand getRightOperand() {
        return this.rOperand;
    }

    @Override
    public void bind(String[] entityNames) {
        if (this.lOperand != null) {
            this.lOperand.bind(entityNames);
        }
        if (this.rOperand != null) {
            this.rOperand.bind(entityNames);
        }
        this.binded = true;
    }
}

