/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.join;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.EntityMapImpl;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Join;
import org.datayoo.moql.core.Queryable;
import org.datayoo.moql.core.join.AbstractJoin;
import org.datayoo.moql.metadata.JoinMetadata;

public class FullJoin
extends AbstractJoin {
    protected EntityMap lNullEntityMap;
    protected EntityMap rNullEntityMap;

    public FullJoin(JoinMetadata joinMetadata, Queryable<? extends Object> queryable, Queryable<? extends Object> queryable2, Condition on) {
        super(joinMetadata, queryable, queryable2, on);
        if (this.lTableName == null) {
            this.lNullEntityMap = ((Join)this.lQueryable).getNullEntityMap();
        }
        if (this.rTableName == null) {
            this.rNullEntityMap = ((Join)this.rQueryable).getNullEntityMap();
        }
    }

    @Override
    protected List<EntityMap> join() {
        if (!this.rQueryable.iterator().hasNext()) {
            return this.justLeftOut();
        }
        if (!this.lQueryable.iterator().hasNext()) {
            return this.justRightOut();
        }
        LinkedList<EntityMap> result = new LinkedList<EntityMap>();
        byte[] flags = new byte[this.getRQueryableSize()];
        for (Object lObj : this.lQueryable) {
            EntityMapImpl entityMap;
            EntityMap lEntityMap = null;
            if (this.lTableName == null) {
                lEntityMap = (EntityMap)lObj;
            }
            boolean bMatch = false;
            int i = 0;
            for (Object rObj : this.rQueryable) {
                entityMap = new EntityMapImpl();
                if (this.lTableName == null) {
                    entityMap.putAll(lEntityMap);
                } else {
                    entityMap.putEntity(this.lTableName, lObj);
                }
                if (this.rTableName == null) {
                    entityMap.putAll((EntityMap)rObj);
                } else {
                    entityMap.putEntity(this.rTableName, rObj);
                }
                if (this.on != null) {
                    if (this.on.isMatch(entityMap)) {
                        bMatch = true;
                        flags[i] = 1;
                        result.add(entityMap);
                    }
                } else {
                    bMatch = true;
                    flags[i] = 1;
                    result.add(entityMap);
                }
                ++i;
            }
            if (bMatch) continue;
            entityMap = new EntityMapImpl();
            if (this.lTableName == null) {
                entityMap.putAll(lEntityMap);
            } else {
                entityMap.putEntity(this.lTableName, lObj);
            }
            if (this.rTableName == null) {
                entityMap.putAll(this.rNullEntityMap);
            } else {
                entityMap.putEntity(this.rTableName, null);
            }
            result.add(entityMap);
        }
        this.doLeftNull(result, flags);
        return result;
    }

    protected int getRQueryableSize() {
        int size = 0;
        Iterator rit = this.rQueryable.iterator();
        while (rit.hasNext()) {
            rit.next();
            ++size;
        }
        return size;
    }

    protected void doLeftNull(List<EntityMap> result, byte[] flags) {
        int i = 0;
        for (Object rObj : this.rQueryable) {
            if (flags[i] != 1) {
                EntityMapImpl entityMap = new EntityMapImpl();
                if (this.rTableName == null) {
                    entityMap.putAll((EntityMap)rObj);
                } else {
                    entityMap.putEntity(this.rTableName, rObj);
                }
                if (this.lTableName == null) {
                    entityMap.putAll(this.lNullEntityMap);
                } else {
                    entityMap.putEntity(this.lTableName, null);
                }
                result.add(entityMap);
            }
            ++i;
        }
    }
}

