/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.RecordSetDefinition;

public class RecordSetMetadata
implements RecordSetDefinition {
    protected List<ColumnDefinition> columns;
    protected List<ColumnDefinition> groups = new ArrayList<ColumnDefinition>();

    public RecordSetMetadata(List<ColumnDefinition> columns, List<ColumnDefinition> groups) {
        Validate.notEmpty(columns, (String)"Parameter 'columns' is empty!", (Object[])new Object[0]);
        this.columns = columns;
        if (groups != null) {
            this.groups = groups;
        }
    }

    @Override
    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    @Override
    public int getColumnIndex(String column) {
        return this.getIndex(column, this.columns);
    }

    protected int getIndex(String column, List<ColumnDefinition> columns) {
        int index = -1;
        int i = 0;
        for (ColumnDefinition columnDefinition : columns) {
            if (column.equals(columnDefinition.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    @Override
    public List<ColumnDefinition> getGroupColumns() {
        return this.groups;
    }

    @Override
    public boolean isGroupColumn(String column) {
        for (ColumnDefinition columnDefinition : this.groups) {
            if (!column.equals(columnDefinition.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ColumnDefinition> getNonGroupColumns() {
        ArrayList<ColumnDefinition> nonGroupColumns = new ArrayList<ColumnDefinition>(this.columns.size());
        for (ColumnDefinition column : this.columns) {
            if (this.isGroupColumn(column.getName())) continue;
            nonGroupColumns.add(column);
        }
        return nonGroupColumns;
    }
}

