/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.mnist;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.nd4j.common.util.ArchiveUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MnistFetcher {
    private File fileDir;
    private static Logger log = LoggerFactory.getLogger(MnistFetcher.class);
    private static final String trainingFilesURL = "http://yann.lecun.com/exdb/mnist/train-images-idx3-ubyte.gz";
    private static final String trainingFilesFilename = "images-idx1-ubyte.gz";
    public static final String trainingFilesFilename_unzipped = "images-idx1-ubyte";
    private static final String trainingFileLabelsURL = "http://yann.lecun.com/exdb/mnist/train-labels-idx1-ubyte.gz";
    private static final String trainingFileLabelsFilename = "labels-idx1-ubyte.gz";
    public static final String trainingFileLabelsFilename_unzipped = "labels-idx1-ubyte";
    private static final String LOCAL_DIR_NAME = "MNIST";

    public File downloadAndUntar() throws IOException {
        if (this.fileDir != null) {
            return this.fileDir;
        }
        File tmpDir = new File(System.getProperty("user.home"));
        File baseDir = new File(tmpDir, LOCAL_DIR_NAME);
        if (!baseDir.isDirectory() && !baseDir.mkdir()) {
            throw new IOException("Could not mkdir " + baseDir);
        }
        log.info("Downloading mnist...");
        File tarFile = new File(baseDir, trainingFilesFilename);
        if (!tarFile.isFile()) {
            FileUtils.copyURLToFile((URL)new URL(trainingFilesURL), (File)tarFile);
        }
        ArchiveUtils.unzipFileTo((String)tarFile.getAbsolutePath(), (String)baseDir.getAbsolutePath());
        File labels = new File(baseDir, trainingFileLabelsFilename);
        if (!labels.isFile()) {
            FileUtils.copyURLToFile((URL)new URL(trainingFileLabelsURL), (File)labels);
        }
        ArchiveUtils.unzipFileTo((String)labels.getAbsolutePath(), (String)baseDir.getAbsolutePath());
        this.fileDir = baseDir;
        return this.fileDir;
    }

    public void untarFile(File baseDir, File tarFile) throws IOException {
        String s;
        log.info("Untaring File: " + tarFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("tar -C %s -xvf %s", baseDir.getAbsolutePath(), tarFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }

    public static void gunzipFile(File baseDir, File gzFile) throws IOException {
        String s;
        log.info("gunzip'ing File: " + gzFile.toString());
        Process p = Runtime.getRuntime().exec(String.format("gunzip %s", gzFile.getAbsolutePath()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        log.info("Here is the standard error of the command (if any):\n");
        while ((s = stdError.readLine()) != null) {
            log.info(s);
        }
        stdError.close();
    }
}

