/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;

public class LargestBlobCropTransform
extends BaseImageTransform<opencv_core.Mat> {
    protected Random rng = Nd4j.getRandom();
    protected int mode;
    protected int method;
    protected int blurWidth;
    protected int blurHeight;
    protected int upperThresh;
    protected int lowerThresh;
    protected boolean isCanny;
    private int x;
    private int y;

    public LargestBlobCropTransform() {
        this(null);
    }

    public LargestBlobCropTransform(java.util.Random random) {
        this(random, 2, 2, 3, 3, 100, 200, true);
    }

    public LargestBlobCropTransform(java.util.Random random, int mode, int method, int blurWidth, int blurHeight, int lowerThresh, int upperThresh, boolean isCanny) {
        super(random);
        this.mode = mode;
        this.method = method;
        this.blurWidth = blurWidth;
        this.blurHeight = blurHeight;
        this.lowerThresh = lowerThresh;
        this.upperThresh = upperThresh;
        this.isCanny = isCanny;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    protected ImageWritable doTransform(ImageWritable image, java.util.Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat original = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat grayed = new opencv_core.Mat();
        opencv_imgproc.cvtColor((opencv_core.Mat)original, (opencv_core.Mat)grayed, (int)6);
        if (this.blurWidth > 0 && this.blurHeight > 0) {
            opencv_imgproc.blur((opencv_core.Mat)grayed, (opencv_core.Mat)grayed, (opencv_core.Size)new opencv_core.Size(this.blurWidth, this.blurHeight));
        }
        opencv_core.Mat edgeOut = new opencv_core.Mat();
        if (this.isCanny) {
            opencv_imgproc.Canny((opencv_core.Mat)grayed, (opencv_core.Mat)edgeOut, (double)this.lowerThresh, (double)this.upperThresh);
        } else {
            opencv_imgproc.threshold((opencv_core.Mat)grayed, (opencv_core.Mat)edgeOut, (double)this.lowerThresh, (double)this.upperThresh, (int)0);
        }
        double largestArea = 0.0;
        opencv_core.Rect boundingRect = new opencv_core.Rect();
        opencv_core.MatVector contours = new opencv_core.MatVector();
        opencv_core.Mat hierarchy = new opencv_core.Mat();
        opencv_imgproc.findContours((opencv_core.Mat)edgeOut, (opencv_core.MatVector)contours, (opencv_core.Mat)hierarchy, (int)this.mode, (int)this.method);
        int i = 0;
        while ((long)i < contours.size()) {
            double area = opencv_imgproc.contourArea((opencv_core.Mat)contours.get((long)i), (boolean)false);
            if (area > largestArea) {
                boundingRect = opencv_imgproc.boundingRect((opencv_core.Mat)contours.get((long)i));
            }
            ++i;
        }
        this.x = boundingRect.x();
        this.y = boundingRect.y();
        opencv_core.Mat result = original.apply(boundingRect);
        return new ImageWritable(this.converter.convert((Object)result));
    }

    @Override
    public float[] query(float ... coordinates) {
        float[] transformed = new float[coordinates.length];
        for (int i = 0; i < coordinates.length; i += 2) {
            transformed[i] = coordinates[i] - (float)this.x;
            transformed[i + 1] = coordinates[i + 1] - (float)this.y;
        }
        return transformed;
    }
}

