/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.NonNull;
import org.bytedeco.javacpp.opencv_core;
import org.datavec.api.berkeley.Pair;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;

public class PipelineImageTransform
extends BaseImageTransform<opencv_core.Mat> {
    protected List<Pair<ImageTransform, Double>> imageTransforms;
    protected boolean shuffle;
    protected Random rng;

    public PipelineImageTransform(ImageTransform ... transforms) {
        this(1234L, false, transforms);
    }

    public PipelineImageTransform(long seed, boolean shuffle, ImageTransform ... transforms) {
        super(null);
        LinkedList<Pair<ImageTransform, Double>> pipeline = new LinkedList<Pair<ImageTransform, Double>>();
        for (int i = 0; i < transforms.length; ++i) {
            pipeline.add((Pair<ImageTransform, Double>)new Pair((Object)transforms[i], (Object)1.0));
        }
        this.imageTransforms = pipeline;
        this.shuffle = shuffle;
        this.rng = Nd4j.getRandom();
        this.rng.setSeed(seed);
    }

    public PipelineImageTransform(List<Pair<ImageTransform, Double>> transforms) {
        this(1234L, transforms, false);
    }

    public PipelineImageTransform(List<Pair<ImageTransform, Double>> transforms, boolean shuffle) {
        this(1234L, transforms, shuffle);
    }

    public PipelineImageTransform(long seed, List<Pair<ImageTransform, Double>> transforms) {
        this(seed, transforms, false);
    }

    public PipelineImageTransform(long seed, List<Pair<ImageTransform, Double>> transforms, boolean shuffle) {
        this(null, seed, transforms, shuffle);
    }

    public PipelineImageTransform(java.util.Random random, long seed, List<Pair<ImageTransform, Double>> transforms, boolean shuffle) {
        super(null);
        this.imageTransforms = transforms;
        this.shuffle = shuffle;
        this.rng = Nd4j.getRandom();
        this.rng.setSeed(seed);
    }

    @Override
    public ImageWritable transform(ImageWritable image, java.util.Random random) {
        if (this.shuffle) {
            Collections.shuffle(this.imageTransforms);
        }
        for (Pair<ImageTransform, Double> tuple : this.imageTransforms) {
            if ((Double)tuple.getSecond() != 1.0 && !(this.rng.nextDouble() < (Double)tuple.getSecond())) continue;
            image = ((ImageTransform)tuple.getFirst()).transform(image);
        }
        return image;
    }

    public static class Builder {
        protected List<Pair<ImageTransform, Double>> imageTransforms = new ArrayList<Pair<ImageTransform, Double>>();
        protected Long seed = null;

        public Builder setSeed(long seed) {
            this.seed = new Long(seed);
            return this;
        }

        public Builder addImageTransform(@NonNull ImageTransform transform) {
            if (transform == null) {
                throw new NullPointerException("transform");
            }
            return this.addImageTransform(transform, 1.0);
        }

        public Builder addImageTransform(@NonNull ImageTransform transform, Double probability) {
            if (transform == null) {
                throw new NullPointerException("transform");
            }
            if (probability < 0.0) {
                probability = 0.0;
            }
            if (probability > 1.0) {
                probability = 1.0;
            }
            this.imageTransforms.add((Pair<ImageTransform, Double>)Pair.makePair((Object)transform, (Object)probability));
            return this;
        }

        public PipelineImageTransform build() {
            if (this.seed != null) {
                return new PipelineImageTransform(this.seed, this.imageTransforms);
            }
            return new PipelineImageTransform(this.imageTransforms);
        }
    }
}

