/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.transform;

import java.util.Random;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacv.OpenCVFrameConverter;
import org.datavec.image.data.ImageWritable;
import org.datavec.image.transform.BaseImageTransform;

public class EqualizeHistTransform
extends BaseImageTransform {
    int conversionCode;
    opencv_core.MatVector splitChannels = new opencv_core.MatVector();

    public EqualizeHistTransform() {
        this(new Random(1234L), 6);
    }

    public EqualizeHistTransform(Random random, int conversionCode) {
        super(random);
        this.conversionCode = conversionCode;
        this.converter = new OpenCVFrameConverter.ToMat();
    }

    @Override
    public ImageWritable transform(ImageWritable image, Random random) {
        if (image == null) {
            return null;
        }
        opencv_core.Mat mat = (opencv_core.Mat)this.converter.convert(image.getFrame());
        opencv_core.Mat result = new opencv_core.Mat();
        try {
            if (this.conversionCode == 6) {
                opencv_imgproc.equalizeHist((opencv_core.Mat)mat, (opencv_core.Mat)result);
            } else if (this.conversionCode == 36 || this.conversionCode == 50) {
                opencv_core.split((opencv_core.Mat)mat, (opencv_core.MatVector)this.splitChannels);
                opencv_imgproc.equalizeHist((opencv_core.Mat)this.splitChannels.get(0L), (opencv_core.Mat)this.splitChannels.get(0L));
                opencv_core.merge((opencv_core.MatVector)this.splitChannels, (opencv_core.Mat)result);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ImageWritable(this.converter.convert((Object)result));
    }
}

