/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.nlp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.sequence.expansion.BaseSequenceExpansionTransform;
import org.datavec.api.writable.IntWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class TextToCharacterIndexTransform
extends BaseSequenceExpansionTransform {
    private Map<Character, Integer> characterIndexMap;
    private boolean exceptionOnUnknown;
    private transient Map<Character, List<Writable>> writableMap;

    public TextToCharacterIndexTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="characterIndexMap") Map<Character, Integer> characterIndexMap, @JsonProperty(value="exceptionOnUnknown") boolean exceptionOnUnknown) {
        super(Collections.singletonList(columnName), Collections.singletonList(newColumnName));
        this.characterIndexMap = characterIndexMap;
        this.exceptionOnUnknown = exceptionOnUnknown;
    }

    @Override
    protected List<ColumnMetaData> expandedColumnMetaDatas(List<ColumnMetaData> origColumnMeta, List<String> expandedColumnNames) {
        return Collections.singletonList(new IntegerMetaData(expandedColumnNames.get(0), 0, this.characterIndexMap.size() - 1));
    }

    @Override
    protected List<List<Writable>> expandTimeStep(List<Writable> currentStepValues) {
        char[] cArr;
        if (this.writableMap == null) {
            HashMap<Character, List<Writable>> m = new HashMap<Character, List<Writable>>();
            for (Map.Entry<Character, Integer> entry : this.characterIndexMap.entrySet()) {
                m.put(entry.getKey(), Collections.singletonList(new IntWritable(entry.getValue())));
            }
            this.writableMap = m;
        }
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (char c : cArr = currentStepValues.get(0).toString().toCharArray()) {
            List<Writable> w = this.writableMap.get(Character.valueOf(c));
            if (w == null) {
                if (!this.exceptionOnUnknown) continue;
                throw new IllegalStateException("Unknown character found in text: \"" + c + "\"");
            }
            out.add(w);
        }
        return out;
    }

    public Map<Character, Integer> getCharacterIndexMap() {
        return this.characterIndexMap;
    }

    public boolean isExceptionOnUnknown() {
        return this.exceptionOnUnknown;
    }

    public Map<Character, List<Writable>> getWritableMap() {
        return this.writableMap;
    }

    public void setCharacterIndexMap(Map<Character, Integer> characterIndexMap) {
        this.characterIndexMap = characterIndexMap;
    }

    public void setExceptionOnUnknown(boolean exceptionOnUnknown) {
        this.exceptionOnUnknown = exceptionOnUnknown;
    }

    public void setWritableMap(Map<Character, List<Writable>> writableMap) {
        this.writableMap = writableMap;
    }

    @Override
    public String toString() {
        return "TextToCharacterIndexTransform(characterIndexMap=" + this.getCharacterIndexMap() + ", exceptionOnUnknown=" + this.isExceptionOnUnknown() + ", writableMap=" + this.getWritableMap() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextToCharacterIndexTransform)) {
            return false;
        }
        TextToCharacterIndexTransform other = (TextToCharacterIndexTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<Character, Integer> this$characterIndexMap = this.getCharacterIndexMap();
        Map<Character, Integer> other$characterIndexMap = other.getCharacterIndexMap();
        if (this$characterIndexMap == null ? other$characterIndexMap != null : !((Object)this$characterIndexMap).equals(other$characterIndexMap)) {
            return false;
        }
        return this.isExceptionOnUnknown() == other.isExceptionOnUnknown();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextToCharacterIndexTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<Character, Integer> $characterIndexMap = this.getCharacterIndexMap();
        result = result * 59 + ($characterIndexMap == null ? 43 : ((Object)$characterIndexMap).hashCode());
        result = result * 59 + (this.isExceptionOnUnknown() ? 79 : 97);
        return result;
    }
}

