/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.transform;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.listener.RecordListener;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.transform.TransformProcess;
import org.datavec.api.writable.Writable;

public class TransformProcessRecordReader
implements RecordReader {
    protected RecordReader recordReader;
    protected TransformProcess transformProcess;
    protected Record next;

    public TransformProcessRecordReader(RecordReader recordReader, TransformProcess transformProcess) {
        this.recordReader = recordReader;
        this.transformProcess = transformProcess;
    }

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.recordReader.initialize(split);
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.recordReader.initialize(conf, split);
    }

    @Override
    public boolean batchesSupported() {
        return true;
    }

    @Override
    public List<List<Writable>> next(int num) {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (int i = 0; i < num && this.hasNext(); ++i) {
            out.add(this.next());
        }
        return out;
    }

    @Override
    public List<Writable> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        List<Writable> out = this.next.getRecord();
        this.next = null;
        return out;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (!this.recordReader.hasNext()) {
            return false;
        }
        while (this.next == null && this.recordReader.hasNext()) {
            Record r = this.recordReader.nextRecord();
            List<Writable> temp = this.transformProcess.execute(r.getRecord());
            if (temp == null) continue;
            this.next = new org.datavec.api.records.impl.Record(temp, r.getMetaData());
        }
        return this.next != null;
    }

    @Override
    public List<String> getLabels() {
        return this.recordReader.getLabels();
    }

    @Override
    public void reset() {
        this.next = null;
        this.recordReader.reset();
    }

    @Override
    public boolean resetSupported() {
        return this.recordReader.resetSupported();
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        return this.transformProcess.execute(this.recordReader.record(uri, dataInputStream));
    }

    @Override
    public Record nextRecord() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        Record toRet = this.next;
        this.next = null;
        return toRet;
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.recordReader.loadFromMetaData(recordMetaData);
    }

    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        return this.recordReader.loadFromMetaData(recordMetaDatas);
    }

    @Override
    public List<RecordListener> getListeners() {
        return this.recordReader.getListeners();
    }

    @Override
    public void setListeners(RecordListener ... listeners) {
        this.recordReader.setListeners(listeners);
    }

    @Override
    public void setListeners(Collection<RecordListener> listeners) {
        this.recordReader.setListeners(listeners);
    }

    @Override
    public void close() throws IOException {
        this.recordReader.close();
    }

    @Override
    public void setConf(Configuration conf) {
    }

    @Override
    public Configuration getConf() {
        return this.recordReader.getConf();
    }

    public TransformProcessRecordReader(RecordReader recordReader, TransformProcess transformProcess, Record next) {
        this.recordReader = recordReader;
        this.transformProcess = transformProcess;
        this.next = next;
    }
}

