/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.schema;

import au.com.bytecode.opencsv.CSVParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.datavec.api.transform.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferredSchema {
    private static final Logger log = LoggerFactory.getLogger(InferredSchema.class);
    protected Schema.Builder schemaBuilder;
    protected String pathToCsv;
    protected DataType defaultType;
    protected String quote;
    private CSVParser csvParser = new CSVParser();

    public InferredSchema(String pathToCsv) {
        this.pathToCsv = pathToCsv;
        this.defaultType = DataType.valueOf("STRING");
    }

    public InferredSchema(String pathToCsv, DataType defaultType) {
        this.pathToCsv = pathToCsv;
        this.defaultType = defaultType;
    }

    public InferredSchema(String pathToCsv, DataType defaultType, char delimiter) {
        this.pathToCsv = pathToCsv;
        this.defaultType = defaultType;
        this.csvParser = new CSVParser(delimiter);
    }

    public InferredSchema(String pathToCsv, DataType defaultType, char delimiter, char quote) {
        this.pathToCsv = pathToCsv;
        this.defaultType = defaultType;
        this.csvParser = new CSVParser(delimiter, quote);
    }

    public InferredSchema(String pathToCsv, DataType defaultType, char delimiter, char quote, char escape) {
        this.pathToCsv = pathToCsv;
        this.defaultType = defaultType;
        this.csvParser = new CSVParser(delimiter, quote, escape);
    }

    public Schema build() throws IOException {
        List headersAndRows = null;
        this.schemaBuilder = new Schema.Builder();
        try {
            headersAndRows = FileUtils.readLines((File)new File(this.pathToCsv));
        }
        catch (IOException e) {
            log.error("An error occurred while parsing sample CSV for schema", (Throwable)e);
        }
        List<String> headers = this.parseLine((String)headersAndRows.get(0));
        List<String> samples = this.parseLine((String)headersAndRows.get(1));
        if (headers.size() != samples.size()) {
            throw new IllegalStateException("CSV headers length does not match number of sample columns. Please check that your CSV is valid, or check the delimiter used to parse the CSV.");
        }
        for (int i = 0; i < headers.size(); ++i) {
            this.inferAndAddType(this.schemaBuilder, headers.get(i), samples.get(i));
        }
        return this.schemaBuilder.build();
    }

    private Schema.Builder inferAndAddType(Schema.Builder builder, String header, String sample) {
        if (InferredSchema.isParsableAsDouble(sample)) {
            InferredSchema.addOn(builder, header, DataType.DOUBLE);
        } else if (InferredSchema.isParsableAsInteger(sample)) {
            InferredSchema.addOn(builder, header, DataType.INTEGER);
        } else if (InferredSchema.isParsableAsLong(sample)) {
            InferredSchema.addOn(builder, header, DataType.LONG);
        } else {
            InferredSchema.addOn(builder, header, this.defaultType);
        }
        return this.schemaBuilder;
    }

    private static Schema.Builder addOn(Schema.Builder builder, String columnName, DataType columnType) {
        switch (columnType) {
            case DOUBLE: {
                return builder.addColumnDouble(columnName, null, null, false, false);
            }
            case INTEGER: {
                return builder.addColumnInteger(columnName);
            }
            case LONG: {
                return builder.addColumnLong(columnName);
            }
            case STRING: {
                return builder.addColumnString(columnName);
            }
        }
        throw new IllegalArgumentException("Schema inputs have to be string, integer or double");
    }

    private List<String> parseLine(String line) throws IOException {
        String[] split = this.csvParser.parseLine(line);
        ArrayList<String> ret = new ArrayList<String>();
        String[] var4 = split;
        int var5 = split.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String s = var4[var6];
            if (this.quote != null && s.startsWith(this.quote) && s.endsWith(this.quote)) {
                int n = this.quote.length();
                s = s.substring(n, s.length() - n).replace(this.quote + this.quote, this.quote);
            }
            ret.add(s);
        }
        return ret;
    }

    private static boolean isParsableAsLong(String s) {
        try {
            Long.valueOf(s);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isParsableAsInteger(String s) {
        try {
            Integer.valueOf(s);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isParsableAsDouble(String s) {
        try {
            Double.valueOf(s);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static enum DataType {
        STRING,
        INTEGER,
        DOUBLE,
        LONG;

    }
}

