/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.ReduceOp;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.transform.reduce.AggregableReductionUtils;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.schema.SequenceSchema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"inputSchema"})
public class SequenceMovingWindowReduceTransform
implements Transform {
    private final String columnName;
    private final String newColumnName;
    private final int lookback;
    private final ReduceOp op;
    private final EdgeCaseHandling edgeCaseHandling;
    private final Writable edgeCaseValue;
    private Schema inputSchema;

    public SequenceMovingWindowReduceTransform(String columnName, int lookback, ReduceOp op) {
        this(columnName, SequenceMovingWindowReduceTransform.defaultOutputColumnName(columnName, lookback, op), lookback, op, EdgeCaseHandling.Default, null);
    }

    public SequenceMovingWindowReduceTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="lookback") int lookback, @JsonProperty(value="op") ReduceOp op, @JsonProperty(value="edgeCaseHandling") EdgeCaseHandling edgeCaseHandling, @JsonProperty(value="edgeCaseValue") Writable edgeCaseValue) {
        this.columnName = columnName;
        this.newColumnName = newColumnName;
        this.lookback = lookback;
        this.op = op;
        this.edgeCaseHandling = edgeCaseHandling;
        this.edgeCaseValue = edgeCaseValue;
    }

    public static String defaultOutputColumnName(String originalName, int lookback, ReduceOp op) {
        return op.toString().toLowerCase() + "(" + lookback + "," + originalName + ")";
    }

    @Override
    public Schema transform(Schema inputSchema) {
        ColumnMetaData m;
        int colIdx = inputSchema.getIndexOfColumn(this.columnName);
        List<ColumnMetaData> oldMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> meta = new ArrayList<ColumnMetaData>(oldMeta);
        switch (this.op) {
            case Min: 
            case Max: 
            case Range: 
            case TakeFirst: 
            case TakeLast: {
                m = oldMeta.get(colIdx);
                m = m.clone();
                m.setName(this.newColumnName);
                break;
            }
            case Prod: 
            case Sum: 
            case Mean: 
            case Stdev: {
                m = new DoubleMetaData(this.newColumnName);
                break;
            }
            case Count: 
            case CountUnique: {
                m = new IntegerMetaData(this.newColumnName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown op type: " + this.op);
            }
        }
        meta.add(m);
        return new SequenceSchema(meta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("SequenceMovingWindowReduceTransform can only be applied on sequences");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        int colIdx = this.inputSchema.getIndexOfColumn(this.columnName);
        ColumnType columnType = this.inputSchema.getType(colIdx);
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>(sequence.size());
        LinkedList<Writable> window = new LinkedList<Writable>();
        for (int i = 0; i < sequence.size(); ++i) {
            Writable reduced;
            Writable current = sequence.get(i).get(colIdx);
            window.addLast(current);
            if (window.size() > this.lookback) {
                window.removeFirst();
            }
            if (window.size() < this.lookback && this.edgeCaseHandling == EdgeCaseHandling.SpecifiedValue) {
                reduced = this.edgeCaseValue;
            } else {
                IAggregableReduceOp<Writable, List<Writable>> reductionOp = AggregableReductionUtils.reduceColumn(Collections.singletonList(this.op), columnType, false, null);
                for (Writable w : window) {
                    reductionOp.accept(w);
                }
                reduced = (Writable)((List)reductionOp.get()).get(0);
            }
            ArrayList<Writable> outThisStep = new ArrayList<Writable>(sequence.get(i).size() + 1);
            outThisStep.addAll((Collection)sequence.get(i));
            outThisStep.add(reduced);
            out.add(outThisStep);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("SequenceMovingWindowReduceTransform can only be applied to sequences");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public String toString() {
        return "SequenceMovingWindowReduceTransform(columnName=\"" + this.columnName + "\",newColumnName=\"" + this.newColumnName + "\",lookback=" + this.lookback + ",op=" + this.op + ",edgeCaseHandling=" + this.edgeCaseHandling + (String)(this.edgeCaseHandling == EdgeCaseHandling.SpecifiedValue ? ",edgeCaseValue=" + this.edgeCaseValue : "") + ")";
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return this.columnNames();
    }

    @Override
    public String[] columnNames() {
        return this.getInputSchema().getColumnNames().toArray(new String[this.getInputSchema().numColumns()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public int getLookback() {
        return this.lookback;
    }

    public ReduceOp getOp() {
        return this.op;
    }

    public EdgeCaseHandling getEdgeCaseHandling() {
        return this.edgeCaseHandling;
    }

    public Writable getEdgeCaseValue() {
        return this.edgeCaseValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceMovingWindowReduceTransform)) {
            return false;
        }
        SequenceMovingWindowReduceTransform other = (SequenceMovingWindowReduceTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLookback() != other.getLookback()) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$newColumnName = this.getNewColumnName();
        String other$newColumnName = other.getNewColumnName();
        if (this$newColumnName == null ? other$newColumnName != null : !this$newColumnName.equals(other$newColumnName)) {
            return false;
        }
        ReduceOp this$op = this.getOp();
        ReduceOp other$op = other.getOp();
        if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
            return false;
        }
        EdgeCaseHandling this$edgeCaseHandling = this.getEdgeCaseHandling();
        EdgeCaseHandling other$edgeCaseHandling = other.getEdgeCaseHandling();
        if (this$edgeCaseHandling == null ? other$edgeCaseHandling != null : !((Object)((Object)this$edgeCaseHandling)).equals((Object)other$edgeCaseHandling)) {
            return false;
        }
        Writable this$edgeCaseValue = this.getEdgeCaseValue();
        Writable other$edgeCaseValue = other.getEdgeCaseValue();
        if (this$edgeCaseValue == null ? other$edgeCaseValue != null : !this$edgeCaseValue.equals(other$edgeCaseValue)) {
            return false;
        }
        Schema this$inputSchema = this.getInputSchema();
        Schema other$inputSchema = other.getInputSchema();
        return !(this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceMovingWindowReduceTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLookback();
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $newColumnName = this.getNewColumnName();
        result = result * 59 + ($newColumnName == null ? 43 : $newColumnName.hashCode());
        ReduceOp $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        EdgeCaseHandling $edgeCaseHandling = this.getEdgeCaseHandling();
        result = result * 59 + ($edgeCaseHandling == null ? 43 : ((Object)((Object)$edgeCaseHandling)).hashCode());
        Writable $edgeCaseValue = this.getEdgeCaseValue();
        result = result * 59 + ($edgeCaseValue == null ? 43 : $edgeCaseValue.hashCode());
        Schema $inputSchema = this.getInputSchema();
        result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
        return result;
    }

    public static enum EdgeCaseHandling {
        Default,
        SpecifiedValue;

    }
}

