/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.MathFunction;
import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class DoubleMathFunctionTransform
extends BaseDoubleTransform {
    private MathFunction mathFunction;

    public DoubleMathFunctionTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathFunction") MathFunction mathFunction) {
        super(columnName);
        this.mathFunction = mathFunction;
    }

    @Override
    public Writable map(Writable w) {
        switch (this.mathFunction) {
            case ABS: {
                return new DoubleWritable(Math.abs(w.toDouble()));
            }
            case ACOS: {
                return new DoubleWritable(Math.acos(w.toDouble()));
            }
            case ASIN: {
                return new DoubleWritable(Math.asin(w.toDouble()));
            }
            case ATAN: {
                return new DoubleWritable(Math.atan(w.toDouble()));
            }
            case CEIL: {
                return new DoubleWritable(Math.ceil(w.toDouble()));
            }
            case COS: {
                return new DoubleWritable(Math.cos(w.toDouble()));
            }
            case COSH: {
                return new DoubleWritable(Math.cosh(w.toDouble()));
            }
            case EXP: {
                return new DoubleWritable(Math.exp(w.toDouble()));
            }
            case FLOOR: {
                return new DoubleWritable(Math.floor(w.toDouble()));
            }
            case LOG: {
                return new DoubleWritable(Math.log(w.toDouble()));
            }
            case LOG10: {
                return new DoubleWritable(Math.log10(w.toDouble()));
            }
            case SIGNUM: {
                return new DoubleWritable(Math.signum(w.toDouble()));
            }
            case SIN: {
                return new DoubleWritable(Math.sin(w.toDouble()));
            }
            case SINH: {
                return new DoubleWritable(Math.sinh(w.toDouble()));
            }
            case SQRT: {
                return new DoubleWritable(Math.sqrt(w.toDouble()));
            }
            case TAN: {
                return new DoubleWritable(Math.tan(w.toDouble()));
            }
            case TANH: {
                return new DoubleWritable(Math.tanh(w.toDouble()));
            }
        }
        throw new RuntimeException("Unknown function: " + this.mathFunction);
    }

    @Override
    public Object map(Object input) {
        double d = ((Number)input).doubleValue();
        switch (this.mathFunction) {
            case ABS: {
                return Math.abs(d);
            }
            case ACOS: {
                return Math.acos(d);
            }
            case ASIN: {
                return Math.asin(d);
            }
            case ATAN: {
                return Math.atan(d);
            }
            case CEIL: {
                return Math.ceil(d);
            }
            case COS: {
                return Math.cos(d);
            }
            case COSH: {
                return Math.cosh(d);
            }
            case EXP: {
                return Math.exp(d);
            }
            case FLOOR: {
                return Math.floor(d);
            }
            case LOG: {
                return Math.log(d);
            }
            case LOG10: {
                return Math.log10(d);
            }
            case SIGNUM: {
                return Math.signum(d);
            }
            case SIN: {
                return Math.sin(d);
            }
            case SINH: {
                return Math.sinh(d);
            }
            case SQRT: {
                return Math.sqrt(d);
            }
            case TAN: {
                return Math.tan(d);
            }
            case TANH: {
                return Math.tanh(d);
            }
        }
        throw new RuntimeException("Unknown function: " + this.mathFunction);
    }

    public MathFunction getMathFunction() {
        return this.mathFunction;
    }

    public void setMathFunction(MathFunction mathFunction) {
        this.mathFunction = mathFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleMathFunctionTransform)) {
            return false;
        }
        DoubleMathFunctionTransform other = (DoubleMathFunctionTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MathFunction this$mathFunction = this.getMathFunction();
        MathFunction other$mathFunction = other.getMathFunction();
        return !(this$mathFunction == null ? other$mathFunction != null : !((Object)((Object)this$mathFunction)).equals((Object)other$mathFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DoubleMathFunctionTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MathFunction $mathFunction = this.getMathFunction();
        result = result * 59 + ($mathFunction == null ? 43 : ((Object)((Object)$mathFunction)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DoubleMathFunctionTransform(mathFunction=" + this.getMathFunction() + ")";
    }
}

