/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.reduce;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.ReduceOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.ops.AggregableCheckingOp;
import org.datavec.api.transform.ops.AggregableMultiOp;
import org.datavec.api.transform.ops.AggregatorImpls;
import org.datavec.api.transform.ops.ByteWritableOp;
import org.datavec.api.transform.ops.DoubleWritableOp;
import org.datavec.api.transform.ops.FloatWritableOp;
import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.transform.ops.IntWritableOp;
import org.datavec.api.transform.ops.LongWritableOp;
import org.datavec.api.transform.ops.StringAggregatorImpls;
import org.datavec.api.transform.ops.StringWritableOp;
import org.datavec.api.writable.Writable;

public class AggregableReductionUtils {
    private AggregableReductionUtils() {
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceColumn(List<ReduceOp> op, ColumnType type, boolean ignoreInvalid, ColumnMetaData metaData) {
        switch (type) {
            case Integer: {
                return AggregableReductionUtils.reduceIntColumn(op, ignoreInvalid, metaData);
            }
            case Long: {
                return AggregableReductionUtils.reduceLongColumn(op, ignoreInvalid, metaData);
            }
            case Float: {
                return AggregableReductionUtils.reduceFloatColumn(op, ignoreInvalid, metaData);
            }
            case Double: {
                return AggregableReductionUtils.reduceDoubleColumn(op, ignoreInvalid, metaData);
            }
            case String: 
            case Categorical: {
                return AggregableReductionUtils.reduceStringOrCategoricalColumn(op, ignoreInvalid, metaData);
            }
            case Time: {
                return AggregableReductionUtils.reduceTimeColumn(op, ignoreInvalid, metaData);
            }
            case Bytes: {
                return AggregableReductionUtils.reduceBytesColumn(op, ignoreInvalid, metaData);
            }
        }
        throw new UnsupportedOperationException("Unknown or not implemented column type: " + type);
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceIntColumn(List<ReduceOp> lop, boolean ignoreInvalid, ColumnMetaData metaData) {
        ArrayList res = new ArrayList(lop.size());
        block16: for (int i = 0; i < lop.size(); ++i) {
            switch (lop.get(i)) {
                case Prod: {
                    res.add(new AggregatorImpls.AggregableProd());
                    continue block16;
                }
                case Min: {
                    res.add(new AggregatorImpls.AggregableMin());
                    continue block16;
                }
                case Max: {
                    res.add(new AggregatorImpls.AggregableMax());
                    continue block16;
                }
                case Range: {
                    res.add(new AggregatorImpls.AggregableRange());
                    continue block16;
                }
                case Sum: {
                    res.add(new AggregatorImpls.AggregableSum());
                    continue block16;
                }
                case Mean: {
                    res.add(new AggregatorImpls.AggregableMean());
                    continue block16;
                }
                case Stdev: {
                    res.add(new AggregatorImpls.AggregableStdDev());
                    continue block16;
                }
                case UncorrectedStdDev: {
                    res.add(new AggregatorImpls.AggregableUncorrectedStdDev());
                    continue block16;
                }
                case Variance: {
                    res.add(new AggregatorImpls.AggregableVariance());
                    continue block16;
                }
                case PopulationVariance: {
                    res.add(new AggregatorImpls.AggregablePopulationVariance());
                    continue block16;
                }
                case Count: {
                    res.add(new AggregatorImpls.AggregableCount());
                    continue block16;
                }
                case CountUnique: {
                    res.add(new AggregatorImpls.AggregableCountUnique());
                    continue block16;
                }
                case TakeFirst: {
                    res.add(new AggregatorImpls.AggregableFirst());
                    continue block16;
                }
                case TakeLast: {
                    res.add(new AggregatorImpls.AggregableLast());
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown or not implemented op: " + (Object)((Object)lop.get(i)));
                }
            }
        }
        IntWritableOp<List<Writable>> thisOp = new IntWritableOp<List<Writable>>(new AggregableMultiOp<Integer>(res));
        if (ignoreInvalid) {
            return new AggregableCheckingOp<List<Writable>>(thisOp, metaData);
        }
        return thisOp;
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceLongColumn(List<ReduceOp> lop, boolean ignoreInvalid, ColumnMetaData metaData) {
        ArrayList res = new ArrayList(lop.size());
        block16: for (int i = 0; i < lop.size(); ++i) {
            switch (lop.get(i)) {
                case Prod: {
                    res.add(new AggregatorImpls.AggregableProd());
                    continue block16;
                }
                case Min: {
                    res.add(new AggregatorImpls.AggregableMin());
                    continue block16;
                }
                case Max: {
                    res.add(new AggregatorImpls.AggregableMax());
                    continue block16;
                }
                case Range: {
                    res.add(new AggregatorImpls.AggregableRange());
                    continue block16;
                }
                case Sum: {
                    res.add(new AggregatorImpls.AggregableSum());
                    continue block16;
                }
                case Stdev: {
                    res.add(new AggregatorImpls.AggregableStdDev());
                    continue block16;
                }
                case UncorrectedStdDev: {
                    res.add(new AggregatorImpls.AggregableUncorrectedStdDev());
                    continue block16;
                }
                case Variance: {
                    res.add(new AggregatorImpls.AggregableVariance());
                    continue block16;
                }
                case PopulationVariance: {
                    res.add(new AggregatorImpls.AggregablePopulationVariance());
                    continue block16;
                }
                case Mean: {
                    res.add(new AggregatorImpls.AggregableMean());
                    continue block16;
                }
                case Count: {
                    res.add(new AggregatorImpls.AggregableCount());
                    continue block16;
                }
                case CountUnique: {
                    res.add(new AggregatorImpls.AggregableCountUnique());
                    continue block16;
                }
                case TakeFirst: {
                    res.add(new AggregatorImpls.AggregableFirst());
                    continue block16;
                }
                case TakeLast: {
                    res.add(new AggregatorImpls.AggregableLast());
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown or not implemented op: " + (Object)((Object)lop.get(i)));
                }
            }
        }
        LongWritableOp<List<Writable>> thisOp = new LongWritableOp<List<Writable>>(new AggregableMultiOp<Long>(res));
        if (ignoreInvalid) {
            return new AggregableCheckingOp<List<Writable>>(thisOp, metaData);
        }
        return thisOp;
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceFloatColumn(List<ReduceOp> lop, boolean ignoreInvalid, ColumnMetaData metaData) {
        ArrayList res = new ArrayList(lop.size());
        block16: for (int i = 0; i < lop.size(); ++i) {
            switch (lop.get(i)) {
                case Prod: {
                    res.add(new AggregatorImpls.AggregableProd());
                    continue block16;
                }
                case Min: {
                    res.add(new AggregatorImpls.AggregableMin());
                    continue block16;
                }
                case Max: {
                    res.add(new AggregatorImpls.AggregableMax());
                    continue block16;
                }
                case Range: {
                    res.add(new AggregatorImpls.AggregableRange());
                    continue block16;
                }
                case Sum: {
                    res.add(new AggregatorImpls.AggregableSum());
                    continue block16;
                }
                case Mean: {
                    res.add(new AggregatorImpls.AggregableMean());
                    continue block16;
                }
                case Stdev: {
                    res.add(new AggregatorImpls.AggregableStdDev());
                    continue block16;
                }
                case UncorrectedStdDev: {
                    res.add(new AggregatorImpls.AggregableUncorrectedStdDev());
                    continue block16;
                }
                case Variance: {
                    res.add(new AggregatorImpls.AggregableVariance());
                    continue block16;
                }
                case PopulationVariance: {
                    res.add(new AggregatorImpls.AggregablePopulationVariance());
                    continue block16;
                }
                case Count: {
                    res.add(new AggregatorImpls.AggregableCount());
                    continue block16;
                }
                case CountUnique: {
                    res.add(new AggregatorImpls.AggregableCountUnique());
                    continue block16;
                }
                case TakeFirst: {
                    res.add(new AggregatorImpls.AggregableFirst());
                    continue block16;
                }
                case TakeLast: {
                    res.add(new AggregatorImpls.AggregableLast());
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown or not implemented op: " + (Object)((Object)lop.get(i)));
                }
            }
        }
        FloatWritableOp<List<Writable>> thisOp = new FloatWritableOp<List<Writable>>(new AggregableMultiOp<Float>(res));
        if (ignoreInvalid) {
            return new AggregableCheckingOp<List<Writable>>(thisOp, metaData);
        }
        return thisOp;
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceDoubleColumn(List<ReduceOp> lop, boolean ignoreInvalid, ColumnMetaData metaData) {
        ArrayList res = new ArrayList(lop.size());
        block16: for (int i = 0; i < lop.size(); ++i) {
            switch (lop.get(i)) {
                case Prod: {
                    res.add(new AggregatorImpls.AggregableProd());
                    continue block16;
                }
                case Min: {
                    res.add(new AggregatorImpls.AggregableMin());
                    continue block16;
                }
                case Max: {
                    res.add(new AggregatorImpls.AggregableMax());
                    continue block16;
                }
                case Range: {
                    res.add(new AggregatorImpls.AggregableRange());
                    continue block16;
                }
                case Sum: {
                    res.add(new AggregatorImpls.AggregableSum());
                    continue block16;
                }
                case Mean: {
                    res.add(new AggregatorImpls.AggregableMean());
                    continue block16;
                }
                case Stdev: {
                    res.add(new AggregatorImpls.AggregableStdDev());
                    continue block16;
                }
                case UncorrectedStdDev: {
                    res.add(new AggregatorImpls.AggregableUncorrectedStdDev());
                    continue block16;
                }
                case Variance: {
                    res.add(new AggregatorImpls.AggregableVariance());
                    continue block16;
                }
                case PopulationVariance: {
                    res.add(new AggregatorImpls.AggregablePopulationVariance());
                    continue block16;
                }
                case Count: {
                    res.add(new AggregatorImpls.AggregableCount());
                    continue block16;
                }
                case CountUnique: {
                    res.add(new AggregatorImpls.AggregableCountUnique());
                    continue block16;
                }
                case TakeFirst: {
                    res.add(new AggregatorImpls.AggregableFirst());
                    continue block16;
                }
                case TakeLast: {
                    res.add(new AggregatorImpls.AggregableLast());
                    continue block16;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown or not implemented op: " + (Object)((Object)lop.get(i)));
                }
            }
        }
        DoubleWritableOp<List<Writable>> thisOp = new DoubleWritableOp<List<Writable>>(new AggregableMultiOp<Double>(res));
        if (ignoreInvalid) {
            return new AggregableCheckingOp<List<Writable>>(thisOp, metaData);
        }
        return thisOp;
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceStringOrCategoricalColumn(List<ReduceOp> lop, boolean ignoreInvalid, ColumnMetaData metaData) {
        ArrayList res = new ArrayList(lop.size());
        block8: for (int i = 0; i < lop.size(); ++i) {
            switch (lop.get(i)) {
                case Count: {
                    res.add(new AggregatorImpls.AggregableCount());
                    continue block8;
                }
                case CountUnique: {
                    res.add(new AggregatorImpls.AggregableCountUnique());
                    continue block8;
                }
                case TakeFirst: {
                    res.add(new AggregatorImpls.AggregableFirst());
                    continue block8;
                }
                case TakeLast: {
                    res.add(new AggregatorImpls.AggregableLast());
                    continue block8;
                }
                case Append: {
                    res.add(new StringAggregatorImpls.AggregableStringAppend());
                    continue block8;
                }
                case Prepend: {
                    res.add(new StringAggregatorImpls.AggregableStringPrepend());
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot execute op \"" + (Object)((Object)lop.get(i)) + "\" on String/Categorical column (can only perform Append, Prepend, Count, CountUnique, TakeFirst and TakeLast ops on categorical columns)");
                }
            }
        }
        StringWritableOp<List<Writable>> thisOp = new StringWritableOp<List<Writable>>(new AggregableMultiOp<String>(res));
        if (ignoreInvalid) {
            return new AggregableCheckingOp<List<Writable>>(thisOp, metaData);
        }
        return thisOp;
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceTimeColumn(List<ReduceOp> lop, boolean ignoreInvalid, ColumnMetaData metaData) {
        ArrayList res = new ArrayList(lop.size());
        block11: for (int i = 0; i < lop.size(); ++i) {
            switch (lop.get(i)) {
                case Min: {
                    res.add(new AggregatorImpls.AggregableMin());
                    continue block11;
                }
                case Max: {
                    res.add(new AggregatorImpls.AggregableMax());
                    continue block11;
                }
                case Range: {
                    res.add(new AggregatorImpls.AggregableRange());
                    continue block11;
                }
                case Mean: {
                    res.add(new AggregatorImpls.AggregableMean());
                    continue block11;
                }
                case Stdev: {
                    res.add(new AggregatorImpls.AggregableStdDev());
                    continue block11;
                }
                case Count: {
                    res.add(new AggregatorImpls.AggregableCount());
                    continue block11;
                }
                case CountUnique: {
                    res.add(new AggregatorImpls.AggregableCountUnique());
                    continue block11;
                }
                case TakeFirst: {
                    res.add(new AggregatorImpls.AggregableFirst());
                    continue block11;
                }
                case TakeLast: {
                    res.add(new AggregatorImpls.AggregableLast());
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException("Reduction op \"" + (Object)((Object)lop.get(i)) + "\" not supported on time columns");
                }
            }
        }
        LongWritableOp<List<Writable>> thisOp = new LongWritableOp<List<Writable>>(new AggregableMultiOp<Long>(res));
        if (ignoreInvalid) {
            return new AggregableCheckingOp<List<Writable>>(thisOp, metaData);
        }
        return thisOp;
    }

    public static IAggregableReduceOp<Writable, List<Writable>> reduceBytesColumn(List<ReduceOp> lop, boolean ignoreInvalid, ColumnMetaData metaData) {
        ArrayList res = new ArrayList(lop.size());
        block4: for (int i = 0; i < lop.size(); ++i) {
            switch (lop.get(i)) {
                case TakeFirst: {
                    res.add(new AggregatorImpls.AggregableFirst());
                    continue block4;
                }
                case TakeLast: {
                    res.add(new AggregatorImpls.AggregableLast());
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot execute op \"" + (Object)((Object)lop.get(i)) + "\" on Bytes column (can only perform TakeFirst and TakeLast ops on bytes columns)");
                }
            }
        }
        ByteWritableOp<List<Writable>> thisOp = new ByteWritableOp<List<Writable>>(new AggregableMultiOp<Byte>(res));
        if (ignoreInvalid) {
            return new AggregableCheckingOp<List<Writable>>(thisOp, metaData);
        }
        return thisOp;
    }
}

