/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.floattransform;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.FloatMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FloatMathOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final float scalar;

    public FloatMathOpTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="scalar") float scalar) {
        super(columnName);
        this.mathOp = mathOp;
        this.scalar = scalar;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newColumnName, ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof FloatMetaData)) {
            throw new IllegalStateException("Column is not an float column");
        }
        FloatMetaData meta = (FloatMetaData)oldColumnType;
        Float minValue = meta.getMinAllowedValue();
        Float maxValue = meta.getMaxAllowedValue();
        if (minValue != null) {
            minValue = Float.valueOf(this.doOp(minValue.floatValue()));
        }
        if (maxValue != null) {
            maxValue = Float.valueOf(this.doOp(maxValue.floatValue()));
        }
        if (minValue != null && maxValue != null && minValue.floatValue() > maxValue.floatValue()) {
            Float temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        return new FloatMetaData(newColumnName, minValue, maxValue);
    }

    private float doOp(float input) {
        switch (this.mathOp) {
            case Add: {
                return input + this.scalar;
            }
            case Subtract: {
                return input - this.scalar;
            }
            case Multiply: {
                return input * this.scalar;
            }
            case Divide: {
                return input / this.scalar;
            }
            case Modulus: {
                return input % this.scalar;
            }
            case ReverseSubtract: {
                return this.scalar - input;
            }
            case ReverseDivide: {
                return this.scalar / input;
            }
            case ScalarMin: {
                return Math.min(input, this.scalar);
            }
            case ScalarMax: {
                return Math.max(input, this.scalar);
            }
        }
        throw new IllegalStateException("Unknown or not implemented math op: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new FloatWritable(this.doOp(columnWritable.toFloat()));
    }

    @Override
    public String toString() {
        return "FloatMathOpTransform(mathOp=" + (Object)((Object)this.mathOp) + ",scalar=" + this.scalar + ")";
    }

    @Override
    public Object map(Object input) {
        if (input instanceof Number) {
            Number number = (Number)input;
            return Float.valueOf(this.doOp(number.floatValue()));
        }
        throw new IllegalArgumentException("Input must be a number");
    }

    @Override
    public Object mapSequence(Object sequence) {
        List list = (List)sequence;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : list) {
            ret.add(this.map(o));
        }
        return ret;
    }

    public MathOp getMathOp() {
        return this.mathOp;
    }

    public float getScalar() {
        return this.scalar;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatMathOpTransform)) {
            return false;
        }
        FloatMathOpTransform other = (FloatMathOpTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getScalar(), other.getScalar()) != 0) {
            return false;
        }
        MathOp this$mathOp = this.getMathOp();
        MathOp other$mathOp = other.getMathOp();
        return !(this$mathOp == null ? other$mathOp != null : !((Object)((Object)this$mathOp)).equals((Object)other$mathOp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FloatMathOpTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getScalar());
        MathOp $mathOp = this.getMathOp();
        result = result * 59 + ($mathOp == null ? 43 : ((Object)((Object)$mathOp)).hashCode());
        return result;
    }
}

