/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ops;

import org.datavec.api.transform.ops.IAggregableReduceOp;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class StringAggregatorImpls {

    public static class AggregableStringPrepend
    extends AggregableStringReduce {
        @Override
        public <W extends IAggregableReduceOp<String, Writable>> void combine(W accu) {
            if (!(accu instanceof AggregableStringPrepend)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where" + this.getClass().getName() + " expected");
            }
            this.sb.append((CharSequence)((AggregableStringPrepend)accu).getSb());
        }

        @Override
        public void accept(String s) {
            String rev = new StringBuilder(s).reverse().toString();
            this.sb.append(rev);
        }

        @Override
        public Writable get() {
            return new Text(this.sb.reverse().toString());
        }
    }

    public static class AggregableStringAppend
    extends AggregableStringReduce {
        @Override
        public <W extends IAggregableReduceOp<String, Writable>> void combine(W accu) {
            if (!(accu instanceof AggregableStringAppend)) {
                throw new UnsupportedOperationException("Tried to combine() incompatible " + accu.getClass().getName() + " operator where" + this.getClass().getName() + " expected");
            }
            this.sb.append((CharSequence)((AggregableStringAppend)accu).getSb());
        }

        @Override
        public void accept(String s) {
            this.sb.append(s);
        }

        @Override
        public Writable get() {
            return new Text(this.sb.toString());
        }
    }

    private static abstract class AggregableStringReduce
    implements IAggregableReduceOp<String, Writable> {
        protected StringBuilder sb = new StringBuilder();

        private AggregableStringReduce() {
        }

        public StringBuilder getSb() {
            return this.sb;
        }
    }
}

