/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.writer.impl.csv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.writer.impl.FileRecordWriter;
import org.datavec.api.writable.Writable;

public class CSVRecordWriter
extends FileRecordWriter {
    public static final String DEFAULT_DELIMITER = ",";
    private final byte[] delimBytes;
    private boolean firstLine = true;

    public CSVRecordWriter() {
        this.delimBytes = DEFAULT_DELIMITER.getBytes(this.encoding);
    }

    public CSVRecordWriter(File path) throws FileNotFoundException {
        this(path, false, DEFAULT_CHARSET, DEFAULT_DELIMITER);
    }

    public CSVRecordWriter(File path, boolean append) throws FileNotFoundException {
        this(path, append, DEFAULT_CHARSET, DEFAULT_DELIMITER);
    }

    public CSVRecordWriter(Configuration conf) throws FileNotFoundException {
        super(conf);
        this.delimBytes = DEFAULT_DELIMITER.getBytes(this.encoding);
    }

    public CSVRecordWriter(File path, boolean append, Charset encoding, String delimiter) throws FileNotFoundException {
        super(path, append, encoding);
        this.delimBytes = delimiter.getBytes(encoding);
    }

    @Override
    public void write(List<Writable> record) throws IOException {
        if (!record.isEmpty()) {
            if (!this.firstLine) {
                this.out.write("\n".getBytes());
            } else {
                this.firstLine = false;
            }
            int count = 0;
            int last = record.size() - 1;
            for (Writable w : record) {
                this.out.write(w.toString().getBytes(this.encoding));
                if (count++ == last) continue;
                this.out.write(this.delimBytes);
            }
            this.out.flush();
        }
    }
}

