/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class AppendStringColumnTransform
extends BaseColumnTransform {
    private String toAppend;

    public AppendStringColumnTransform(String columnName, String toAppend) {
        super(columnName);
        this.toAppend = toAppend;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        return new StringMetaData(newName);
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new Text(columnWritable + this.toAppend);
    }

    @Override
    public String toString() {
        return "AppendStringColumnTransform(append=\"" + this.toAppend + "\")";
    }

    @Override
    public Object map(Object input) {
        return input.toString() + this.toAppend;
    }
}

