/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import java.util.ArrayList;
import java.util.List;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;

public class AddConstantColumnTransform
implements Transform {
    private final String newColumnName;
    private final ColumnType newColumnType;
    private final Writable fixedValue;
    private Schema inputSchema;

    public AddConstantColumnTransform(String newColumnName, ColumnType newColumnType, Writable fixedValue) {
        this.newColumnName = newColumnName;
        this.newColumnType = newColumnType;
        this.fixedValue = fixedValue;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        ArrayList<ColumnMetaData> outMeta = new ArrayList<ColumnMetaData>();
        outMeta.addAll(inputSchema.getColumnMetaData());
        ColumnMetaData newColMeta = this.newColumnType.newColumnMetaData(this.newColumnName);
        outMeta.add(newColMeta);
        return inputSchema.newSchema(outMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    @Override
    public String outputColumnName() {
        return this.newColumnName;
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.outputColumnName()};
    }

    @Override
    public String[] columnNames() {
        return new String[0];
    }

    @Override
    public String columnName() {
        return this.newColumnName;
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        ArrayList<Writable> out = new ArrayList<Writable>(writables.size() + 1);
        out.addAll(writables);
        out.add(this.fixedValue);
        return out;
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        ArrayList<List<Writable>> outSeq = new ArrayList<List<Writable>>(sequence.size());
        for (List<Writable> l : sequence) {
            outSeq.add(this.map(l));
        }
        return outSeq;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException();
    }
}

