/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.datavec.api.berkeley.Triple;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.Record;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataLine;
import org.datavec.api.records.reader.BaseRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.InputStreamInputSplit;
import org.datavec.api.split.StringSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class LineRecordReader
extends BaseRecordReader {
    private Iterator<String> iter;
    protected URI[] locations;
    protected int splitIndex = 0;
    protected int lineIndex = 0;
    protected Configuration conf;
    protected InputSplit inputSplit;

    @Override
    public void initialize(InputSplit split) throws IOException, InterruptedException {
        this.inputSplit = split;
        this.iter = this.getIterator(0);
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        this.initialize(split);
    }

    @Override
    public List<Writable> next() {
        ArrayList<Writable> ret = new ArrayList<Writable>();
        if (this.iter.hasNext()) {
            String record = this.iter.next();
            this.invokeListeners(record);
            ret.add(new Text(record));
            ++this.lineIndex;
            return ret;
        }
        if (!(this.inputSplit instanceof StringSplit) && this.splitIndex < this.locations.length - 1) {
            ++this.splitIndex;
            this.lineIndex = 0;
            try {
                this.close();
                this.iter = IOUtils.lineIterator((Reader)new InputStreamReader(this.locations[this.splitIndex].toURL().openStream()));
                this.onLocationOpen(this.locations[this.splitIndex]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.lineIndex = 0;
            if (this.iter.hasNext()) {
                String record = this.iter.next();
                this.invokeListeners(record);
                ret.add(new Text(record));
                return ret;
            }
        }
        throw new NoSuchElementException("No more elements found!");
    }

    @Override
    public boolean hasNext() {
        if (this.iter != null && this.iter.hasNext()) {
            return true;
        }
        if (this.locations != null && !(this.inputSplit instanceof StringSplit) && this.splitIndex < this.locations.length - 1) {
            ++this.splitIndex;
            this.lineIndex = 0;
            try {
                this.close();
                this.iter = IOUtils.lineIterator((Reader)new InputStreamReader(this.locations[this.splitIndex].toURL().openStream()));
                this.onLocationOpen(this.locations[this.splitIndex]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.iter.hasNext();
        }
        return false;
    }

    protected void onLocationOpen(URI location) {
    }

    @Override
    public void close() throws IOException {
        if (this.iter != null && this.iter instanceof LineIterator) {
            LineIterator iter2 = (LineIterator)this.iter;
            iter2.close();
        }
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public void reset() {
        if (this.inputSplit == null) {
            throw new UnsupportedOperationException("Cannot reset without first initializing");
        }
        try {
            this.initialize(this.inputSplit);
            this.splitIndex = 0;
        }
        catch (Exception e) {
            throw new RuntimeException("Error during LineRecordReader reset", e);
        }
        this.lineIndex = 0;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        this.invokeListeners(uri);
        BufferedReader br = new BufferedReader(new InputStreamReader(dataInputStream));
        String line = br.readLine();
        return Collections.singletonList(new Text(line));
    }

    protected Iterator<String> getIterator(int location) {
        LineIterator iterator = null;
        if (this.inputSplit instanceof StringSplit) {
            StringSplit stringSplit = (StringSplit)this.inputSplit;
            iterator = Collections.singletonList(stringSplit.getData()).listIterator();
        } else if (this.inputSplit instanceof InputStreamInputSplit) {
            InputStream is = ((InputStreamInputSplit)this.inputSplit).getIs();
            if (is != null) {
                iterator = IOUtils.lineIterator((Reader)new InputStreamReader(is));
            }
        } else {
            this.locations = this.inputSplit.locations();
            if (this.locations != null && this.locations.length > 0) {
                InputStream inputStream;
                try {
                    inputStream = this.locations[location].toURL().openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                iterator = IOUtils.lineIterator((Reader)new InputStreamReader(inputStream));
            }
        }
        if (iterator == null) {
            throw new UnsupportedOperationException("Unknown input split: " + this.inputSplit);
        }
        return iterator;
    }

    protected void closeIfRequired(Iterator<String> iterator) {
        if (iterator instanceof LineIterator) {
            LineIterator iter = (LineIterator)iterator;
            iter.close();
        }
    }

    @Override
    public Record nextRecord() {
        List<Writable> next = this.next();
        URI uri = this.locations == null || this.locations.length < 1 ? null : this.locations[this.splitIndex];
        RecordMetaDataLine meta = new RecordMetaDataLine(this.lineIndex - 1, uri, LineRecordReader.class);
        return new org.datavec.api.records.impl.Record(next, meta);
    }

    @Override
    public Record loadFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Record> loadFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<Triple<Integer, RecordMetaDataLine, List>> list = new ArrayList<Triple<Integer, RecordMetaDataLine, List>>();
        HashSet<URI> uris = new HashSet<URI>();
        Iterator<RecordMetaData> iter = recordMetaDatas.iterator();
        int count = 0;
        while (iter.hasNext()) {
            RecordMetaData rmd = iter.next();
            if (!(rmd instanceof RecordMetaDataLine)) {
                throw new IllegalArgumentException("Invalid metadata; expected RecordMetaDataLine instance; got: " + rmd);
            }
            list.add(new Triple<Integer, RecordMetaDataLine, List>(count++, (RecordMetaDataLine)rmd, null));
            if (rmd.getURI() == null) continue;
            uris.add(rmd.getURI());
        }
        ArrayList sortedURIs = null;
        if (uris.size() > 0) {
            sortedURIs = new ArrayList(uris);
            Collections.sort(sortedURIs);
        }
        Collections.sort(list, new Comparator<Triple<Integer, RecordMetaDataLine, List<Writable>>>(){

            @Override
            public int compare(Triple<Integer, RecordMetaDataLine, List<Writable>> o1, Triple<Integer, RecordMetaDataLine, List<Writable>> o2) {
                if (o1.getSecond().getURI() != null && !o1.getSecond().getURI().equals(o2.getSecond().getURI())) {
                    return o1.getSecond().getURI().compareTo(o2.getSecond().getURI());
                }
                return Integer.compare(o1.getSecond().getLineNumber(), o2.getSecond().getLineNumber());
            }
        });
        if (uris.size() > 0 && sortedURIs != null) {
            Iterator metaIter = list.iterator();
            URI currentURI = (URI)sortedURIs.get(0);
            LineIterator lineIterator = IOUtils.lineIterator((Reader)new InputStreamReader(currentURI.toURL().openStream()));
            int currentURIIdx = 0;
            int currentLineIdx = 0;
            String line = (String)lineIterator.next();
            while (metaIter.hasNext()) {
                void var9_10;
                Triple t = (Triple)metaIter.next();
                URI thisURI = ((RecordMetaDataLine)t.getSecond()).getURI();
                int nextLineIdx = ((RecordMetaDataLine)t.getSecond()).getLineNumber();
                while (!currentURI.equals(thisURI)) {
                    if (++currentURIIdx >= sortedURIs.size()) {
                        throw new IllegalStateException("Count not find URI " + thisURI + " in URIs list: " + sortedURIs);
                    }
                    currentURI = (URI)sortedURIs.get(currentURIIdx);
                    currentLineIdx = 0;
                    if (!currentURI.equals(thisURI)) continue;
                    this.closeIfRequired((Iterator<String>)var9_10);
                    LineIterator lineIterator2 = IOUtils.lineIterator((Reader)new InputStreamReader(currentURI.toURL().openStream()));
                    line = (String)lineIterator2.next();
                }
                while (currentLineIdx < nextLineIdx && var9_10.hasNext()) {
                    line = (String)var9_10.next();
                    ++currentLineIdx;
                }
                if (currentLineIdx < nextLineIdx && !var9_10.hasNext()) {
                    throw new IllegalStateException("Could not get line " + nextLineIdx + " from URI " + currentURI + ": has only " + currentLineIdx + " lines");
                }
                t.setThird(Collections.singletonList(new Text(line)));
            }
        } else {
            Iterator<String> iterator = this.getIterator(0);
            Iterator metaIter = list.iterator();
            boolean bl = false;
            String line = iterator.next();
            while (metaIter.hasNext()) {
                void var9_13;
                Triple t = (Triple)metaIter.next();
                int nextLineIdx = ((RecordMetaDataLine)t.getSecond()).getLineNumber();
                while (var9_13 < nextLineIdx && iterator.hasNext()) {
                    line = iterator.next();
                    ++var9_13;
                }
                t.setThird(Collections.singletonList(new Text(line)));
            }
            this.closeIfRequired(iterator);
        }
        Collections.sort(list, new Comparator<Triple<Integer, RecordMetaDataLine, List<Writable>>>(){

            @Override
            public int compare(Triple<Integer, RecordMetaDataLine, List<Writable>> o1, Triple<Integer, RecordMetaDataLine, List<Writable>> o2) {
                return Integer.compare(o1.getFirst(), o2.getFirst());
            }
        });
        ArrayList<Record> out = new ArrayList<Record>();
        for (Triple triple : list) {
            out.add(new org.datavec.api.records.impl.Record((List)triple.getThird(), (RecordMetaData)triple.getSecond()));
        }
        return out;
    }
}

