/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.longtransform;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;

public class LongColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public LongColumnsMathOpTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="mathOp") MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData(String newColumnName) {
        return new LongMetaData(newColumnName);
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                long sum = 0L;
                for (Writable w : input) {
                    sum += w.toLong();
                }
                return new LongWritable(sum);
            }
            case Subtract: {
                return new LongWritable(input[0].toLong() - input[1].toLong());
            }
            case Multiply: {
                long product = 1L;
                for (Writable w : input) {
                    product *= w.toLong();
                }
                return new LongWritable(product);
            }
            case Divide: {
                return new LongWritable(input[0].toLong() / input[1].toLong());
            }
            case Modulus: {
                return new LongWritable(input[0].toLong() % input[1].toLong());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public String toString() {
        return "LongColumnsMathOpTransform(newColumnName=\"" + this.newColumnName + "\",mathOp=" + (Object)((Object)this.mathOp) + ",columns=" + Arrays.toString(this.columns) + ")";
    }
}

