/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.regex;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class RegexLineRecordReader
extends LineRecordReader {
    public static final String SKIP_NUM_LINES = NAME_SPACE + ".skipnumlines";
    private String regex;
    private int skipNumLines;
    private Pattern pattern;
    private int numLinesSkipped;
    private int currLine = 0;

    public RegexLineRecordReader(String regex, int skipNumLines) {
        this.regex = regex;
        this.skipNumLines = skipNumLines;
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.skipNumLines = conf.getInt(SKIP_NUM_LINES, this.skipNumLines);
    }

    @Override
    public List<Writable> next() {
        if (this.numLinesSkipped < this.skipNumLines) {
            int i = this.numLinesSkipped;
            while (i < this.skipNumLines) {
                if (!this.hasNext()) {
                    return new ArrayList<Writable>();
                }
                super.next();
                ++i;
                ++this.numLinesSkipped;
            }
        }
        Text t = (Text)super.next().iterator().next();
        String val = t.toString();
        return this.getRecord(val);
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        Writable w = super.record(uri, dataInputStream).get(0);
        return this.getRecord(w.toString());
    }

    private List<Writable> getRecord(String line) {
        ArrayList<Writable> ret;
        Matcher m = this.pattern.matcher(line);
        if (m.matches()) {
            int count = m.groupCount();
            ret = new ArrayList<Writable>(count);
            for (int i = 1; i <= count; ++i) {
                ret.add(new Text(m.group(i)));
            }
        } else {
            throw new IllegalStateException("Invalid line: line does not match regex (line #" + this.currLine + ", regex=\"" + this.regex + "\"; line=\"" + line + "\"");
        }
        return ret;
    }

    @Override
    public void reset() {
        super.reset();
        this.numLinesSkipped = 0;
    }
}

