/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class CSVRecordReader
extends LineRecordReader {
    private boolean skippedLines = false;
    private int skipNumLines = 0;
    private String delimiter = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    public static final String DEFAULT_DELIMITER = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    public static final String SKIP_NUM_LINES = NAME_SPACE + ".skipnumlines";
    public static final String DELIMITER = NAME_SPACE + ".delimiter";

    public CSVRecordReader(int skipNumLines) {
        this(skipNumLines, DEFAULT_DELIMITER);
    }

    public CSVRecordReader(int skipNumLines, String delimiter) {
        this.skipNumLines = skipNumLines;
        this.delimiter = delimiter;
    }

    public CSVRecordReader() {
        this(0, DEFAULT_DELIMITER);
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        this.skipNumLines = conf.getInt(SKIP_NUM_LINES, this.skipNumLines);
        this.delimiter = conf.get(DELIMITER, DEFAULT_DELIMITER);
    }

    @Override
    public List<Writable> next() {
        if (!this.skippedLines && this.skipNumLines > 0) {
            for (int i = 0; i < this.skipNumLines; ++i) {
                if (!this.hasNext()) {
                    return new ArrayList<Writable>();
                }
                super.next();
            }
            this.skippedLines = true;
        }
        Text t = (Text)super.next().iterator().next();
        String val = t.toString();
        String[] split = val.split(this.delimiter, -1);
        ArrayList<Writable> ret = new ArrayList<Writable>();
        for (String s : split) {
            ret.add(new Text(s));
        }
        return ret;
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading CSV data from DataInputStream not yet implemented");
    }

    @Override
    public void reset() {
        super.reset();
        this.skippedLines = false;
    }

    @Override
    protected void onLocationOpen(URI location) {
        this.skippedLines = false;
    }
}

