/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class StringListToCategoricalSetTransform
extends BaseTransform {
    private final String columnName;
    private final List<String> newColumnNames;
    private final List<String> categoryTokens;
    private final String delim;
    private final Map<String, Integer> map;
    private int columIdx = -1;

    public StringListToCategoricalSetTransform(String columnName, List<String> newColumnNames, List<String> categoryTokens, String delim) {
        if (newColumnNames.size() != categoryTokens.size()) {
            throw new IllegalArgumentException("Names/tokens sizes cannot differ");
        }
        this.columnName = columnName;
        this.newColumnNames = newColumnNames;
        this.categoryTokens = categoryTokens;
        this.delim = delim;
        this.map = new HashMap<String, Integer>();
        for (int i = 0; i < categoryTokens.size(); ++i) {
            this.map.put(categoryTokens.get(i), i);
        }
    }

    @Override
    public Schema transform(Schema inputSchema) {
        int colIdx = inputSchema.getIndexOfColumn(this.columnName);
        List<ColumnMetaData> oldMeta = inputSchema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(oldMeta.size() + this.newColumnNames.size() - 1);
        List<String> oldNames = inputSchema.getColumnNames();
        ArrayList<String> newNames = new ArrayList<String>(oldMeta.size() + this.newColumnNames.size() - 1);
        Iterator<ColumnMetaData> typesIter = oldMeta.iterator();
        Iterator<String> namesIter = oldNames.iterator();
        int i = 0;
        while (typesIter.hasNext()) {
            ColumnMetaData t = typesIter.next();
            String name = namesIter.next();
            if (i++ == colIdx) {
                if (t.getColumnType() != ColumnType.String) {
                    throw new IllegalStateException("Cannot convert non-string type");
                }
                for (int j = 0; j < this.newColumnNames.size(); ++j) {
                    CategoricalMetaData meta = new CategoricalMetaData("true", "false");
                    newMeta.add(meta);
                    newNames.add(this.newColumnNames.get(j));
                }
                continue;
            }
            newMeta.add(t);
            newNames.add(name);
        }
        return inputSchema.newSchema(newNames, newMeta);
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.columIdx = inputSchema.getIndexOfColumn(this.columnName);
    }

    @Override
    public String toString() {
        return "StringListToCategoricalSetTransform(columnName=" + this.columnName + ",newColumnNames=" + this.newColumnNames + ",categoryTokens=" + this.categoryTokens + ",delim=\"" + this.delim + "\")";
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not " + "match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int n = writables.size();
        ArrayList<Writable> out = new ArrayList<Writable>(n);
        int i = 0;
        for (Writable w : writables) {
            if (i++ == this.columIdx) {
                String str = w.toString();
                boolean[] present = new boolean[this.categoryTokens.size()];
                if (str != null && !str.isEmpty()) {
                    String[] split;
                    for (String s : split = str.split(this.delim)) {
                        Integer idx = this.map.get(s);
                        if (idx == null) {
                            throw new IllegalStateException("Encountered unknown String: \"" + s + "\"");
                        }
                        present[idx.intValue()] = true;
                    }
                }
                for (int j = 0; j < present.length; ++j) {
                    out.add(new Text(present[j] ? "true" : "false"));
                }
                continue;
            }
            out.add(w);
        }
        return out;
    }
}

