/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.datavec.api.transform.ColumnType;
import org.datavec.api.transform.metadata.CategoricalMetaData;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.DoubleMetaData;
import org.datavec.api.transform.metadata.IntegerMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.metadata.TimeMetaData;
import org.joda.time.DateTimeZone;

public class Schema
implements Serializable {
    private List<String> columnNames;
    private List<ColumnMetaData> columnMetaData;
    private Map<String, Integer> columnNamesIndex;

    protected Schema(Builder builder) {
        this.columnNames = builder.columnNames;
        this.columnMetaData = builder.columnMetaData;
        this.columnNamesIndex = new HashMap<String, Integer>();
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.columnNamesIndex.put(this.columnNames.get(i), i);
        }
    }

    public Schema(List<String> columnNames, List<ColumnMetaData> columnMetaData) {
        if (columnNames == null || columnMetaData == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (columnNames.size() == 0 || columnNames.size() != columnMetaData.size()) {
            throw new IllegalArgumentException("List sizes must match (and be non-zero)");
        }
        this.columnNames = columnNames;
        this.columnMetaData = columnMetaData;
        this.columnNamesIndex = new HashMap<String, Integer>();
        for (int i = 0; i < columnNames.size(); ++i) {
            this.columnNamesIndex.put(columnNames.get(i), i);
        }
    }

    public Schema newSchema(List<String> columnNames, List<ColumnMetaData> columnMetaData) {
        return new Schema(columnNames, columnMetaData);
    }

    public int numColumns() {
        return this.columnNames.size();
    }

    public String getName(int column) {
        return this.columnNames.get(column);
    }

    public ColumnType getType(int column) {
        return this.columnMetaData.get(column).getColumnType();
    }

    public ColumnMetaData getMetaData(int column) {
        return this.columnMetaData.get(column);
    }

    public ColumnMetaData getMetaData(String column) {
        return this.getMetaData(this.getIndexOfColumn(column));
    }

    public List<String> getColumnNames() {
        return new ArrayList<String>(this.columnNames);
    }

    public List<ColumnType> getColumnTypes() {
        ArrayList<ColumnType> list = new ArrayList<ColumnType>(this.columnMetaData.size());
        for (ColumnMetaData md : this.columnMetaData) {
            list.add(md.getColumnType());
        }
        return list;
    }

    public List<ColumnMetaData> getColumnMetaData() {
        return new ArrayList<ColumnMetaData>(this.columnMetaData);
    }

    public int getIndexOfColumn(String columnName) {
        Integer idx = this.columnNamesIndex.get(columnName);
        if (idx == null) {
            throw new NoSuchElementException("Unknown column: \"" + columnName + "\"");
        }
        return idx;
    }

    public boolean hasColumn(String columnName) {
        Integer idx = this.columnNamesIndex.get(columnName);
        return idx != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int nCol = this.numColumns();
        int maxNameLength = 0;
        for (String s : this.getColumnNames()) {
            maxNameLength = Math.max(maxNameLength, s.length());
        }
        sb.append("Schema():\n");
        sb.append(String.format("%-6s", "idx")).append(String.format("%-" + (maxNameLength + 8) + "s", "name")).append(String.format("%-15s", "type")).append("meta data").append("\n");
        for (int i = 0; i < nCol; ++i) {
            String colName = this.getName(i);
            ColumnType type = this.getType(i);
            ColumnMetaData meta = this.getMetaData(i);
            String paddedName = String.format("%-" + (maxNameLength + 8) + "s", "\"" + colName + "\"");
            sb.append(String.format("%-6d", i)).append(paddedName).append(String.format("%-15s", new Object[]{type})).append(meta).append("\n");
        }
        return sb.toString();
    }

    public static class Builder {
        List<String> columnNames = new ArrayList<String>();
        List<ColumnMetaData> columnMetaData = new ArrayList<ColumnMetaData>();

        public Builder addColumnDouble(String name) {
            return this.addColumn(name, new DoubleMetaData());
        }

        public Builder addColumnDouble(String name, Double minAllowedValue, Double maxAllowedValue) {
            return this.addColumnDouble(name, minAllowedValue, maxAllowedValue, false, false);
        }

        public Builder addColumnDouble(String name, Double minAllowedValue, Double maxAllowedValue, boolean allowNaN, boolean allowInfinite) {
            return this.addColumn(name, new DoubleMetaData(minAllowedValue, maxAllowedValue, allowNaN, allowInfinite));
        }

        public Builder addColumnsDouble(String ... columnNames) {
            for (String s : columnNames) {
                this.addColumnDouble(s);
            }
            return this;
        }

        public Builder addColumnInteger(String name) {
            return this.addColumn(name, new IntegerMetaData());
        }

        public Builder addColumnInteger(String name, Integer minAllowedValue, Integer maxAllowedValue) {
            return this.addColumn(name, new IntegerMetaData(minAllowedValue, maxAllowedValue));
        }

        public Builder addColumnsInteger(String ... names) {
            for (String s : names) {
                this.addColumnInteger(s);
            }
            return this;
        }

        public Builder addColumnCategorical(String name, String ... stateNames) {
            return this.addColumn(name, new CategoricalMetaData(stateNames));
        }

        public Builder addColumnCategorical(String name, List<String> stateNames) {
            return this.addColumn(name, new CategoricalMetaData(stateNames));
        }

        public Builder addColumnLong(String name) {
            return this.addColumn(name, new LongMetaData());
        }

        public Builder addColumnLong(String name, Long minAllowedValue, Long maxAllowedValue) {
            return this.addColumn(name, new LongMetaData(minAllowedValue, maxAllowedValue));
        }

        public Builder addColumnsLong(String ... names) {
            for (String s : names) {
                this.addColumnLong(s);
            }
            return this;
        }

        public Builder addColumn(String name, ColumnMetaData metaData) {
            this.columnNames.add(name);
            this.columnMetaData.add(metaData);
            return this;
        }

        public Builder addColumnString(String name) {
            return this.addColumn(name, new StringMetaData());
        }

        public Builder addColumnsString(String ... columnNames) {
            for (String s : columnNames) {
                this.addColumnString(s);
            }
            return this;
        }

        public Builder addColumnString(String name, String regex, Integer minAllowableLength, int maxAllowableLength) {
            return this.addColumn(name, new StringMetaData(regex, minAllowableLength, maxAllowableLength));
        }

        public Builder addColumnTime(String columnName, TimeZone timeZone) {
            return this.addColumnTime(columnName, DateTimeZone.forTimeZone((TimeZone)timeZone));
        }

        public Builder addColumnTime(String columnName, DateTimeZone timeZone) {
            return this.addColumnTime(columnName, timeZone, null, null);
        }

        public Builder addColumnTime(String columnName, DateTimeZone timeZone, Long minValidValue, Long maxValidValue) {
            this.addColumn(columnName, new TimeMetaData(timeZone, minValidValue, maxValidValue));
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

