/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.condition.column;

import java.util.Set;
import org.datavec.api.transform.condition.ConditionOp;
import org.datavec.api.transform.condition.SequenceConditionMode;
import org.datavec.api.transform.condition.column.BaseColumnCondition;
import org.datavec.api.writable.Writable;

public class LongColumnCondition
extends BaseColumnCondition {
    private final ConditionOp op;
    private final long value;
    private final Set<Long> set;

    public LongColumnCondition(String column, ConditionOp op, long value) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, value);
    }

    public LongColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, long value) {
        super(column, sequenceConditionMode);
        if (op == ConditionOp.InSet || op == ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: cannot use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = value;
        this.set = null;
    }

    public LongColumnCondition(String column, ConditionOp op, Set<Long> set) {
        this(column, DEFAULT_SEQUENCE_CONDITION_MODE, op, set);
    }

    public LongColumnCondition(String column, SequenceConditionMode sequenceConditionMode, ConditionOp op, Set<Long> set) {
        super(column, sequenceConditionMode);
        if (op != ConditionOp.InSet && op != ConditionOp.NotInSet) {
            throw new IllegalArgumentException("Invalid condition op: can ONLY use this constructor with InSet or NotInSet ops");
        }
        this.op = op;
        this.value = 0L;
        this.set = set;
    }

    @Override
    public boolean columnCondition(Writable writable) {
        switch (this.op) {
            case LessThan: {
                return writable.toLong() < this.value;
            }
            case LessOrEqual: {
                return writable.toLong() <= this.value;
            }
            case GreaterThan: {
                return writable.toLong() > this.value;
            }
            case GreaterOrEqual: {
                return writable.toLong() >= this.value;
            }
            case Equal: {
                return writable.toLong() == this.value;
            }
            case NotEqual: {
                return writable.toLong() != this.value;
            }
            case InSet: {
                return this.set.contains(writable.toLong());
            }
            case NotInSet: {
                return !this.set.contains(writable.toLong());
            }
        }
        throw new RuntimeException("Unknown or not implemented op: " + (Object)((Object)this.op));
    }

    @Override
    public String toString() {
        return "LongColumnCondition(colName=\"" + this.column + "\"," + (Object)((Object)this.op) + "," + (this.op == ConditionOp.NotInSet || this.op == ConditionOp.InSet ? this.set : Long.valueOf(this.value)) + ")";
    }
}

