/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml.fieldmanager;

import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.xml.XMLStoreManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FetchFieldManager
extends AbstractFieldManager {
    DNStateManager sm;
    Object value;
    Document doc;
    Node node;

    public FetchFieldManager(DNStateManager sm, Document doc) {
        this.sm = sm;
        this.doc = doc;
        ExecutionContext ec = sm.getExecutionContext();
        this.node = XMLUtils.findNode(doc, sm);
        try {
            this.value = ((XMLStoreManager)ec.getStoreManager()).getJAXBHandler().unmarshall(sm.getObject().getClass(), this.node, sm.getExecutionContext().getClassLoaderResolver());
        }
        catch (JAXBException e) {
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception unmarshalling XML", (Throwable)e);
        }
    }

    public String fetchStringField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return (String)this.sm.provideField(fieldNumber);
    }

    public Object fetchObjectField(int fieldNumber) {
        ExecutionContext ec = this.sm.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType == RelationType.NONE) {
            FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
            return this.sm.provideField(fieldNumber);
        }
        if (mmd.getEmbeddedMetaData() == null) {
            if (relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.MANY_TO_ONE_BI) {
                AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                NodeList nList = ((Element)this.node).getElementsByTagName(mmd.getName());
                if (nList.getLength() == 1) {
                    Object id = ec.getNucleusContext().getIdentityManager().getApplicationId(clr.classForName(cmd.getFullClassName(), true), (Object)nList.item(0).getFirstChild().getNodeValue());
                    Persistable related = ec.findObject(id, true, true, null);
                    if (relationType == RelationType.ONE_TO_ONE_BI) {
                        DNStateManager relatedSM = ec.findStateManager((Object)related);
                        AbstractMemberMetaData relatedMmd = mmd.getRelatedMemberMetaDataForObject(clr, this.sm.getObject(), (Object)related);
                        relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.sm.getObject());
                    }
                    return related;
                }
                return null;
            }
            if (relationType == RelationType.ONE_TO_MANY_UNI || relationType == RelationType.ONE_TO_MANY_BI) {
                if (mmd.hasCollection()) {
                    AbstractClassMetaData cmd2 = ec.getMetaDataManager().getMetaDataForClass(mmd.getCollection().getElementType(), clr);
                    if (cmd2 == null) {
                        throw new NucleusUserException("Cannot find metadata for element type " + mmd.getCollection().getElementType() + " for field=" + mmd.getFullFieldName());
                    }
                    FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
                    Collection collection = (Collection)this.sm.provideField(fieldNumber);
                    NodeList nLists = ((Element)this.node).getElementsByTagName(XMLUtils.getElementNameForMember(mmd, FieldRole.ROLE_COLLECTION_ELEMENT));
                    for (int i = 0; i < nLists.getLength(); ++i) {
                        String nodeValue = nLists.item(i).getFirstChild().getNodeValue();
                        if (nodeValue == null || nodeValue.trim().length() <= 0) continue;
                        AbstractClassMetaData elementCmd = XMLUtils.findMetaDataForNode(this.doc, cmd2, ec.getMetaDataManager(), nodeValue, clr);
                        if (elementCmd == null) {
                            throw new NucleusException("Unable to find object of type " + cmd2.getFullClassName() + " with id=" + nodeValue);
                        }
                        Object id = ec.getNucleusContext().getIdentityManager().getApplicationId(clr.classForName(elementCmd.getFullClassName(), true), (Object)nodeValue);
                        Persistable related = ec.findObject(id, true, true, null);
                        if (relationType == RelationType.ONE_TO_MANY_BI) {
                            DNStateManager relatedSM = ec.findStateManager((Object)related);
                            AbstractMemberMetaData relatedMmd = relatedSM.getClassMetaData().getMetaDataForMember(mmd.getMappedBy());
                            relatedSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), this.sm.getObject());
                        }
                        collection.add(related);
                    }
                    return SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)collection, (boolean)true);
                }
                if (mmd.hasArray() || mmd.hasMap()) {
                    // empty if block
                }
            }
        }
        return null;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return (Boolean)this.sm.provideField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return (Byte)this.sm.provideField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return ((Character)this.sm.provideField(fieldNumber)).charValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return (Double)this.sm.provideField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return ((Float)this.sm.provideField(fieldNumber)).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return (Integer)this.sm.provideField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return (Long)this.sm.provideField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        FetchFieldManager.copyFieldsFromObject(this.sm, this.value, new int[]{fieldNumber});
        return (Short)this.sm.provideField(fieldNumber);
    }

    public static void copyFieldsFromObject(DNStateManager sm, Object obj, int[] fieldNumbers) {
        if (obj == null) {
            return;
        }
        Persistable myPC = (Persistable)sm.getObject();
        if (!obj.getClass().getName().equals(myPC.getClass().getName())) {
            return;
        }
        if (!(obj instanceof Persistable)) {
            throw new NucleusUserException("Must be Persistable");
        }
        Persistable pc = (Persistable)obj;
        FetchFieldManager.replaceStateManagerForPersistable(pc, (StateManager)sm);
        myPC.dnCopyFields((Object)pc, fieldNumbers);
        FetchFieldManager.replaceStateManagerForPersistable(pc, null);
        sm.markFieldsAsLoaded(fieldNumbers);
    }

    protected static void replaceStateManagerForPersistable(Persistable pc, StateManager sm) {
        pc.dnReplaceStateManager(sm);
    }
}

