/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLUtils {
    private static XPath xpath = XPathFactory.newInstance().newXPath();

    public static DNStateManager prepareXMLObjectForUse(Object obj, ExecutionContext ec, AbstractClassMetaData acmd) {
        if (!ec.getApiAdapter().isPersistable(obj)) {
            return null;
        }
        DNStateManager sm = ec.findStateManager(obj);
        if (sm == null) {
            Object id = null;
            if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                throw new NucleusException(Localiser.msg((String)"XML.DatastoreID"));
            }
            id = ec.getNucleusContext().getIdentityManager().getApplicationId(obj, acmd);
            sm = ec.getNucleusContext().getStateManagerFactory().newForPersistentClean(ec, id, obj);
            AbstractClassMetaData cmd = sm.getClassMetaData();
            int[] members = cmd.getAllMemberPositions();
            for (int i = 0; i < members.length; ++i) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(i);
                if (mmd.getRelationType(ec.getClassLoaderResolver()) == RelationType.NONE || mmd.getEmbeddedMetaData() != null) continue;
                sm.unloadField(i);
            }
        }
        sm.replaceAllLoadedSCOFieldsWithWrappers();
        return sm;
    }

    public static AbstractClassMetaData findMetaDataForNode(Document doc, AbstractClassMetaData acmd, MetaDataManager mmgr, String value, ClassLoaderResolver clr) {
        block11: {
            if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                throw new NucleusException(Localiser.msg((String)"XML.DatastoreID"));
            }
            if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                try {
                    Object expression = XMLUtils.getXPathForClass(acmd);
                    if (expression == null) {
                        if (doc.getDocumentElement() != null) {
                            expression = "/" + doc.getDocumentElement().getNodeName();
                        } else {
                            return null;
                        }
                    }
                    expression = (String)expression + "/" + XMLUtils.getElementNameForClass(acmd);
                    String[] pk = acmd.getPrimaryKeyMemberNames();
                    for (int i = 0; i < pk.length; ++i) {
                        AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[i]);
                        String pkElement = XMLUtils.getElementNameForMember(pkmmd, FieldRole.ROLE_FIELD);
                        expression = (String)expression + "/" + pkElement + "[text()='" + value + "']";
                    }
                    Node node = (Node)xpath.evaluate((String)(expression = (String)expression + "/.."), doc, XPathConstants.NODE);
                    if (node == null) {
                        String[] classNames = mmgr.getSubclassesForClass(acmd.getFullClassName(), false);
                        if (classNames != null) {
                            for (int i = 0; i < classNames.length; ++i) {
                                AbstractClassMetaData nodeCmd = mmgr.getMetaDataForClass(classNames[i], clr);
                                if ((nodeCmd = XMLUtils.findMetaDataForNode(doc, nodeCmd, mmgr, value, clr)) == null) continue;
                                return nodeCmd;
                            }
                        }
                        break block11;
                    }
                    return acmd;
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static Node findNode(Document doc, DNStateManager sm) {
        AbstractClassMetaData acmd;
        Node node = null;
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"XML.Find.Start", (Object[])new Object[]{sm.getObjectAsPrintable(), sm.getInternalObjectId()}));
        }
        if ((acmd = sm.getClassMetaData()).getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException(Localiser.msg((String)"XML.DatastoreID"));
        }
        if (acmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                if (doc.getDocumentElement() == null) {
                    throw new NucleusObjectNotFoundException();
                }
                Object expression = XMLUtils.getXPathForClass(acmd);
                if (expression == null) {
                    expression = "/" + doc.getDocumentElement().getNodeName();
                }
                expression = (String)expression + "/" + XMLUtils.getElementNameForClass(acmd);
                String[] pk = acmd.getPrimaryKeyMemberNames();
                for (int i = 0; i < pk.length; ++i) {
                    AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[i]);
                    String pkElement = XMLUtils.getElementNameForMember(pkmmd, FieldRole.ROLE_FIELD);
                    Object obj = sm.provideField(acmd.getPKMemberPositions()[i]);
                    expression = (String)expression + "/" + pkElement + "[text()='" + obj.toString() + "']";
                }
                expression = (String)expression + "/..";
                node = (Node)xpath.evaluate((String)expression, doc, XPathConstants.NODE);
            }
            catch (NucleusObjectNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"XML.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
        }
        return node;
    }

    public static Class getElementTypeForMember(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        try {
            if (mmd.hasExtension("type")) {
                return clr.classForName(mmd.getValueForExtension("type"));
            }
            if (mmd.hasCollection()) {
                return clr.classForName(mmd.getCollection().getElementType());
            }
        }
        catch (ClassNotResolvedException e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    public static String getXPathForClass(AbstractClassMetaData cmd) {
        if (cmd == null) {
            return null;
        }
        if (cmd.hasExtension("xpath")) {
            return cmd.getValueForExtension("xpath");
        }
        if (cmd.getSchema() != null) {
            return cmd.getSchema();
        }
        if (cmd.getPackageMetaData().getSchema() != null) {
            return cmd.getPackageMetaData().getSchema();
        }
        if (cmd.getPackageMetaData().getFileMetaData().getSchema() != null) {
            return cmd.getPackageMetaData().getFileMetaData().getSchema();
        }
        return null;
    }

    public static String getDefaultRootXPath() {
        return "root";
    }

    public static String getElementNameForClass(AbstractClassMetaData cmd) {
        if (cmd == null) {
            return null;
        }
        if (cmd.hasExtension("name")) {
            return cmd.getValueForExtension("name");
        }
        if (cmd.getTable() != null) {
            return cmd.getTable();
        }
        return XMLUtils.getJAXBDefaultNameForName(cmd.getName());
    }

    public static String getElementNameForMember(AbstractMemberMetaData mmd, FieldRole role) {
        if (role == FieldRole.ROLE_COLLECTION_ELEMENT && mmd.hasCollection()) {
            ColumnMetaData[] colmds;
            ElementMetaData elemmd = mmd.getElementMetaData();
            if (elemmd != null && elemmd.hasExtension("name")) {
                return mmd.getElementMetaData().getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = elemmd != null ? elemmd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_element";
        }
        if (role == FieldRole.ROLE_ARRAY_ELEMENT && mmd.hasArray()) {
            ColumnMetaData[] colmds;
            ElementMetaData elemmd = mmd.getElementMetaData();
            if (elemmd != null && elemmd.hasExtension("name")) {
                return elemmd.getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = elemmd != null ? elemmd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_element";
        }
        if (role == FieldRole.ROLE_MAP_KEY && mmd.hasMap()) {
            ColumnMetaData[] colmds;
            KeyMetaData keymd = mmd.getKeyMetaData();
            if (keymd != null && keymd.hasExtension("name")) {
                return keymd.getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = keymd != null ? keymd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_key";
        }
        if (role == FieldRole.ROLE_MAP_VALUE && mmd.hasMap()) {
            ColumnMetaData[] colmds;
            ValueMetaData valuemd = mmd.getValueMetaData();
            if (valuemd != null && valuemd.hasExtension("name")) {
                return valuemd.getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = valuemd != null ? valuemd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_value";
        }
        if (mmd.hasExtension("name")) {
            return mmd.getValueForExtension("name");
        }
        if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0 && mmd.getColumnMetaData()[0].getName() != null) {
            return mmd.getColumnMetaData()[0].getName();
        }
        return XMLUtils.getJAXBDefaultNameForName(mmd.getName());
    }

    public static String getJAXBDefaultNameForName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }
}

