/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.StringTokenizer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.PersistFieldManager;
import org.datanucleus.store.xml.XMLStoreManager;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.store.xml.fieldmanager.FetchFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLPersistenceHandler
extends AbstractPersistenceHandler {
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public XMLPersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void close() {
    }

    public void insertObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        if (op.getClassMetaData().getIdentityType() == IdentityType.APPLICATION) {
            try {
                this.locateObject(op);
                throw new NucleusUserException(Localiser.msg((String)"XML.Insert.ObjectWithIdAlreadyExists", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {
                // empty catch block
            }
        }
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            Document doc = (Document)mconn.getConnection();
            AbstractClassMetaData acmd = op.getClassMetaData();
            long startTime = 0L;
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"XML.Insert.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if (acmd.isVersioned()) {
                // empty if block
            }
            int[] fieldNumbers = op.getClassMetaData().getRelationMemberPositions(ec.getClassLoaderResolver());
            op.provideFields(fieldNumbers, (FieldManager)new PersistFieldManager(op, true));
            Node classnode = this.getNodeForClass(doc, acmd);
            ((XMLStoreManager)this.storeMgr).getJAXBHandler().marshall(op.getObject(), classnode, op.getExecutionContext().getClassLoaderResolver());
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"XML.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.info((Object)Localiser.msg((String)"XML.Insert.ObjectPersisted", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData acmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            Document doc = (Document)mconn.getConnection();
            long startTime = 0L;
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"XML.Update.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), str}));
            }
            if (acmd.isVersioned()) {
                // empty if block
            }
            op.loadUnloadedFields();
            op.provideFields(fieldNumbers, (FieldManager)new PersistFieldManager(op, false));
            Node node = XMLUtils.findNode(doc, op);
            node.getParentNode().removeChild(node);
            Node classnode = this.getNodeForClass(doc, acmd);
            ((XMLStoreManager)this.storeMgr).getJAXBHandler().marshall(op.getObject(), classnode, op.getExecutionContext().getClassLoaderResolver());
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementUpdateCount();
                ec.getStatistics().incrementNumWrites();
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"XML.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(ObjectProvider op) {
        this.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            AbstractClassMetaData acmd;
            Document doc = (Document)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"XML.Delete.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
            }
            if ((acmd = op.getClassMetaData()).isVersioned()) {
                // empty if block
            }
            Node node = XMLUtils.findNode(doc, op);
            node.getParentNode().removeChild(node);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"XML.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumWrites();
                ec.getStatistics().incrementDeleteCount();
            }
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuilder fieldsString = new StringBuilder();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldsString.append(",");
                    }
                    fieldsString.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"XML.Fetch.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), fieldsString}));
            }
            Document doc = (Document)mconn.getConnection();
            op.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(op, doc));
            if (cmd.isVersioned()) {
                // empty if block
            }
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"XML.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
                ec.getStatistics().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData acmd = op.getClassMetaData();
        if (acmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException(Localiser.msg((String)"XML.DatastoreID"));
        }
        if (acmd.getIdentityType() == IdentityType.NONDURABLE) {
            throw new NucleusException("Nondurable not supported");
        }
        ExecutionContext ec = op.getExecutionContext();
        boolean isStored = false;
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"XML.Locate.Start", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId()}));
        }
        ManagedConnection mconn = this.storeMgr.getConnectionManager().getConnection(ec);
        StringBuilder expression = null;
        try {
            Document doc = (Document)mconn.getConnection();
            expression = new StringBuilder(XMLUtils.getXPathForClass(acmd));
            if (expression.length() == 0) {
                if (doc.getDocumentElement() != null) {
                    expression.append("/").append(doc.getDocumentElement().getNodeName());
                } else {
                    throw new NucleusObjectNotFoundException(Localiser.msg((String)"XML.Object.NotFound", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), expression.toString()}));
                }
            }
            expression.append("/").append(XMLUtils.getElementNameForClass(acmd));
            String[] pk = acmd.getPrimaryKeyMemberNames();
            for (int i = 0; i < pk.length; ++i) {
                AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[i]);
                String pkElement = XMLUtils.getElementNameForMember(pkmmd, FieldRole.ROLE_FIELD);
                Object obj = op.provideField(acmd.getPKMemberPositions()[i]);
                expression.append("/").append(pkElement).append("/text()='").append(obj.toString()).append("'");
            }
            if (ec.getStatistics() != null) {
                ec.getStatistics().incrementNumReads();
            }
            isStored = (Boolean)this.xpath.evaluate(expression.toString(), doc, XPathConstants.BOOLEAN);
        }
        catch (Exception e) {
            throw new NucleusObjectNotFoundException(Localiser.msg((String)"XML.Object.NotFound", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), expression}));
        }
        finally {
            mconn.release();
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"XML.ExecutionTime", (long)(System.currentTimeMillis() - startTime)));
        }
        if (!isStored) {
            throw new NucleusObjectNotFoundException(Localiser.msg((String)"XML.Object.NotFound", (Object[])new Object[]{op.getObjectAsPrintable(), op.getInternalObjectId(), expression}));
        }
    }

    private Node getNodeForClass(Document doc, AbstractClassMetaData acmd) throws XPathExpressionException, DOMException {
        Node classnode;
        String expression = XMLUtils.getXPathForClass(acmd);
        if (expression == null) {
            if (doc.getDocumentElement() == null) {
                doc.appendChild(doc.createElement(XMLUtils.getDefaultRootXPath()));
            }
            classnode = doc.getDocumentElement();
        } else {
            if (this.xpath.evaluate(expression, doc, XPathConstants.NODE) == null) {
                StringTokenizer xpathElement = new StringTokenizer(expression, "/");
                StringBuilder path = new StringBuilder();
                String currentelement = null;
                Node node = doc;
                while (xpathElement.hasMoreElements()) {
                    currentelement = xpathElement.nextToken();
                    path.append("/").append(currentelement);
                    Node n = (Node)this.xpath.evaluate(path.toString(), doc, XPathConstants.NODE);
                    if (n == null) {
                        node = node.appendChild(doc.createElement(currentelement));
                        continue;
                    }
                    node = n;
                }
            }
            classnode = (Node)this.xpath.evaluate(expression, doc, XPathConstants.NODE);
        }
        return classnode;
    }
}

