/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.store.xml.JAXBHandler;
import org.datanucleus.store.xml.XMLMetaDataListener;
import org.datanucleus.store.xml.XMLPersistenceHandler;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.Document;

public class XMLStoreManager
extends AbstractStoreManager {
    public static final String JAXB_HANDLER_CLASS_PROPERTY = "datanucleus.xml.jaxbHandlerClass";
    public static final String XML_INDENT_SIZE_PROPERTY = "datanucleus.xml.indentSize";
    JAXBHandler jaxbHandler;
    MetaDataListener metadataListener;

    public XMLStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("xml", clr, ctx, props);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"javax.xml.bind.JAXBContext", (String)"jaxb-api.jar");
        String jaxbHandlerClassName = this.getStringProperty(JAXB_HANDLER_CLASS_PROPERTY);
        try {
            Class cls = clr.classForName(jaxbHandlerClassName);
            this.jaxbHandler = (JAXBHandler)ClassUtils.newInstance((Class)cls, (Class[])new Class[]{MetaDataManager.class}, (Object[])new Object[]{ctx.getMetaDataManager()});
        }
        catch (ClassNotResolvedException cnre) {
            NucleusLogger.DATASTORE.error((Object)("Could not find jaxb handler class " + jaxbHandlerClassName), (Throwable)cnre);
            throw new NucleusUserException("The specified JAXB Handler class \"" + jaxbHandlerClassName + "\" was not found!").setFatal();
        }
        this.metadataListener = new XMLMetaDataListener();
        ctx.getMetaDataManager().registerListener(this.metadataListener);
        this.persistenceHandler = new XMLPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public synchronized void close() {
        this.nucleusContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public JAXBHandler getJAXBHandler() {
        return this.jaxbHandler;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        String targetClassName = null;
        if (IdentityUtils.isSingleFieldIdentity((Object)id)) {
            targetClassName = IdentityUtils.getTargetClassNameForIdentity((Object)id);
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(targetClassName, true);
            if (subclasses == null) {
                return targetClassName;
            }
            String[] possibleNames = new String[subclasses.length + 1];
            possibleNames[0] = targetClassName;
            for (int i = 0; i < subclasses.length; ++i) {
                possibleNames[i + 1] = subclasses[i];
            }
            return this.getClassNameForIdentity(ec, possibleNames, id);
        }
        return super.getClassNameForObjectID(id, clr, ec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassNameForIdentity(ExecutionContext ec, String[] possibleNames, Object id) {
        ManagedConnection mconn = this.getConnection(ec);
        try {
            Document doc = (Document)mconn.getConnection();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            XPath xpath = XPathFactory.newInstance().newXPath();
            StringBuilder expression = null;
            for (int i = 0; i < possibleNames.length; ++i) {
                AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(possibleNames[i], clr);
                expression = new StringBuilder();
                expression.append(XMLUtils.getXPathForClass(acmd));
                if (expression.length() == 0) {
                    if (doc.getDocumentElement() == null) continue;
                    expression.append("/" + doc.getDocumentElement().getNodeName());
                }
                expression.append('/').append(XMLUtils.getElementNameForClass(acmd));
                String[] pk = acmd.getPrimaryKeyMemberNames();
                for (int j = 0; j < pk.length; ++j) {
                    AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[j]);
                    String pkElement = XMLUtils.getElementNameForMember(pkmmd, FieldRole.ROLE_FIELD);
                    Object obj = IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)id);
                    expression.append('/').append(pkElement).append("/text()='").append(obj.toString()).append("'");
                }
                if (!((Boolean)xpath.evaluate(expression.toString(), doc, XPathConstants.BOOLEAN)).booleanValue()) continue;
                String string = possibleNames[i];
                return string;
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            mconn.release();
        }
        return null;
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        return set;
    }

    public String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        return "generate-id";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStrategyValueForGenerator(ValueGenerator generator, final ExecutionContext ec) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractDatastoreGenerator) {
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    public ManagedConnection retrieveConnection() {
                        this.mconn = XMLStoreManager.this.getConnection(ec);
                        return this.mconn;
                    }

                    public void releaseConnection() {
                        this.mconn.release();
                        this.mconn = null;
                    }
                };
                ((AbstractDatastoreGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.xml.Localisation", (ClassLoader)XMLStoreManager.class.getClassLoader());
    }
}

