/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.valuegenerator.AbstractDatastoreGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.store.xml.XMLMetaDataListener;
import org.datanucleus.store.xml.XMLPersistenceHandler;
import org.datanucleus.store.xml.XMLUtils;
import org.datanucleus.util.ClassUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStoreManager
extends AbstractStoreManager {
    MetaDataListener metadataListener;

    public XMLStoreManager(ClassLoaderResolver clr, NucleusContext ctx, Map<String, Object> props) {
        super("xml", clr, ctx, props);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"javax.xml.bind.JAXBContext", (String)"jaxb-api.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.sun.xml.bind.api.JAXBRIContext", (String)"jaxb-impl.jar");
        this.metadataListener = new XMLMetaDataListener();
        ctx.getMetaDataManager().registerListener(this.metadataListener);
        this.persistenceHandler = new XMLPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public void close() {
        this.nucleusContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        String targetClassName = null;
        if (this.getApiAdapter().isSingleFieldIdentity(id)) {
            targetClassName = this.getApiAdapter().getTargetClassNameForSingleFieldIdentity(id);
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(targetClassName, true);
            if (subclasses == null) {
                return targetClassName;
            }
            String[] possibleNames = new String[subclasses != null ? subclasses.length + 1 : 1];
            possibleNames[0] = targetClassName;
            if (subclasses != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    possibleNames[i + 1] = subclasses[i];
                }
            }
            return this.getClassNameForIdentity(ec, possibleNames, id);
        }
        return super.getClassNameForObjectID(id, clr, ec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassNameForIdentity(ExecutionContext ec, String[] possibleNames, Object id) {
        ManagedConnection mconn = this.getConnection(ec);
        String expression = null;
        try {
            Document doc = (Document)mconn.getConnection();
            ClassLoaderResolver clr = ec.getClassLoaderResolver();
            XPath xpath = XPathFactory.newInstance().newXPath();
            for (int i = 0; i < possibleNames.length; ++i) {
                AbstractClassMetaData acmd = this.getMetaDataManager().getMetaDataForClass(possibleNames[i], clr);
                expression = XMLUtils.getXPathForClass(acmd);
                if (expression == null) {
                    if (doc.getDocumentElement() == null) continue;
                    expression = "/" + doc.getDocumentElement().getNodeName();
                }
                expression = expression + "/" + XMLUtils.getElementNameForClass(acmd);
                String[] pk = acmd.getPrimaryKeyMemberNames();
                for (int j = 0; j < pk.length; ++j) {
                    AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[j]);
                    String pkElement = XMLUtils.getElementNameForMember(pkmmd, 2);
                    Object obj = ec.getApiAdapter().getTargetKeyForSingleFieldIdentity(id);
                    expression = expression + "/" + pkElement + "/text()='" + obj.toString() + "'";
                }
                if (!((Boolean)xpath.evaluate(expression, doc, XPathConstants.BOOLEAN)).booleanValue()) continue;
                String string = possibleNames[i];
                return string;
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            mconn.release();
        }
        return null;
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("DatastoreIdentity");
        set.add("ApplicationIdentity");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        return set;
    }

    protected String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        return "generate-id";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getStrategyValueForGenerator(ValueGenerator generator, final ExecutionContext ec) {
        Object oid = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractDatastoreGenerator) {
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    public ManagedConnection retrieveConnection() {
                        this.mconn = XMLStoreManager.this.getConnection(ec);
                        return this.mconn;
                    }

                    public void releaseConnection() {
                        this.mconn.release();
                        this.mconn = null;
                    }
                };
                ((AbstractDatastoreGenerator)generator).setConnectionProvider(connProvider);
            }
            oid = generator.next();
        }
        return oid;
    }
}

