/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.xml.XMLManager;
import org.datanucleus.store.xml.binder.JAXBRuntimeBinder;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.xml.Localisation", (ClassLoader)XMLManager.class.getClassLoader());
    private static XPath xpath = XPathFactory.newInstance().newXPath();

    public static StateManager prepareXMLObjectForUse(Object obj, ObjectManager om, AbstractClassMetaData acmd) {
        if (!om.getApiAdapter().isPersistable(obj)) {
            return null;
        }
        StateManager sm = om.findStateManager(obj);
        if (sm == null) {
            Object id = null;
            if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                throw new NucleusException(LOCALISER.msg("XML.DatastoreID"));
            }
            id = om.getApiAdapter().getNewApplicationIdentityObjectId(obj, acmd);
            sm = StateManagerFactory.newStateManagerForPersistentClean((ObjectManager)om, (Object)id, (Object)obj);
        }
        sm.replaceAllLoadedSCOFieldsWithWrappers();
        return sm;
    }

    public static List getObjectsOfCandidateType(ObjectManager om, ManagedConnection mconn, Class candidateClass, boolean subclasses, boolean ignoreCache) {
        String[] subclassNames;
        Document doc = (Document)mconn.getConnection();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
        List results = XMLUtils.getObjectsOfCandidateType(om, doc, cmd, ignoreCache);
        if (subclasses && (subclassNames = om.getMetaDataManager().getSubclassesForClass(candidateClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(subclassNames[i], clr);
                results.addAll(XMLUtils.getObjectsOfCandidateType(om, doc, acmd, ignoreCache));
            }
        }
        return results;
    }

    private static List getObjectsOfCandidateType(ObjectManager om, Document doc, AbstractClassMetaData acmd, boolean ignoreCache) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class candidateClass = clr.classForName(acmd.getFullClassName());
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            MetaDataManager mmgr = om.getMetaDataManager();
            Element el = null;
            String expression = XMLUtils.getXPathForClass(acmd);
            if (expression == null) {
                el = doc.getDocumentElement();
            } else {
                try {
                    el = (Element)xpath.evaluate(expression, doc, XPathConstants.NODE);
                }
                catch (XPathExpressionException e) {
                    e.printStackTrace();
                }
            }
            if (el != null) {
                for (int i = 0; i < el.getChildNodes().getLength(); ++i) {
                    if (!(el.getChildNodes().item(i) instanceof Element)) continue;
                    Object obj = JAXBRuntimeBinder.unmarshall(candidateClass, el.getChildNodes().item(i), mmgr, clr);
                    XMLUtils.prepareXMLObjectForUse(obj, om, acmd);
                    results.add(obj);
                }
            }
        }
        catch (JAXBException jbe) {
            jbe.printStackTrace();
        }
        return results;
    }

    public static AbstractClassMetaData findMetaDataForNode(Document doc, AbstractClassMetaData acmd, String value) {
        block11: {
            if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                throw new NucleusException(LOCALISER.msg("XML.DatastoreID"));
            }
            if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                try {
                    String expression = XMLUtils.getXPathForClass(acmd);
                    if (expression == null) {
                        if (doc.getDocumentElement() != null) {
                            expression = "/" + doc.getDocumentElement().getNodeName();
                        } else {
                            return null;
                        }
                    }
                    expression = expression + "/" + XMLUtils.getElementNameForClass(acmd);
                    String[] pk = acmd.getPrimaryKeyMemberNames();
                    for (int i = 0; i < pk.length; ++i) {
                        AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[i]);
                        String pkElement = XMLUtils.getElementNameForMember(pkmmd, 2);
                        expression = expression + "/" + pkElement + "[text()='" + value + "']";
                    }
                    Node node = (Node)xpath.evaluate(expression = expression + "/..", doc, XPathConstants.NODE);
                    if (node == null) {
                        Object[] classNames = acmd.getMetaDataManager().getSubclassesForClass(acmd.getFullClassName(), false);
                        NucleusLogger.JDO.info((Object)(">> Not found node for expression=" + expression + " cmd=" + acmd.getFullClassName() + " subclasses=" + StringUtils.objectArrayToString((Object[])classNames)));
                        if (classNames != null) {
                            for (int i = 0; i < classNames.length; ++i) {
                                AbstractClassMetaData nodeCmd = acmd.getMetaDataManager().getMetaDataForClass((String)classNames[i], acmd.getMetaDataManager().getOMFContext().getClassLoaderResolver(null));
                                if ((nodeCmd = XMLUtils.findMetaDataForNode(doc, nodeCmd, value)) == null) continue;
                                return nodeCmd;
                            }
                        }
                        break block11;
                    }
                    NucleusLogger.JDO.info((Object)(">> Found node for expression=" + expression + " cmd=" + acmd.getFullClassName()));
                    return acmd;
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public static Node findNode(Document doc, StateManager sm) {
        AbstractClassMetaData acmd;
        Node node = null;
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
        }
        if ((acmd = sm.getClassMetaData()).getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusException(LOCALISER.msg("XML.DatastoreID"));
        }
        if (acmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                String expression = XMLUtils.getXPathForClass(acmd);
                if (expression == null) {
                    if (doc.getDocumentElement() != null) {
                        expression = "/" + doc.getDocumentElement().getNodeName();
                    } else {
                        return null;
                    }
                }
                expression = expression + "/" + XMLUtils.getElementNameForClass(acmd);
                String[] pk = acmd.getPrimaryKeyMemberNames();
                for (int i = 0; i < pk.length; ++i) {
                    AbstractMemberMetaData pkmmd = acmd.getMetaDataForMember(pk[i]);
                    String pkElement = XMLUtils.getElementNameForMember(pkmmd, 2);
                    Object obj = sm.provideField(acmd.getPKMemberPositions()[i]);
                    expression = expression + "/" + pkElement + "[text()='" + obj.toString() + "']";
                }
                expression = expression + "/..";
                node = (Node)xpath.evaluate(expression, doc, XPathConstants.NODE);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("XML.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return node;
    }

    public static Class getElementTypeForMember(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        try {
            if (mmd.hasExtension("type")) {
                return clr.classForName(mmd.getValueForExtension("type"));
            }
            if (mmd.hasCollection()) {
                return clr.classForName(mmd.getCollection().getElementType());
            }
        }
        catch (ClassNotResolvedException e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    public static String getXPathForClass(AbstractClassMetaData cmd) {
        if (cmd == null) {
            return null;
        }
        if (cmd.hasExtension("xpath")) {
            return cmd.getValueForExtension("xpath");
        }
        if (cmd.getSchema() != null) {
            return cmd.getSchema();
        }
        if (cmd.getPackageMetaData().getSchema() != null) {
            return cmd.getPackageMetaData().getSchema();
        }
        if (cmd.getPackageMetaData().getFileMetaData().getSchema() != null) {
            return cmd.getPackageMetaData().getFileMetaData().getSchema();
        }
        return null;
    }

    public static String getDefaultRootXPath() {
        return "root";
    }

    public static String getElementNameForClass(AbstractClassMetaData cmd) {
        if (cmd == null) {
            return null;
        }
        if (cmd.hasExtension("name")) {
            return cmd.getValueForExtension("name");
        }
        if (cmd.getTable() != null) {
            return cmd.getTable();
        }
        return XMLUtils.getJAXBDefaultNameForName(cmd.getName());
    }

    public static String getElementNameForMember(AbstractMemberMetaData mmd, int role) {
        Object name = null;
        if (role == 3 && mmd.hasCollection()) {
            ColumnMetaData[] colmds;
            ElementMetaData elemmd = mmd.getElementMetaData();
            if (elemmd != null && elemmd.hasExtension("name")) {
                return mmd.getElementMetaData().getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = elemmd != null ? elemmd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_element";
        }
        if (role == 4 && mmd.hasArray()) {
            ColumnMetaData[] colmds;
            ElementMetaData elemmd = mmd.getElementMetaData();
            if (elemmd != null && elemmd.hasExtension("name")) {
                return elemmd.getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = elemmd != null ? elemmd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_element";
        }
        if (role == 5 && mmd.hasMap()) {
            ColumnMetaData[] colmds;
            KeyMetaData keymd = mmd.getKeyMetaData();
            if (keymd != null && keymd.hasExtension("name")) {
                return keymd.getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = keymd != null ? keymd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_key";
        }
        if (role == 6 && mmd.hasMap()) {
            ColumnMetaData[] colmds;
            ValueMetaData valuemd = mmd.getValueMetaData();
            if (valuemd != null && valuemd.hasExtension("name")) {
                return valuemd.getValueForExtension("name");
            }
            ColumnMetaData[] columnMetaDataArray = colmds = valuemd != null ? valuemd.getColumnMetaData() : null;
            if (colmds != null && colmds.length > 0 && colmds[0].getName() != null) {
                return colmds[0].getName();
            }
            return mmd.getName().toLowerCase() + "_value";
        }
        if (name == null && mmd.hasExtension("name")) {
            return mmd.getValueForExtension("name");
        }
        if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0 && mmd.getColumnMetaData()[0].getName() != null) {
            return mmd.getColumnMetaData()[0].getName();
        }
        return XMLUtils.getJAXBDefaultNameForName(mmd.getName());
    }

    public static String getJAXBDefaultNameForName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }
}

