/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAResource;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    OMFContext omfContext;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        this.omfContext = omfContext;
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        return this.omfContext.getConnectionManager().allocateConnection((ConnectionFactory)this, om, addedOptions);
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new ManagedConnectionImpl(om.getOMFContext(), transactionOptions);
    }

    public class ManagedConnectionImpl
    implements ManagedConnection {
        OMFContext omf;
        Map options;
        Object conn;
        boolean managed = false;
        boolean locked = false;
        List listeners = new ArrayList();
        File file;

        public ManagedConnectionImpl(OMFContext omf, Map options) {
            this.omf = omf;
            this.options = options;
        }

        public void addListener(ManagedConnectionResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
            this.listeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.conn == null) {
                return;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            try {
                try {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer m = tf.newTransformer();
                    DOMSource source = new DOMSource((Document)this.conn);
                    FileOutputStream os = new FileOutputStream(this.file);
                    StreamResult result = new StreamResult(os);
                    m.setOutputProperty("indent", "yes");
                    m.setOutputProperty("doctype-public", "-//DataNucleus//DTD DataNucleus AutoStarter Metadata 1.0//EN");
                    m.transform(source, result);
                    os.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.conn = null;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
        }

        public void flush() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionFlushed();
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                String url = this.omf.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionURL");
                if (!url.startsWith("xml")) {
                    throw new NucleusException("invalid URL: " + url);
                }
                String str = url.substring(4);
                if (str.indexOf("file:") != 0) {
                    throw new NucleusException("invalid URL: " + url);
                }
                try {
                    String filename = str.substring(5);
                    this.file = new File(filename);
                    if (!this.file.exists()) {
                        this.file.createNewFile();
                        this.conn = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    } else {
                        try {
                            this.conn = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.file);
                        }
                        catch (SAXException ex) {
                            this.conn = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                        }
                    }
                }
                catch (IOException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            return this.conn;
        }

        public XAResource getXAResource() {
            return null;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void release() {
            if (!this.managed) {
                this.close();
            }
        }

        public void setManagedResource() {
            this.managed = true;
        }

        public void unlock() {
            this.locked = false;
        }
    }
}

