/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.Table;

public class InsertStatement
extends SQLStatement {
    List<SQLExpression> columnList = new ArrayList<SQLExpression>();
    SelectStatement selectStmt;

    public InsertStatement(RDBMSStoreManager rdbmsMgr, Table table, DatastoreIdentifier alias, String tableGroupName, Map<String, Object> extensions) {
        super(null, rdbmsMgr, table, alias, tableGroupName, extensions);
    }

    public void addColumn(SQLExpression expr) {
        this.columnList.add(expr);
    }

    public void setSelectStatement(SelectStatement selectStmt) {
        this.selectStmt = selectStmt;
    }

    public SelectStatement getSelectStatement() {
        return this.selectStmt;
    }

    @Override
    public SQLText getSQLText() {
        this.sqlLock.lock();
        try {
            if (this.sql != null) {
                SQLText sQLText = this.sql;
                return sQLText;
            }
            this.sql = new SQLText("INSERT INTO ");
            this.sql.append(this.primaryTable.getTable().toString());
            this.sql.append('(');
            Iterator<SQLExpression> columnListIter = this.columnList.iterator();
            while (columnListIter.hasNext()) {
                SQLExpression colExpr = columnListIter.next();
                this.sql.append(colExpr.toSQLText());
                if (!columnListIter.hasNext()) continue;
                this.sql.append(',');
            }
            this.sql.append(") ");
            if (this.selectStmt != null) {
                this.sql.append(this.selectStmt.getSQLText());
            }
            SQLText sQLText = this.sql;
            return sQLText;
        }
        finally {
            this.sqlLock.unlock();
        }
    }
}

