/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntConsumer;
import org.datanucleus.ExecutionContext;
import org.datanucleus.management.ManagerStatistics;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.rdbms.ManagedConnectionWithExecutionContext;
import org.datanucleus.store.rdbms.ParamLoggingPreparedStatement;
import org.datanucleus.store.rdbms.request.RequestUtil;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SQLController {
    protected boolean supportsBatching = false;
    protected int maxBatchSize = -1;
    protected int queryTimeout = 0;
    protected StatementLoggingType stmtLogType = StatementLoggingType.JDBC;
    Map<ManagedConnection, ConnectionStatementState> connectionStatements = new ConcurrentHashMap<ManagedConnection, ConnectionStatementState>();

    public SQLController(boolean supportsBatching, int maxBatchSize, int queryTimeout, StatementLoggingType stmtLoggingType) {
        this.supportsBatching = supportsBatching;
        this.maxBatchSize = maxBatchSize;
        this.queryTimeout = queryTimeout;
        if (maxBatchSize == 0) {
            this.supportsBatching = false;
        }
        this.stmtLogType = stmtLoggingType;
    }

    public PreparedStatement getStatementForUpdate(ManagedConnection conn, String stmtText, boolean batchable) throws SQLException {
        return this.getStatementForUpdate(conn, stmtText, batchable, false, Collections.emptyList());
    }

    public PreparedStatement getStatementForUpdate(ManagedConnection conn, String stmtText, boolean batchable, boolean getGeneratedKeysFlag, List<String> pkColumnNames) throws SQLException {
        ConnectionStatementState state;
        Connection c = (Connection)conn.getConnection();
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null) {
            if (state.processable) {
                if (!batchable) {
                    this.processConnectionStatement(conn);
                } else if (state.stmtText.equals(stmtText)) {
                    if (this.maxBatchSize == -1 || state.batchSize < this.maxBatchSize) {
                        ++state.batchSize;
                        state.processable = false;
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"052100", (Object[])new Object[]{stmtText, "" + state.batchSize}));
                        }
                        return state.stmt;
                    }
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"052101", (Object[])new Object[]{state.stmtText}));
                    }
                    this.processConnectionStatement(conn);
                } else {
                    this.processConnectionStatement(conn);
                }
            } else if (batchable) {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"052102", (Object[])new Object[]{state.stmtText, stmtText}));
                }
                batchable = false;
            }
        }
        PreparedStatement ps = getGeneratedKeysFlag ? (pkColumnNames.isEmpty() ? c.prepareStatement(stmtText, 1) : c.prepareStatement(stmtText, pkColumnNames.toArray(new String[0]))) : c.prepareStatement(stmtText);
        ps.clearBatch();
        if (this.stmtLogType != StatementLoggingType.JDBC) {
            ps = new ParamLoggingPreparedStatement(ps, stmtText);
            ((ParamLoggingPreparedStatement)ps).setParamsInAngleBrackets(this.stmtLogType == StatementLoggingType.PARAMS_IN_BRACKETS);
        }
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"052109", (Object[])new Object[]{ps, StringUtils.toJVMIDString((Object)c)}));
        }
        if (batchable && this.supportsBatching) {
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"052103", (Object[])new Object[]{stmtText}));
            }
            ConnectionStatementState state2 = new ConnectionStatementState();
            state2.stmt = ps;
            state2.stmtText = stmtText;
            state2.batchSize = 1;
            this.setConnectionStatementState(conn, state2);
        }
        return ps;
    }

    public PreparedStatement getStatementForQuery(ManagedConnection conn, String stmtText) throws SQLException {
        return this.getStatementForQuery(conn, stmtText, null, null);
    }

    public PreparedStatement getStatementForQuery(ManagedConnection conn, String stmtText, String resultSetType, String resultSetConcurrency) throws SQLException {
        ConnectionStatementState state;
        Connection c = (Connection)conn.getConnection();
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null && state.processable) {
            this.processConnectionStatement(conn);
        }
        PreparedStatement ps = null;
        if (resultSetType != null || resultSetConcurrency != null) {
            int rsTypeValue = 1003;
            if (resultSetType != null) {
                if (resultSetType.equals("scroll-sensitive")) {
                    rsTypeValue = 1005;
                } else if (resultSetType.equals("scroll-insensitive")) {
                    rsTypeValue = 1004;
                }
            }
            int rsConcurrencyValue = 1007;
            if (resultSetConcurrency != null && resultSetConcurrency.equals("updateable")) {
                rsConcurrencyValue = 1008;
            }
            ps = c.prepareStatement(stmtText, rsTypeValue, rsConcurrencyValue);
            ps.clearBatch();
        } else {
            ps = c.prepareStatement(stmtText);
            ps.clearBatch();
        }
        if (this.queryTimeout > 0) {
            ps.setQueryTimeout(this.queryTimeout / 1000);
        }
        if (this.stmtLogType != StatementLoggingType.JDBC) {
            ps = new ParamLoggingPreparedStatement(ps, stmtText);
            ((ParamLoggingPreparedStatement)ps).setParamsInAngleBrackets(this.stmtLogType == StatementLoggingType.PARAMS_IN_BRACKETS);
        }
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"052109", (Object[])new Object[]{ps, StringUtils.toJVMIDString((Object)c)}));
        }
        return ps;
    }

    public int[] executeStatementUpdate(ExecutionContext ec, ManagedConnection conn, String stmt, PreparedStatement ps, boolean processNow) throws SQLException {
        return this.doExecuteStatementUpdate(ec, conn, stmt, ps, processNow, null);
    }

    public void executeStatementUpdateDeferRowCountCheckForBatching(ExecutionContext ec, ManagedConnection conn, String stmt, PreparedStatement ps, boolean processNow, IntConsumer handler) throws SQLException {
        this.doExecuteStatementUpdate(ec, conn, stmt, ps, processNow, handler);
    }

    private int[] doExecuteStatementUpdate(ExecutionContext ec, ManagedConnection conn, String stmt, PreparedStatement ps, boolean processNow, IntConsumer handler) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state != null) {
            if (state.stmt == ps) {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"052104", (Object[])new Object[]{state.stmtText, "" + state.batchSize}));
                }
                state.processable = true;
                state.stmt.addBatch();
                state.handlers.add(handler);
                if (processNow) {
                    state.closeStatementOnProcess = false;
                    return this.processConnectionStatement(conn);
                }
                return null;
            }
            this.processConnectionStatement(conn);
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)stmt);
            }
        }
        int ind = ps.executeUpdate();
        if (ec != null && ec.getStatistics() != null) {
            ec.getStatistics().incrementNumWrites();
        }
        ps.clearBatch();
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"045001", (Object[])new Object[]{"" + (System.currentTimeMillis() - startTime), "" + ind, StringUtils.toJVMIDString((Object)ps)}));
        }
        if (handler != null) {
            handler.accept(ind);
        }
        return new int[]{ind};
    }

    public boolean executeStatement(ExecutionContext ec, ManagedConnection conn, String stmt, PreparedStatement ps) throws SQLException {
        ConnectionStatementState state;
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null && state.processable) {
            this.processConnectionStatement(conn);
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)stmt);
            }
        }
        boolean flag = ps.execute();
        if (ec != null && ec.getStatistics() != null) {
            ec.getStatistics().incrementNumWrites();
        }
        ps.clearBatch();
        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"045002", (Object[])new Object[]{"" + (System.currentTimeMillis() - startTime), StringUtils.toJVMIDString((Object)ps)}));
        }
        return flag;
    }

    public ResultSet executeStatementQuery(ExecutionContext ec, ManagedConnection conn, String stmt, PreparedStatement ps) throws SQLException {
        ConnectionStatementState state;
        if (this.supportsBatching && (state = this.getConnectionStatementState(conn)) != null) {
            if (state.processable) {
                this.processConnectionStatement(conn);
            } else if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"052106", (Object[])new Object[]{state.stmtText, stmt}));
            }
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (ps instanceof ParamLoggingPreparedStatement) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)((ParamLoggingPreparedStatement)ps).getStatementWithParamsReplaced());
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)stmt);
            }
        }
        ResultSet rs = ps.executeQuery();
        if (ec != null && ec.getStatistics() != null) {
            ec.getStatistics().incrementNumReads();
        }
        ps.clearBatch();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)Localiser.msg((String)"045000", (long)(System.currentTimeMillis() - startTime)));
        }
        return rs;
    }

    public void abortStatementForConnection(ManagedConnection conn, PreparedStatement ps) {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state != null && state.stmt == ps) {
            try {
                this.removeConnectionStatementState(conn);
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void closeStatement(ManagedConnection conn, PreparedStatement ps) throws SQLException {
        block5: {
            ConnectionStatementState state = this.getConnectionStatementState(conn);
            if (state != null && state.stmt == ps) {
                state.closeStatementOnProcess = true;
            } else {
                try {
                    if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                        NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"052110", (Object[])new Object[]{StringUtils.toJVMIDString((Object)ps)}));
                    }
                    ps.close();
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().equals("Already closed")) break block5;
                    throw sqle;
                }
            }
        }
    }

    public void processStatementsForConnection(ManagedConnection conn) throws SQLException {
        if (!this.supportsBatching || this.getConnectionStatementState(conn) == null) {
            return;
        }
        this.processConnectionStatement(conn);
    }

    protected int[] processConnectionStatement(ManagedConnection conn) throws SQLException {
        ConnectionStatementState state = this.getConnectionStatementState(conn);
        if (state == null || !state.processable) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        if (NucleusLogger.DATASTORE_NATIVE.isDebugEnabled()) {
            if (state.stmt instanceof ParamLoggingPreparedStatement) {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)((ParamLoggingPreparedStatement)state.stmt).getStatementWithParamsReplaced());
            } else {
                NucleusLogger.DATASTORE_NATIVE.debug((Object)state.stmtText);
            }
        }
        try {
            int[] ind = state.stmt.executeBatch();
            state.stmt.clearBatch();
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"045001", (Object[])new Object[]{"" + (System.currentTimeMillis() - startTime), StringUtils.intArrayToString((int[])ind), StringUtils.toJVMIDString((Object)state.stmt)}));
            }
            this.removeConnectionStatementState(conn);
            if (state.closeStatementOnProcess) {
                state.stmt.close();
            }
            if (ind.length != state.handlers.size()) {
                throw new IllegalStateException();
            }
            for (int i = 0; i != ind.length; ++i) {
                IntConsumer handler = state.handlers.get(i);
                if (handler == null) continue;
                handler.accept(ind[i]);
            }
            int[] i = ind;
            return i;
        }
        catch (BatchUpdateException e) {
            String msg = String.format("Batched statement \"%s\" failed. \n", state.stmtText);
            throw new RequestUtil.BatchUpdateWithSQLException(msg + e.getMessage(), e);
        }
        finally {
            ExecutionContext ec;
            ManagerStatistics stats;
            state.handlers.clear();
            if (conn instanceof ManagedConnectionWithExecutionContext && (stats = (ec = ((ManagedConnectionWithExecutionContext)conn).getExecutionContext()).getStatistics()) != null) {
                stats.incrementNumWrites();
            }
        }
    }

    protected void removeConnectionStatementState(ManagedConnection conn) {
        this.connectionStatements.remove(conn);
    }

    protected ConnectionStatementState getConnectionStatementState(ManagedConnection conn) {
        return this.connectionStatements.get(conn);
    }

    protected void setConnectionStatementState(final ManagedConnection conn, ConnectionStatementState state) {
        this.connectionStatements.put(conn, state);
        ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

            public void transactionFlushed() {
                try {
                    SQLController.this.processStatementsForConnection(conn);
                }
                catch (SQLException e) {
                    ConnectionStatementState state = SQLController.this.getConnectionStatementState(conn);
                    if (state != null) {
                        SQLController.this.removeConnectionStatementState(conn);
                        if (state.closeStatementOnProcess) {
                            try {
                                state.stmt.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                    throw RequestUtil.convertSqlException(Localiser.msg((String)"052108"), e);
                }
            }

            public void transactionPreClose() {
            }

            public void managedConnectionPreClose() {
            }

            public void managedConnectionPostClose() {
                conn.removeListener((ManagedConnectionResourceListener)this);
            }

            public void resourcePostClose() {
                conn.removeListener((ManagedConnectionResourceListener)this);
            }
        };
        conn.addListener(listener);
    }

    public static enum StatementLoggingType {
        JDBC,
        PARAMS_INLINE,
        PARAMS_IN_BRACKETS;

    }

    static class ConnectionStatementState {
        PreparedStatement stmt = null;
        String stmtText = null;
        int batchSize = 0;
        boolean processable = false;
        boolean closeStatementOnProcess = false;
        private final List<IntConsumer> handlers = new ArrayList<IntConsumer>();

        ConnectionStatementState() {
        }

        public String toString() {
            return "StmtState : stmt=" + StringUtils.toJVMIDString((Object)this.stmt) + " sql=" + this.stmtText + " batch=" + this.batchSize + " closeOnProcess=" + this.closeStatementOnProcess;
        }
    }
}

