/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NotYetFlushedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.table.AbstractClassTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class InsertRequest
extends Request {
    private static final int IDPARAMNUMBER = 1;
    private final List<MappingCallbacks> mappingCallbacks;
    private final List<JavaTypeMapping> postSetMappings;
    private final int[] insertFieldNumbers;
    private final int[] pkFieldNumbers;
    private final int[] reachableFieldNumbers;
    private final int[] relationFieldNumbers;
    private final String insertStmt;
    private boolean hasIdentityColumn = false;
    private StatementMappingIndex[] stmtMappings;
    private StatementMappingIndex[] retrievedStmtMappings;
    private StatementMappingIndex versionStmtMapping;
    private StatementMappingIndex discriminatorStmtMapping;
    private StatementMappingIndex multitenancyStmtMapping;
    private StatementMappingIndex softDeleteStmtMapping;
    private StatementMappingIndex createUserStmtMapping;
    private StatementMappingIndex createTimestampStmtMapping;
    private StatementMappingIndex updateUserStmtMapping;
    private StatementMappingIndex updateTimestampStmtMapping;
    private StatementMappingIndex[] externalFKStmtMappings;
    private StatementMappingIndex[] externalFKDiscrimStmtMappings;
    private StatementMappingIndex[] externalOrderStmtMappings;
    private boolean batch = false;

    public InsertRequest(DatastoreClass table, AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        super(table);
        InsertMappingConsumer consumer = new InsertMappingConsumer(clr, cmd, 1);
        table.provideSurrogateMapping(SurrogateColumnType.DATASTORE_ID, consumer);
        table.provideNonPrimaryKeyMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        table.provideSurrogateMapping(SurrogateColumnType.VERSION, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.MULTITENANCY, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.SOFTDELETE, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.CREATE_USER, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.CREATE_TIMESTAMP, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.UPDATE_USER, consumer);
        table.provideSurrogateMapping(SurrogateColumnType.UPDATE_TIMESTAMP, consumer);
        table.provideExternalMappings(consumer, MappingType.EXTERNAL_FK);
        table.provideExternalMappings(consumer, MappingType.EXTERNAL_FK_DISCRIMINATOR);
        table.provideExternalMappings(consumer, MappingType.EXTERNAL_INDEX);
        table.provideUnmappedColumns(consumer);
        this.mappingCallbacks = consumer.getMappingCallbacks();
        this.postSetMappings = consumer.getPostSetMappings();
        this.stmtMappings = consumer.getStatementMappings();
        this.versionStmtMapping = consumer.getVersionStatementMapping();
        this.discriminatorStmtMapping = consumer.getDiscriminatorStatementMapping();
        this.multitenancyStmtMapping = consumer.getMultitenancyStatementMapping();
        this.softDeleteStmtMapping = consumer.getSoftDeleteStatementMapping();
        this.createUserStmtMapping = consumer.getCreateUserStatementMapping();
        this.createTimestampStmtMapping = consumer.getCreateTimestampStatementMapping();
        this.updateUserStmtMapping = consumer.getUpdateUserStatementMapping();
        this.updateTimestampStmtMapping = consumer.getUpdateTimestampStatementMapping();
        this.externalFKStmtMappings = consumer.getExternalFKStatementMapping();
        this.externalFKDiscrimStmtMappings = consumer.getExternalFKDiscrimStatementMapping();
        this.externalOrderStmtMappings = consumer.getExternalOrderStatementMapping();
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        if (table.getIdentityType() == IdentityType.APPLICATION && this.pkFieldNumbers.length < 1 && !this.hasIdentityColumn) {
            throw new NucleusException(Localiser.msg((String)"052200", (Object[])new Object[]{cmd.getFullClassName()})).setFatal();
        }
        this.insertFieldNumbers = consumer.getInsertFieldNumbers();
        this.retrievedStmtMappings = consumer.getReachableStatementMappings();
        this.reachableFieldNumbers = consumer.getReachableFieldNumbers();
        this.relationFieldNumbers = consumer.getRelationFieldNumbers();
        this.insertStmt = consumer.getInsertStmt();
        if (!this.hasIdentityColumn && !cmd.hasRelations(clr) && this.externalFKStmtMappings == null) {
            this.batch = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DNStateManager sm) {
        ExecutionContext ec = sm.getExecutionContext();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052207", (Object[])new Object[]{sm.getObjectAsPrintable(), this.table}));
        }
        try {
            VersionMetaData vermd = this.table.getVersionMetaData();
            RDBMSStoreManager storeMgr = this.table.getStoreManager();
            if (vermd != null && vermd.getMemberName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getMemberName());
                Object currentVersion = sm.getVersion();
                if (currentVersion instanceof Number) {
                    currentVersion = ((Number)currentVersion).longValue();
                }
                Object nextOptimisticVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                if (verfmd.getType() == Integer.class || verfmd.getType() == Integer.TYPE) {
                    nextOptimisticVersion = ((Number)nextOptimisticVersion).intValue();
                }
                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextOptimisticVersion);
            }
            sm.setInserting();
            SQLController sqlControl = storeMgr.getSQLController();
            ManagedConnection mconn = storeMgr.getConnectionManager().getConnection(ec);
            try {
                List pkColumns;
                List<String> pkColumnNames = new ArrayList<String>();
                if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                    JavaTypeMapping mapping = this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, true);
                    ColumnMapping[] columnMappings = mapping.getColumnMappings();
                    pkColumnNames = Stream.of(columnMappings).map(cm -> cm.getColumn().getIdentifier().getName()).collect(Collectors.toList());
                } else if (this.table.getIdentityType() == IdentityType.APPLICATION && !(pkColumns = ((AbstractClassTable)((Object)this.table)).getPrimaryKey().getColumns()).isEmpty()) {
                    pkColumnNames = pkColumns.stream().map(cm -> cm.getIdentifier().getName()).collect(Collectors.toList());
                }
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.insertStmt, this.batch, this.hasIdentityColumn && storeMgr.getDatastoreAdapter().supportsOption("GetGeneratedKeysStatement"), pkColumnNames);
                try {
                    JavaTypeMapping discrimMapping;
                    int k;
                    JavaTypeMapping versionMapping;
                    int i;
                    int i2;
                    StatementClassMapping mappingDefinition = new StatementClassMapping();
                    for (int i3 = 0; i3 < this.stmtMappings.length; ++i3) {
                        if (this.stmtMappings[i3] == null) continue;
                        mappingDefinition.addMappingForMember(i3, this.stmtMappings[i3]);
                    }
                    if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                        if (!this.table.isObjectIdDatastoreAttributed() || !this.table.isBaseDatastoreClass()) {
                            int[] paramNumber = new int[]{1};
                            this.table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false).setObject(ec, ps, paramNumber, sm.getInternalObjectId());
                        }
                    } else if (this.table.getIdentityType() == IdentityType.APPLICATION && this.pkFieldNumbers != null && this.pkFieldNumbers.length > 0) {
                        sm.provideFields(this.pkFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, mappingDefinition));
                    }
                    if (this.insertFieldNumbers.length > 0) {
                        AbstractClassMetaData cmd = sm.getClassMetaData();
                        for (int i4 = 0; i4 < this.insertFieldNumbers.length; ++i4) {
                            if (this.insertFieldNumbers[i4] == cmd.getCreateTimestampMemberPosition()) {
                                AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.insertFieldNumbers[i4]);
                                if (!mmd.isCreateTimestamp()) continue;
                                if (mmd.getType().isAssignableFrom(Instant.class)) {
                                    sm.replaceField(this.insertFieldNumbers[i4], (Object)(ec.getTransaction().getIsActive() ? Instant.ofEpochMilli(ec.getTransaction().getBeginTime()) : Instant.now()));
                                    continue;
                                }
                                sm.replaceField(this.insertFieldNumbers[i4], (Object)(ec.getTransaction().getIsActive() ? new Timestamp(ec.getTransaction().getBeginTime()) : new Timestamp(System.currentTimeMillis())));
                                continue;
                            }
                            if (this.insertFieldNumbers[i4] == cmd.getCreateUserMemberPosition()) {
                                sm.replaceField(cmd.getCreateUserMemberPosition(), (Object)ec.getCurrentUser());
                                continue;
                            }
                            if (this.insertFieldNumbers[i4] == cmd.getUpdateTimestampMemberPosition()) {
                                sm.replaceField(this.insertFieldNumbers[i4], null);
                                continue;
                            }
                            if (this.insertFieldNumbers[i4] != cmd.getUpdateUserMemberPosition()) continue;
                            sm.replaceField(this.insertFieldNumbers[i4], null);
                        }
                        int numberOfFieldsToProvide = 0;
                        int numMembers = cmd.getMemberCount();
                        for (i2 = 0; i2 < this.insertFieldNumbers.length; ++i2) {
                            if (this.insertFieldNumbers[i2] >= numMembers) continue;
                            ++numberOfFieldsToProvide;
                        }
                        int j = 0;
                        int[] fieldNums = new int[numberOfFieldsToProvide];
                        for (i = 0; i < this.insertFieldNumbers.length; ++i) {
                            if (this.insertFieldNumbers[i] >= numMembers) continue;
                            fieldNums[j++] = this.insertFieldNumbers[i];
                        }
                        sm.provideFields(fieldNums, (FieldManager)new ParameterSetter(sm, ps, mappingDefinition));
                    }
                    if ((versionMapping = this.table.getSurrogateMapping(SurrogateColumnType.VERSION, false)) != null) {
                        Object currentVersion = sm.getVersion();
                        Object nextOptimisticVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                        for (k = 0; k < this.versionStmtMapping.getNumberOfParameterOccurrences(); ++k) {
                            versionMapping.setObject(ec, ps, this.versionStmtMapping.getParameterPositionsForOccurrence(k), nextOptimisticVersion);
                        }
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    } else if (vermd != null && vermd.getMemberName() != null) {
                        Object currentVersion = sm.getVersion();
                        Object nextOptimisticVersion = ec.getLockManager().getNextVersion(vermd, currentVersion);
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    }
                    if (this.multitenancyStmtMapping != null) {
                        String tenantId = ec.getTenantId();
                        if (tenantId == null) {
                            NucleusLogger.PERSISTENCE.warn((Object)"Insert of object with multitenancy column but tenantId not set! Suggest that you set it.");
                        }
                        this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false).setObject(ec, ps, this.multitenancyStmtMapping.getParameterPositionsForOccurrence(0), tenantId);
                    }
                    if (this.softDeleteStmtMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false).setObject(ec, ps, this.softDeleteStmtMapping.getParameterPositionsForOccurrence(0), Boolean.FALSE);
                    }
                    if (this.createUserStmtMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.CREATE_USER, false).setObject(ec, ps, this.createUserStmtMapping.getParameterPositionsForOccurrence(0), ec.getCurrentUser());
                    }
                    if (this.createTimestampStmtMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.CREATE_TIMESTAMP, false).setObject(ec, ps, this.createTimestampStmtMapping.getParameterPositionsForOccurrence(0), new Timestamp(ec.getTransaction().getIsActive() ? ec.getTransaction().getBeginTime() : System.currentTimeMillis()));
                    }
                    if (this.updateUserStmtMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.UPDATE_USER, false).setObject(ec, ps, this.updateUserStmtMapping.getParameterPositionsForOccurrence(0), "");
                    }
                    if (this.updateTimestampStmtMapping != null) {
                        this.table.getSurrogateMapping(SurrogateColumnType.UPDATE_TIMESTAMP, false).setObject(ec, ps, this.updateTimestampStmtMapping.getParameterPositionsForOccurrence(0), null);
                    }
                    if ((discrimMapping = this.table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false)) != null) {
                        Object discVal = sm.getClassMetaData().getDiscriminatorValue();
                        for (k = 0; k < this.discriminatorStmtMapping.getNumberOfParameterOccurrences(); ++k) {
                            discrimMapping.setObject(ec, ps, this.discriminatorStmtMapping.getParameterPositionsForOccurrence(k), discVal);
                        }
                    }
                    if (this.externalFKStmtMappings != null) {
                        for (int i5 = 0; i5 < this.externalFKStmtMappings.length; ++i5) {
                            Object fkValue = sm.getAssociatedValue((Object)this.externalFKStmtMappings[i5].getMapping());
                            if (fkValue != null) {
                                AbstractMemberMetaData ownerFmd = this.table.getMetaDataForExternalMapping(this.externalFKStmtMappings[i5].getMapping(), MappingType.EXTERNAL_FK);
                                for (int k2 = 0; k2 < this.externalFKStmtMappings[i5].getNumberOfParameterOccurrences(); ++k2) {
                                    this.externalFKStmtMappings[i5].getMapping().setObject(ec, ps, this.externalFKStmtMappings[i5].getParameterPositionsForOccurrence(k2), fkValue, null, ownerFmd.getAbsoluteFieldNumber());
                                }
                                continue;
                            }
                            for (int k3 = 0; k3 < this.externalFKStmtMappings[i5].getNumberOfParameterOccurrences(); ++k3) {
                                this.externalFKStmtMappings[i5].getMapping().setObject(ec, ps, this.externalFKStmtMappings[i5].getParameterPositionsForOccurrence(k3), null);
                            }
                        }
                    }
                    if (this.externalFKDiscrimStmtMappings != null) {
                        for (int i6 = 0; i6 < this.externalFKDiscrimStmtMappings.length; ++i6) {
                            Object discrimValue = sm.getAssociatedValue((Object)this.externalFKDiscrimStmtMappings[i6].getMapping());
                            for (int k4 = 0; k4 < this.externalFKDiscrimStmtMappings[i6].getNumberOfParameterOccurrences(); ++k4) {
                                this.externalFKDiscrimStmtMappings[i6].getMapping().setObject(ec, ps, this.externalFKDiscrimStmtMappings[i6].getParameterPositionsForOccurrence(k4), discrimValue);
                            }
                        }
                    }
                    if (this.externalOrderStmtMappings != null) {
                        for (int i7 = 0; i7 < this.externalOrderStmtMappings.length; ++i7) {
                            Object orderValue = sm.getAssociatedValue((Object)this.externalOrderStmtMappings[i7].getMapping());
                            if (orderValue == null) {
                                orderValue = -1;
                            }
                            for (int k5 = 0; k5 < this.externalOrderStmtMappings[i7].getNumberOfParameterOccurrences(); ++k5) {
                                this.externalOrderStmtMappings[i7].getMapping().setObject(ec, ps, this.externalOrderStmtMappings[i7].getParameterPositionsForOccurrence(k5), orderValue);
                            }
                        }
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, this.insertStmt, ps, !this.batch);
                    if (this.hasIdentityColumn) {
                        Object newId = this.getInsertedIdentityValue(ec, sqlControl, sm, mconn, ps);
                        sm.setPostStoreNewObjectId(newId);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)Localiser.msg((String)"052206", (Object[])new Object[]{sm.getObjectAsPrintable(), IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId())}));
                        }
                    }
                    if (this.postSetMappings != null) {
                        for (JavaTypeMapping m : this.postSetMappings) {
                            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052222", (Object[])new Object[]{sm.getObjectAsPrintable(), m.getMemberMetaData().getFullFieldName()}));
                            }
                            m.performSetPostProcessing(sm);
                        }
                    }
                    storeMgr.setObjectIsInsertedToLevel(sm, this.table);
                    for (int i8 = 0; i8 < this.relationFieldNumbers.length; ++i8) {
                        Object value = sm.provideField(this.relationFieldNumbers[i8]);
                        if (value == null || !ec.getApiAdapter().isDetached(value)) continue;
                        Object valueAttached = ec.persistObjectInternal(value, null, PersistableObjectType.PC);
                        sm.replaceField(this.relationFieldNumbers[i8], valueAttached);
                    }
                    if (this.reachableFieldNumbers.length > 0) {
                        int numberOfReachableFields = 0;
                        for (i2 = 0; i2 < this.reachableFieldNumbers.length; ++i2) {
                            if (this.reachableFieldNumbers[i2] >= sm.getClassMetaData().getMemberCount()) continue;
                            ++numberOfReachableFields;
                        }
                        int[] fieldNums = new int[numberOfReachableFields];
                        int j = 0;
                        for (i = 0; i < this.reachableFieldNumbers.length; ++i) {
                            if (this.reachableFieldNumbers[i] >= sm.getClassMetaData().getMemberCount()) continue;
                            fieldNums[j++] = this.reachableFieldNumbers[i];
                        }
                        mappingDefinition = new StatementClassMapping();
                        for (i = 0; i < this.retrievedStmtMappings.length; ++i) {
                            if (this.retrievedStmtMappings[i] == null) continue;
                            mappingDefinition.addMappingForMember(i, this.retrievedStmtMappings[i]);
                        }
                        NucleusLogger.PERSISTENCE.debug((Object)("Performing reachability on fields " + StringUtils.intArrayToString((int[])fieldNums)));
                        sm.provideFields(fieldNums, (FieldManager)new ParameterSetter(sm, ps, mappingDefinition));
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = Localiser.msg((String)"052208", (Object[])new Object[]{sm.getObjectAsPrintable(), this.insertStmt, e.getMessage()});
            NucleusLogger.DATASTORE_PERSIST.warn((Object)msg);
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            exceptions.add(e);
            while ((e = e.getNextException()) != null) {
                exceptions.add(e);
            }
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
        if (this.mappingCallbacks != null) {
            for (MappingCallbacks m : this.mappingCallbacks) {
                try {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"052209", (Object[])new Object[]{IdentityUtils.getPersistableIdentityForId((Object)sm.getInternalObjectId()), ((JavaTypeMapping)((Object)m)).getMemberMetaData().getFullFieldName()}));
                    }
                    m.postInsert(sm);
                }
                catch (NotYetFlushedException e) {
                    sm.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)((Object)m)).getMemberMetaData().getAbsoluteFieldNumber());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInsertedIdentityValue(ExecutionContext ec, SQLController sqlControl, DNStateManager sm, ManagedConnection mconn, PreparedStatement ps) throws SQLException {
        Object identityValue = null;
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        if (storeMgr.getDatastoreAdapter().supportsOption("GetGeneratedKeysStatement")) {
            try (ResultSet rs = null;){
                rs = ps.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    identityValue = rs.getObject(1);
                }
            }
        }
        if (identityValue == null) {
            String columnName = null;
            JavaTypeMapping idMapping = this.table.getIdMapping();
            if (idMapping != null) {
                for (int i = 0; i < idMapping.getNumberOfColumnMappings(); ++i) {
                    Column col = idMapping.getColumnMapping(i).getColumn();
                    if (!col.isIdentity()) continue;
                    columnName = col.getIdentifier().toString();
                    break;
                }
            }
            String autoIncStmt = storeMgr.getDatastoreAdapter().getIdentityLastValueStmt(this.table, columnName);
            PreparedStatement psAutoIncrement = sqlControl.getStatementForQuery(mconn, autoIncStmt);
            ResultSet rs = null;
            try {
                rs = sqlControl.executeStatementQuery(ec, mconn, autoIncStmt, psAutoIncrement);
                if (rs.next()) {
                    identityValue = rs.getObject(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (psAutoIncrement != null) {
                    psAutoIncrement.close();
                }
            }
        }
        if (identityValue == null) {
            throw new NucleusDataStoreException(Localiser.msg((String)"052205", (Object[])new Object[]{this.table}));
        }
        return identityValue;
    }

    private class InsertMappingConsumer
    implements MappingConsumer {
        List<Integer> insertFields = new ArrayList<Integer>();
        List<Integer> pkFields = new ArrayList<Integer>();
        List<Integer> reachableFields = new ArrayList<Integer>();
        List<Integer> relationFields = new ArrayList<Integer>();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnValues = new StringBuilder();
        Map<String, Integer> assignedColumns = new HashMap<String, Integer>();
        List<JavaTypeMapping> postSetMappings;
        List<MappingCallbacks> callbackMappings = null;
        boolean initialized = false;
        int paramIndex;
        private StatementMappingIndex[] statementMappings;
        private StatementMappingIndex[] retrievedStatementMappings;
        private StatementMappingIndex versionStatementMapping;
        private StatementMappingIndex discriminatorStatementMapping;
        private StatementMappingIndex multitenancyStatementMapping;
        private StatementMappingIndex softDeleteStatementMapping;
        private StatementMappingIndex createUserStatementMapping;
        private StatementMappingIndex createTimestampStatementMapping;
        private StatementMappingIndex updateUserStatementMapping;
        private StatementMappingIndex updateTimestampStatementMapping;
        private StatementMappingIndex[] externalFKStmtExprIndex;
        private StatementMappingIndex[] externalFKDiscrimStmtExprIndex;
        private StatementMappingIndex[] externalOrderStmtExprIndex;
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public InsertMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd, int initialParamIndex) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = initialParamIndex;
        }

        @Override
        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                this.statementMappings = new StatementMappingIndex[highestFieldNumber];
                this.retrievedStatementMappings = new StatementMappingIndex[highestFieldNumber];
                this.initialized = true;
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData mmd) {
            if (!mmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInInsertStatement()) {
                if (m.getNumberOfColumnMappings() == 0 && (m instanceof PersistableMapping || m instanceof ReferenceMapping)) {
                    this.retrievedStatementMappings[mmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
                    RelationType relationType = mmd.getRelationType(this.clr);
                    if (relationType == RelationType.ONE_TO_ONE_BI) {
                        if (mmd.getMappedBy() != null) {
                            this.reachableFields.add(mmd.getAbsoluteFieldNumber());
                        }
                    } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                        if (mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                            this.reachableFields.add(mmd.getAbsoluteFieldNumber());
                        }
                    }
                } else {
                    RelationType relationType;
                    if (mmd.hasExtension("insertable") && mmd.getValueForExtension("insertable").equalsIgnoreCase("false")) {
                        return;
                    }
                    ColumnMetaData[] colmds = mmd.getColumnMetaData();
                    if (colmds != null && colmds.length > 0) {
                        for (int i = 0; i < colmds.length; ++i) {
                            if (colmds[i].getInsertable()) continue;
                            return;
                        }
                    }
                    if ((relationType = mmd.getRelationType(this.clr)) == RelationType.ONE_TO_ONE_BI) {
                        if (mmd.getMappedBy() == null) {
                            // empty if block
                        }
                    } else if (relationType == RelationType.MANY_TO_ONE_BI) {
                        AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                        if (mmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                            this.relationFields.add(mmd.getAbsoluteFieldNumber());
                        }
                    }
                    this.statementMappings[mmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
                    int[] parametersIndex = new int[m.getNumberOfColumnMappings()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        Column c = m.getColumnMapping(j).getColumn();
                        DatastoreIdentifier columnId = c.getIdentifier();
                        boolean columnExists = this.assignedColumns.containsKey(columnId.toString());
                        if (columnExists) {
                            parametersIndex[j] = this.assignedColumns.get(c.getIdentifier().toString());
                        }
                        if (InsertRequest.this.table instanceof SecondaryTable || !InsertRequest.this.table.isBaseDatastoreClass() || !InsertRequest.this.table.getStoreManager().isValueGenerationStrategyDatastoreAttributed(this.cmd, mmd.getAbsoluteFieldNumber()) && !c.isIdentity()) {
                            if (!columnExists) {
                                if (this.columnNames.length() > 0) {
                                    this.columnNames.append(',');
                                    this.columnValues.append(',');
                                }
                                this.columnNames.append(columnId);
                                this.columnValues.append(m.getColumnMapping(j).getInsertionInputParameter());
                            }
                            if (m.getColumnMapping(j).insertValuesOnInsert()) {
                                Integer abs_field_num = mmd.getAbsoluteFieldNumber();
                                if (mmd.isPrimaryKey()) {
                                    if (!this.pkFields.contains(abs_field_num)) {
                                        this.pkFields.add(abs_field_num);
                                    }
                                } else if (!this.insertFields.contains(abs_field_num)) {
                                    this.insertFields.add(abs_field_num);
                                }
                                if (columnExists) {
                                    parametersIndex[j] = this.assignedColumns.get(c.getIdentifier().toString());
                                } else {
                                    ++this.paramIndex;
                                }
                            }
                            if (columnExists) continue;
                            this.assignedColumns.put(c.getIdentifier().toString(), mmd.getAbsoluteFieldNumber());
                            continue;
                        }
                        InsertRequest.this.hasIdentityColumn = true;
                    }
                    this.statementMappings[mmd.getAbsoluteFieldNumber()].addParameterOccurrence(parametersIndex);
                }
            }
            if (m.requiresSetPostProcessing()) {
                if (this.postSetMappings == null) {
                    this.postSetMappings = new ArrayList<JavaTypeMapping>();
                }
                this.postSetMappings.add(m);
            }
            if (m instanceof MappingCallbacks) {
                if (this.callbackMappings == null) {
                    this.callbackMappings = new ArrayList<MappingCallbacks>();
                }
                this.callbackMappings.add((MappingCallbacks)((Object)m));
            }
        }

        @Override
        public void consumeMapping(JavaTypeMapping m, MappingType mappingType) {
            if (mappingType == MappingType.VERSION) {
                JavaTypeMapping versionMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.VERSION, false);
                if (versionMapping != null) {
                    String val = versionMapping.getColumnMapping(0).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(versionMapping.getColumnMapping(0).getColumn().getIdentifier());
                    this.columnValues.append(val);
                    this.versionStatementMapping = new StatementMappingIndex(versionMapping);
                    int[] param = new int[]{this.paramIndex++};
                    this.versionStatementMapping.addParameterOccurrence(param);
                } else {
                    this.versionStatementMapping = null;
                }
            } else if (mappingType == MappingType.DISCRIMINATOR) {
                JavaTypeMapping discrimMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
                if (discrimMapping != null) {
                    String val = discrimMapping.getColumnMapping(0).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(discrimMapping.getColumnMapping(0).getColumn().getIdentifier());
                    this.columnValues.append(val);
                    this.discriminatorStatementMapping = new StatementMappingIndex(discrimMapping);
                    int[] param = new int[]{this.paramIndex++};
                    this.discriminatorStatementMapping.addParameterOccurrence(param);
                } else {
                    this.discriminatorStatementMapping = null;
                }
            } else if (mappingType == MappingType.DATASTORE_ID) {
                if (InsertRequest.this.table.getIdentityType() == IdentityType.DATASTORE) {
                    if (!InsertRequest.this.table.isObjectIdDatastoreAttributed() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                        Iterator iterator = InsertRequest.this.key.getColumns().iterator();
                        if (this.columnNames.length() > 0) {
                            this.columnNames.append(',');
                            this.columnValues.append(',');
                        }
                        this.columnNames.append(((Column)iterator.next()).getIdentifier().toString());
                        this.columnValues.append("?");
                        ++this.paramIndex;
                    } else {
                        InsertRequest.this.hasIdentityColumn = true;
                    }
                }
            } else if (mappingType == MappingType.EXTERNAL_FK) {
                this.externalFKStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalFKStmtExprIndex);
            } else if (mappingType == MappingType.EXTERNAL_FK_DISCRIMINATOR) {
                this.externalFKDiscrimStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalFKDiscrimStmtExprIndex);
            } else if (mappingType == MappingType.EXTERNAL_INDEX) {
                this.externalOrderStmtExprIndex = this.processExternalMapping(m, this.statementMappings, this.externalOrderStmtExprIndex);
            } else if (mappingType == MappingType.MULTITENANCY) {
                JavaTypeMapping multitenancyMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false);
                String val = multitenancyMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(multitenancyMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.multitenancyStatementMapping = new StatementMappingIndex(multitenancyMapping);
                int[] param = new int[]{this.paramIndex++};
                this.multitenancyStatementMapping.addParameterOccurrence(param);
            } else if (mappingType == MappingType.SOFTDELETE) {
                JavaTypeMapping softDeleteMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false);
                String val = softDeleteMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(softDeleteMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.softDeleteStatementMapping = new StatementMappingIndex(softDeleteMapping);
                int[] param = new int[]{this.paramIndex++};
                this.softDeleteStatementMapping.addParameterOccurrence(param);
            } else if (mappingType == MappingType.CREATEUSER) {
                JavaTypeMapping createUserMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.CREATE_USER, false);
                String val = createUserMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(createUserMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.createUserStatementMapping = new StatementMappingIndex(createUserMapping);
                int[] param = new int[]{this.paramIndex++};
                this.createUserStatementMapping.addParameterOccurrence(param);
            } else if (mappingType == MappingType.CREATETIMESTAMP) {
                JavaTypeMapping createTimestampMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.CREATE_TIMESTAMP, false);
                String val = createTimestampMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(createTimestampMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.createTimestampStatementMapping = new StatementMappingIndex(createTimestampMapping);
                int[] param = new int[]{this.paramIndex++};
                this.createTimestampStatementMapping.addParameterOccurrence(param);
            } else if (mappingType == MappingType.UPDATEUSER) {
                JavaTypeMapping updateUserMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.UPDATE_USER, false);
                String val = updateUserMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(updateUserMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.updateUserStatementMapping = new StatementMappingIndex(updateUserMapping);
                int[] param = new int[]{this.paramIndex++};
                this.updateUserStatementMapping.addParameterOccurrence(param);
            } else if (mappingType == MappingType.UPDATETIMESTAMP) {
                JavaTypeMapping updateTimestampMapping = InsertRequest.this.table.getSurrogateMapping(SurrogateColumnType.UPDATE_TIMESTAMP, false);
                String val = updateTimestampMapping.getColumnMapping(0).getUpdateInputParameter();
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(updateTimestampMapping.getColumnMapping(0).getColumn().getIdentifier());
                this.columnValues.append(val);
                this.updateTimestampStatementMapping = new StatementMappingIndex(updateTimestampMapping);
                int[] param = new int[]{this.paramIndex++};
                this.updateTimestampStatementMapping.addParameterOccurrence(param);
            }
        }

        @Override
        public void consumeUnmappedColumn(Column col) {
            if (this.columnNames.length() > 0) {
                this.columnNames.append(',');
                this.columnValues.append(',');
            }
            this.columnNames.append(col.getIdentifier());
            ColumnMetaData colmd = col.getColumnMetaData();
            Object value = colmd.getInsertValue();
            if (value != null && ((String)value).equalsIgnoreCase("#NULL")) {
                value = null;
            }
            if (MetaDataUtils.isJdbcTypeString((JdbcType)colmd.getJdbcType())) {
                if (value != null) {
                    value = "'" + (String)value + "'";
                } else if (!col.isNullable()) {
                    value = "''";
                }
            }
            this.columnValues.append((String)value);
        }

        private StatementMappingIndex[] processExternalMapping(JavaTypeMapping mapping, StatementMappingIndex[] fieldStmtExprIndex, StatementMappingIndex[] stmtExprIndex) {
            int i;
            for (int i2 = 0; i2 < fieldStmtExprIndex.length; ++i2) {
                if (fieldStmtExprIndex[i2] == null || fieldStmtExprIndex[i2].getMapping() != mapping) continue;
                return stmtExprIndex;
            }
            int pos = 0;
            if (stmtExprIndex == null) {
                stmtExprIndex = new StatementMappingIndex[1];
                pos = 0;
            } else {
                for (int i3 = 0; i3 < stmtExprIndex.length; ++i3) {
                    if (stmtExprIndex[i3].getMapping() != mapping) continue;
                    return stmtExprIndex;
                }
                StatementMappingIndex[] tmpStmtExprIndex = stmtExprIndex;
                stmtExprIndex = new StatementMappingIndex[tmpStmtExprIndex.length + 1];
                for (i = 0; i < tmpStmtExprIndex.length; ++i) {
                    stmtExprIndex[i] = tmpStmtExprIndex[i];
                }
                pos = tmpStmtExprIndex.length;
            }
            stmtExprIndex[pos] = new StatementMappingIndex(mapping);
            int[] param = new int[mapping.getNumberOfColumnMappings()];
            for (i = 0; i < mapping.getNumberOfColumnMappings(); ++i) {
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(mapping.getColumnMapping(i).getColumn().getIdentifier());
                this.columnValues.append(mapping.getColumnMapping(i).getUpdateInputParameter());
                ++this.paramIndex;
            }
            stmtExprIndex[pos].addParameterOccurrence(param);
            return stmtExprIndex;
        }

        public List<JavaTypeMapping> getPostSetMappings() {
            return this.postSetMappings;
        }

        public List<MappingCallbacks> getMappingCallbacks() {
            return this.callbackMappings;
        }

        public int[] getInsertFieldNumbers() {
            int[] fieldNumbers = new int[this.insertFields.size()];
            for (int i = 0; i < this.insertFields.size(); ++i) {
                fieldNumbers[i] = this.insertFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getReachableFieldNumbers() {
            int[] fieldNumbers = new int[this.reachableFields.size()];
            for (int i = 0; i < this.reachableFields.size(); ++i) {
                fieldNumbers[i] = this.reachableFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getRelationFieldNumbers() {
            int[] fieldNumbers = new int[this.relationFields.size()];
            for (int i = 0; i < this.relationFields.size(); ++i) {
                fieldNumbers[i] = this.relationFields.get(i);
            }
            return fieldNumbers;
        }

        public StatementMappingIndex[] getStatementMappings() {
            return this.statementMappings;
        }

        public StatementMappingIndex[] getReachableStatementMappings() {
            return this.retrievedStatementMappings;
        }

        public StatementMappingIndex getVersionStatementMapping() {
            return this.versionStatementMapping;
        }

        public StatementMappingIndex getDiscriminatorStatementMapping() {
            return this.discriminatorStatementMapping;
        }

        public StatementMappingIndex getMultitenancyStatementMapping() {
            return this.multitenancyStatementMapping;
        }

        public StatementMappingIndex getSoftDeleteStatementMapping() {
            return this.softDeleteStatementMapping;
        }

        public StatementMappingIndex getCreateUserStatementMapping() {
            return this.createUserStatementMapping;
        }

        public StatementMappingIndex getCreateTimestampStatementMapping() {
            return this.createTimestampStatementMapping;
        }

        public StatementMappingIndex getUpdateUserStatementMapping() {
            return this.updateUserStatementMapping;
        }

        public StatementMappingIndex getUpdateTimestampStatementMapping() {
            return this.updateTimestampStatementMapping;
        }

        public StatementMappingIndex[] getExternalFKStatementMapping() {
            return this.externalFKStmtExprIndex;
        }

        public StatementMappingIndex[] getExternalFKDiscrimStatementMapping() {
            return this.externalFKDiscrimStmtExprIndex;
        }

        public StatementMappingIndex[] getExternalOrderStatementMapping() {
            return this.externalOrderStmtExprIndex;
        }

        public String getInsertStmt() {
            if (this.columnNames.length() > 0 && this.columnValues.length() > 0) {
                return "INSERT INTO " + InsertRequest.this.table.toString() + " (" + this.columnNames + ") VALUES (" + this.columnValues + ")";
            }
            return InsertRequest.this.table.getStoreManager().getDatastoreAdapter().getInsertStatementForNoColumns(InsertRequest.this.table);
        }
    }
}

