/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.util.Arrays;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.request.RequestType;
import org.datanucleus.store.rdbms.table.DatastoreClass;

public class RequestIdentifier {
    private final DatastoreClass table;
    private final int[] memberNumbers;
    private final int[] secondaryMemberNumbers;
    private final RequestType type;
    private final int hashCode;
    private final String className;

    public RequestIdentifier(DatastoreClass table, AbstractMemberMetaData[] mmds, RequestType type, String className) {
        this.table = table;
        this.type = type;
        this.secondaryMemberNumbers = null;
        if (mmds == null) {
            this.memberNumbers = null;
        } else {
            this.memberNumbers = new int[mmds.length];
            for (int i = 0; i < this.memberNumbers.length; ++i) {
                this.memberNumbers[i] = mmds[i].getAbsoluteFieldNumber();
            }
            Arrays.sort(this.memberNumbers);
        }
        this.className = className;
        int h = table.hashCode() ^ type.hashCode() ^ className.hashCode();
        if (this.memberNumbers != null) {
            for (int i = 0; i < this.memberNumbers.length; ++i) {
                h ^= this.memberNumbers[i];
            }
        }
        this.hashCode = h;
    }

    public RequestIdentifier(DatastoreClass table, AbstractMemberMetaData[] mmds, AbstractMemberMetaData[] secondaryMmds, RequestType type, String className) {
        int i;
        int i2;
        this.table = table;
        this.type = type;
        this.className = className;
        if (mmds == null) {
            this.memberNumbers = null;
        } else {
            this.memberNumbers = new int[mmds.length];
            for (i2 = 0; i2 < this.memberNumbers.length; ++i2) {
                this.memberNumbers[i2] = mmds[i2].getAbsoluteFieldNumber();
            }
            Arrays.sort(this.memberNumbers);
        }
        if (secondaryMmds == null) {
            this.secondaryMemberNumbers = null;
        } else {
            this.secondaryMemberNumbers = new int[secondaryMmds.length];
            for (i2 = 0; i2 < this.secondaryMemberNumbers.length; ++i2) {
                this.secondaryMemberNumbers[i2] = secondaryMmds[i2].getAbsoluteFieldNumber();
            }
            Arrays.sort(this.secondaryMemberNumbers);
        }
        int h = table.hashCode() ^ type.hashCode() ^ className.hashCode();
        if (this.memberNumbers != null) {
            for (i = 0; i < this.memberNumbers.length; ++i) {
                h ^= this.memberNumbers[i];
            }
        }
        if (this.secondaryMemberNumbers != null) {
            for (i = 0; i < this.secondaryMemberNumbers.length; ++i) {
                h ^= this.secondaryMemberNumbers[i];
            }
        }
        this.hashCode = h;
    }

    public DatastoreClass getTable() {
        return this.table;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestIdentifier)) {
            return false;
        }
        RequestIdentifier ri = (RequestIdentifier)o;
        if (this.hashCode != ri.hashCode) {
            return false;
        }
        return this.table.equals(ri.table) && this.type.equals((Object)ri.type) && this.className.equals(ri.className) && Arrays.equals(this.memberNumbers, ri.memberNumbers) && Arrays.equals(this.secondaryMemberNumbers, ri.secondaryMemberNumbers);
    }
}

