/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.NucleusLogger;

public class StringTrim2Method
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args != null && args.size() > 1) {
            throw new NucleusException("TRIM has incorrect number of args");
        }
        if (args != null && args.size() == 1) {
            NucleusLogger.QUERY.warn((Object)"This database does not support use of the trimSpec argument to trim(). Ignoring.");
        }
        if (expr instanceof StringLiteral) {
            String val = (String)((StringLiteral)expr).getValue();
            return new StringLiteral(stmt, expr.getJavaTypeMapping(), (Object)val.trim(), null);
        }
        ArrayList<SQLExpression> rtrimArgs = new ArrayList<SQLExpression>();
        rtrimArgs.add(expr);
        StringExpression strExpr = new StringExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(String.class), "RTRIM", rtrimArgs);
        ArrayList<SQLExpression> ltrimArgs = new ArrayList<SQLExpression>();
        ltrimArgs.add(strExpr);
        return new StringExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(String.class), "LTRIM", ltrimArgs);
    }
}

