/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.AggregateNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class CountFunction
implements SQLMethod {
    protected String getFunctionName() {
        return "COUNT";
    }

    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (expr == null) {
            if (args == null || args.size() != 1) {
                throw new NucleusException("COUNT is only supported with a single argument");
            }
            SQLExpression argExpr = args.get(0);
            if (argExpr.getNumberOfSubExpressions() > 1 && argExpr instanceof ObjectExpression) {
                ((ObjectExpression)argExpr).useFirstColumnOnly();
            }
            return new AggregateNumericExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(Long.TYPE, true), "COUNT", (List)args);
        }
        throw new NucleusException(Localiser.msg((String)"060002", (Object[])new Object[]{"COUNT", expr}));
    }
}

