/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.types.converters.TypeConverter;

public class TemporalLiteral
extends TemporalExpression
implements SQLLiteral {
    private final Date value;
    private String jdbcEscapeValue;

    public TemporalLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, String parameterName) {
        super(stmt, null, mapping);
        this.parameterName = parameterName;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Date) {
            this.value = (Date)value;
        } else if (value instanceof Calendar) {
            this.value = ((Calendar)value).getTime();
        } else if (value instanceof String) {
            this.value = null;
            this.jdbcEscapeValue = (String)value;
        } else {
            TypeConverter converter;
            Class type = value.getClass();
            if (mapping != null) {
                type = mapping.getJavaType();
            }
            if ((converter = stmt.getRDBMSManager().getNucleusContext().getTypeManager().getTypeConverterForType(type, Time.class)) != null) {
                this.value = (Time)converter.toDatastoreType(value);
            } else {
                converter = stmt.getRDBMSManager().getNucleusContext().getTypeManager().getTypeConverterForType(type, java.sql.Date.class);
                if (converter != null) {
                    this.value = (java.sql.Date)converter.toDatastoreType(value);
                } else {
                    converter = stmt.getRDBMSManager().getNucleusContext().getTypeManager().getTypeConverterForType(type, Timestamp.class);
                    if (converter != null) {
                        this.value = (Timestamp)converter.toDatastoreType(value);
                    } else {
                        converter = stmt.getRDBMSManager().getNucleusContext().getTypeManager().getTypeConverterForType(type, Date.class);
                        if (converter != null) {
                            this.value = (Date)converter.toDatastoreType(value);
                        } else {
                            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + value.getClass().getName());
                        }
                    }
                }
            }
        }
        if (parameterName != null) {
            this.st.appendParameter(parameterName, mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public String toString() {
        if (this.jdbcEscapeValue != null) {
            return this.jdbcEscapeValue;
        }
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    @Override
    public SQLExpression invoke(String methodName, List args) {
        if (this.jdbcEscapeValue != null) {
            throw new NucleusUserException("Cannot invoke methods on TemporalLiteral using JDBC escape syntax - not supported");
        }
        if (this.parameterName == null) {
            if (methodName.equals("getDay")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, cal.get(5), null);
            }
            if (methodName.equals("getMonth")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, cal.get(2), null);
            }
            if (methodName.equals("getYear")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, cal.get(1), null);
            }
            if (methodName.equals("getHour")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, cal.get(11), null);
            }
            if (methodName.equals("getMinutes")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, cal.get(12), null);
            }
            if (methodName.equals("getSeconds")) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.value);
                JavaTypeMapping m = this.stmt.getRDBMSManager().getMappingManager().getMapping(Integer.class);
                return new IntegerLiteral(this.stmt, m, cal.get(13), null);
            }
        }
        return super.invoke(methodName, args);
    }

    @Override
    public Object getValue() {
        if (this.jdbcEscapeValue != null) {
            return this.jdbcEscapeValue;
        }
        return this.value;
    }

    @Override
    public void setNotParameter() {
        if (this.parameterName == null) {
            return;
        }
        this.parameterName = null;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        if (this.jdbcEscapeValue != null) {
            this.st.append(this.jdbcEscapeValue);
        } else {
            String formatted;
            if (this.value instanceof Time || this.value instanceof java.sql.Date || this.value instanceof Timestamp) {
                formatted = this.value.toString();
            } else if (this.mapping.getColumnMapping(0) instanceof CharColumnMapping) {
                SimpleDateFormat fmt = ((CharColumnMapping)this.mapping.getColumnMapping(0)).getJavaUtilDateFormat();
                formatted = fmt.format(this.value);
            } else {
                formatted = new Timestamp(this.value.getTime()).toString();
            }
            this.st.append('\'').append(formatted).append('\'');
        }
    }
}

