/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.PropertyNames;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.flush.FlushOrdered;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.DatastoreIdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.TableGeneratorMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.ReferentialStateManagerImpl;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.BackedSCOStoreManager;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.autostart.AutoStartMechanism;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.AbstractSchemaTransaction;
import org.datanucleus.store.rdbms.DeleteTablesSchemaTransaction;
import org.datanucleus.store.rdbms.NucleusSequenceImpl;
import org.datanucleus.store.rdbms.RDBMSPersistenceHandler;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreHelper;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.ValidateTableSchemaTransaction;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapterFactory;
import org.datanucleus.store.rdbms.autostart.SchemaAutoStarter;
import org.datanucleus.store.rdbms.exceptions.NoTableManagedException;
import org.datanucleus.store.rdbms.exceptions.UnsupportedDataTypeException;
import org.datanucleus.store.rdbms.identifier.DN2IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.DNIdentifierFactory;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.identifier.JPAIdentifierFactory;
import org.datanucleus.store.rdbms.identifier.JPOXIdentifierFactory;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.java.ArrayMapping;
import org.datanucleus.store.rdbms.mapping.java.CollectionMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.MapMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.query.JDOQLQuery;
import org.datanucleus.store.rdbms.query.JPQLQuery;
import org.datanucleus.store.rdbms.query.SQLQuery;
import org.datanucleus.store.rdbms.query.StoredProcedureQuery;
import org.datanucleus.store.rdbms.schema.JDBCTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaHandler;
import org.datanucleus.store.rdbms.schema.RDBMSSchemaInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTableInfo;
import org.datanucleus.store.rdbms.schema.RDBMSTypesInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.FKArrayStore;
import org.datanucleus.store.rdbms.scostore.FKListStore;
import org.datanucleus.store.rdbms.scostore.FKMapStore;
import org.datanucleus.store.rdbms.scostore.FKSetStore;
import org.datanucleus.store.rdbms.scostore.JoinArrayStore;
import org.datanucleus.store.rdbms.scostore.JoinListStore;
import org.datanucleus.store.rdbms.scostore.JoinMapStore;
import org.datanucleus.store.rdbms.scostore.JoinPersistableRelationStore;
import org.datanucleus.store.rdbms.scostore.JoinSetStore;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.ArrayTable;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.PersistableJoinTable;
import org.datanucleus.store.rdbms.table.ProbeTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.store.rdbms.valuegenerator.SequenceTable;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.store.schema.SchemaScriptAwareStoreManager;
import org.datanucleus.store.schema.StoreSchemaData;
import org.datanucleus.store.types.IncompatibleFieldTypeException;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationConnectionProvider;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MacroString;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSStoreManager
extends AbstractStoreManager
implements BackedSCOStoreManager,
SchemaAwareStoreManager,
SchemaScriptAwareStoreManager {
    public static final String METADATA_NONDURABLE_REQUIRES_TABLE = "requires-table";
    protected DatastoreAdapter dba;
    protected IdentifierFactory identifierFactory;
    protected String catalogName = null;
    protected String schemaName = null;
    protected MappingManager mappingManager;
    protected Map<DNStateManager, DatastoreClass> insertedDatastoreClassByStateManager = new ConcurrentHashMap<DNStateManager, DatastoreClass>();
    protected ReadWriteLock schemaLock = new ReentrantReadWriteLock();
    private SQLController sqlController = null;
    protected SQLExpressionFactory expressionFactory;
    private transient Calendar dateTimezoneCalendar = null;
    private ClassAdder classAdder = null;
    private Writer ddlWriter = null;
    private boolean completeDDL = false;
    private Set<String> writtenDdlStatements = null;
    private Map<String, Collection<AbstractMemberMetaData>> schemaCallbacks = new HashMap<String, Collection<AbstractMemberMetaData>>();
    private Map<String, Store> backingStoreByMemberName = new ConcurrentHashMap<String, Store>();
    boolean performingDeleteSchemaForClasses = false;

    public RDBMSStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("rdbms", clr, ctx, props);
        this.persistenceHandler = new RDBMSPersistenceHandler((StoreManager)this);
        this.flushProcess = new FlushOrdered();
        this.schemaHandler = new RDBMSSchemaHandler((StoreManager)this);
        try {
            ManagedConnection mc = this.connectionMgr.getConnection(-1);
            Connection conn = (Connection)mc.getConnection();
            if (conn == null) {
                throw new NucleusDataStoreException(Localiser.msg((String)"050007"));
            }
            try {
                String validCatalogName;
                String validSchemaName;
                this.dba = DatastoreAdapterFactory.getInstance().getDatastoreAdapter(clr, conn, this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_DATASTORE_ADAPTER_CLASS_NAME), ctx.getPluginManager());
                this.dba.initialise(this.schemaHandler, mc);
                if (this.hasPropertyNotNull("datanucleus.mapping.catalog")) {
                    if (!this.dba.supportsOption("CatalogInTableDefinition")) {
                        NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"050002", (Object[])new Object[]{this.getStringProperty("datanucleus.mapping.catalog")}));
                    } else {
                        this.catalogName = this.getStringProperty("datanucleus.mapping.catalog");
                    }
                }
                if (this.hasPropertyNotNull("datanucleus.mapping.schema")) {
                    if (!this.dba.supportsOption("SchemaInTableDefinition")) {
                        NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"050003", (Object[])new Object[]{this.getStringProperty("datanucleus.mapping.schema")}));
                    } else {
                        this.schemaName = this.getStringProperty("datanucleus.mapping.schema");
                    }
                }
                this.initialiseIdentifierFactory((NucleusContext)ctx);
                if (this.schemaName != null && !(validSchemaName = this.identifierFactory.getIdentifierInAdapterCase(this.schemaName)).equals(this.schemaName)) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"020192", (Object[])new Object[]{"schema", this.schemaName, validSchemaName}));
                    this.schemaName = validSchemaName;
                }
                if (this.catalogName != null && !(validCatalogName = this.identifierFactory.getIdentifierInAdapterCase(this.catalogName)).equals(this.catalogName)) {
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"020192", (Object[])new Object[]{"catalog", this.catalogName, validCatalogName}));
                    this.catalogName = validCatalogName;
                }
                this.sqlController = new SQLController(this.dba.supportsOption("StatementBatching"), this.getIntProperty(RDBMSPropertyNames.PROPERTY_RDBMS_STATEMENT_BATCH_LIMIT), this.getIntProperty("datanucleus.datastorereadtimeout"), SQLController.StatementLoggingType.valueOf(this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_STATEMENT_LOGGING)));
                this.initialiseSchema(conn, clr);
                this.logConfiguration();
            }
            catch (Exception e) {
                NucleusLogger.GENERAL.info((Object)"Error in initialisation of RDBMSStoreManager", (Throwable)e);
                throw e;
            }
            finally {
                mc.release();
            }
        }
        catch (NucleusException ne) {
            NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"050004"), (Throwable)ne);
            throw ne.setFatal();
        }
        catch (Exception e1) {
            String msg = Localiser.msg((String)"050004") + " " + Localiser.msg((String)"050006") + " " + Localiser.msg((String)"048000", (Object[])new Object[]{e1});
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg, (Throwable)e1);
            throw new NucleusUserException(msg, (Throwable)e1).setFatal();
        }
    }

    public String getQueryCacheKey() {
        return this.getStoreManagerKey() + "-" + this.getDatastoreAdapter().getVendorID();
    }

    protected void initialiseIdentifierFactory(NucleusContext nucleusContext) {
        if (this.dba == null) {
            throw new NucleusException("DatastoreAdapter not yet created so cannot create IdentifierFactory!");
        }
        String idFactoryName = this.getStringProperty("datanucleus.identifierfactory");
        try {
            String val;
            HashMap<String, String> props = new HashMap<String, String>();
            if (this.catalogName != null) {
                props.put("DefaultCatalog", this.catalogName);
            }
            if (this.schemaName != null) {
                props.put("DefaultSchema", this.schemaName);
            }
            props.put("RequiredCase", (val = this.getStringProperty("datanucleus.identifier.case")) != null ? val : this.getDefaultIdentifierCase());
            val = this.getStringProperty("datanucleus.identifier.wordseparator");
            if (val != null) {
                props.put("WordSeparator", val);
            }
            if ((val = this.getStringProperty("datanucleus.identifier.tableprefix")) != null) {
                props.put("TablePrefix", val);
            }
            if ((val = this.getStringProperty("datanucleus.identifier.tablesuffix")) != null) {
                props.put("TableSuffix", val);
            }
            props.put("NamingFactory", (String)this.getNamingFactory());
            ClassLoaderResolver clr = nucleusContext.getClassLoaderResolver(null);
            if ("datanucleus2".equalsIgnoreCase(idFactoryName)) {
                this.identifierFactory = new DN2IdentifierFactory(this.dba, clr, props);
            } else if ("jpa".equalsIgnoreCase(idFactoryName) || "jakarta".equalsIgnoreCase(idFactoryName)) {
                this.identifierFactory = new JPAIdentifierFactory(this.dba, clr, props);
            } else if ("datanucleus1".equalsIgnoreCase(idFactoryName)) {
                this.identifierFactory = new DNIdentifierFactory(this.dba, clr, props);
            } else if ("jpox".equalsIgnoreCase(idFactoryName)) {
                this.identifierFactory = new JPOXIdentifierFactory(this.dba, clr, props);
            } else {
                Class[] argTypes = new Class[]{DatastoreAdapter.class, ClassConstants.CLASS_LOADER_RESOLVER, Map.class};
                Object[] args = new Object[]{this.dba, nucleusContext.getClassLoaderResolver(null), props};
                this.identifierFactory = (IdentifierFactory)nucleusContext.getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.identifierfactory", "name", idFactoryName, "class-name", argTypes, args);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new NucleusUserException(Localiser.msg((String)"039004", (Object[])new Object[]{idFactoryName}), (Throwable)cnfe).setFatal();
        }
        catch (Exception e) {
            NucleusLogger.PERSISTENCE.error((Object)"Exception creating IdentifierFactory", (Throwable)e);
            throw new NucleusException(Localiser.msg((String)"039005", (Object[])new Object[]{idFactoryName}), (Throwable)e).setFatal();
        }
    }

    public IdentifierFactory getIdentifierFactory() {
        return this.identifierFactory;
    }

    public DatastoreAdapter getDatastoreAdapter() {
        return this.dba;
    }

    public MappingManager getMappingManager() {
        if (this.mappingManager == null) {
            this.mappingManager = this.dba.getMappingManager(this);
        }
        return this.mappingManager;
    }

    public String getDefaultStateManagerClassName() {
        return ReferentialStateManagerImpl.class.getName();
    }

    public StoreData[] getStoreDataForDatastoreContainerObject(DatastoreIdentifier tableIdentifier) {
        this.schemaLock.readLock().lock();
        try {
            StoreData[] storeDataArray = this.storeDataMgr.getStoreDataForProperties("tableId", (Object)tableIdentifier, "table-owner", (Object)"true");
            return storeDataArray;
        }
        finally {
            this.schemaLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(AbstractMemberMetaData mmd) {
        this.schemaLock.readLock().lock();
        try {
            StoreData sd = this.storeDataMgr.get(mmd);
            if (sd != null && sd instanceof RDBMSStoreData) {
                Table table = (Table)sd.getTable();
                return table;
            }
            Table table = null;
            return table;
        }
        finally {
            this.schemaLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreClass getDatastoreClass(String className, ClassLoaderResolver clr) {
        DatastoreClass ct = null;
        if (className == null) {
            NucleusLogger.PERSISTENCE.error((Object)Localiser.msg((String)"032015"));
            return null;
        }
        this.schemaLock.readLock().lock();
        try {
            StoreData sd = this.storeDataMgr.get(className);
            if (sd != null && sd instanceof RDBMSStoreData && (ct = (DatastoreClass)sd.getTable()) != null) {
                DatastoreClass datastoreClass = ct;
                return datastoreClass;
            }
        }
        finally {
            this.schemaLock.readLock().unlock();
        }
        boolean toBeAdded = false;
        if (clr != null) {
            Class cls = clr.classForName(className);
            ApiAdapter api = this.getApiAdapter();
            if (cls != null && !cls.isInterface() && api.isPersistable(cls)) {
                toBeAdded = true;
            }
        } else {
            toBeAdded = true;
        }
        boolean classKnown = false;
        if (toBeAdded) {
            this.manageClasses(clr, className);
            this.schemaLock.readLock().lock();
            try {
                StoreData sd = this.storeDataMgr.get(className);
                if (sd != null && sd instanceof RDBMSStoreData) {
                    classKnown = true;
                    ct = (DatastoreClass)sd.getTable();
                }
            }
            finally {
                this.schemaLock.readLock().unlock();
            }
        }
        if (!classKnown && ct == null) {
            throw new NoTableManagedException(className);
        }
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastoreClass getDatastoreClass(DatastoreIdentifier name) {
        this.schemaLock.readLock().lock();
        try {
            for (StoreData sd : this.storeDataMgr.getManagedStoreData()) {
                RDBMSStoreData tsd;
                if (!(sd instanceof RDBMSStoreData) || !(tsd = (RDBMSStoreData)sd).hasTable() || !tsd.getDatastoreIdentifier().equals(name)) continue;
                DatastoreClass datastoreClass = (DatastoreClass)tsd.getTable();
                return datastoreClass;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            this.schemaLock.readLock().unlock();
        }
    }

    public AbstractClassMetaData[] getClassesManagingTableForClass(AbstractClassMetaData cmd, ClassLoaderResolver clr) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE || cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE) {
            return new AbstractClassMetaData[]{cmd};
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            String[] subclasses = this.getMetaDataManager().getSubclassesForClass(cmd.getFullClassName(), true);
            if (subclasses != null) {
                for (int i = 0; i < subclasses.length; ++i) {
                    if (this.storeDataMgr.managesClass(subclasses[i])) continue;
                    this.manageClasses(clr, subclasses[i]);
                }
            }
            HashSet<AbstractClassMetaData> managingClasses = new HashSet<AbstractClassMetaData>();
            for (StoreData sd : this.storeDataMgr.getManagedStoreData()) {
                AbstractClassMetaData[] superCmds;
                if (!sd.isFCO() || ((AbstractClassMetaData)sd.getMetaData()).getSuperAbstractClassMetaData() == null || !((AbstractClassMetaData)sd.getMetaData()).getSuperAbstractClassMetaData().getFullClassName().equals(cmd.getFullClassName()) || (superCmds = this.getClassesManagingTableForClass((AbstractClassMetaData)sd.getMetaData(), clr)) == null) continue;
                for (int i = 0; i < superCmds.length; ++i) {
                    managingClasses.add(superCmds[i]);
                }
            }
            Iterator managingClassesIter = managingClasses.iterator();
            AbstractClassMetaData[] managingCmds = new AbstractClassMetaData[managingClasses.size()];
            int i = 0;
            while (managingClassesIter.hasNext()) {
                managingCmds[i++] = (AbstractClassMetaData)managingClassesIter.next();
            }
            return managingCmds;
        }
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.getClassesManagingTableForClass(cmd.getSuperAbstractClassMetaData(), clr);
        }
        return null;
    }

    public boolean isObjectInserted(DNStateManager sm, int fieldNumber) {
        if (sm == null) {
            return false;
        }
        if (!sm.isInserting()) {
            return true;
        }
        DatastoreClass latestTable = this.insertedDatastoreClassByStateManager.get(sm);
        if (latestTable == null) {
            return false;
        }
        AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd == null) {
            return false;
        }
        String className = mmd.getClassName();
        if (mmd.isPrimaryKey()) {
            className = sm.getObject().getClass().getName();
        }
        for (DatastoreClass datastoreCls = latestTable; datastoreCls != null; datastoreCls = datastoreCls.getSuperDatastoreClass()) {
            if (!datastoreCls.managesClass(className)) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectInserted(DNStateManager sm, String className) {
        if (sm == null) {
            return false;
        }
        if (!sm.isInserting()) {
            return false;
        }
        DatastoreClass latestTable = this.insertedDatastoreClassByStateManager.get(sm);
        if (latestTable != null) {
            for (DatastoreClass datastoreCls = latestTable; datastoreCls != null; datastoreCls = datastoreCls.getSuperDatastoreClass()) {
                if (!datastoreCls.managesClass(className)) continue;
                return true;
            }
        }
        return false;
    }

    public void setObjectIsInsertedToLevel(DNStateManager sm, DatastoreClass table) {
        this.insertedDatastoreClassByStateManager.put(sm, table);
        if (table.managesClass(sm.getClassMetaData().getFullClassName())) {
            sm.setInsertingCallbacks();
            this.insertedDatastoreClassByStateManager.remove(sm);
        }
    }

    public Store getExistingBackingStoreForMember(AbstractMemberMetaData mmd) {
        return this.backingStoreByMemberName.get(mmd.getFullFieldName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store getBackingStoreForField(ClassLoaderResolver clr, AbstractMemberMetaData mmd, Class type) {
        if (mmd == null || mmd.isSerialized()) {
            return null;
        }
        BaseContainerStore store = this.backingStoreByMemberName.get(mmd.getFullFieldName());
        if (store != null) {
            return store;
        }
        Map<String, Store> map = this.backingStoreByMemberName;
        synchronized (map) {
            Table datastoreTable;
            store = this.backingStoreByMemberName.get(mmd.getFullFieldName());
            if (store != null) {
                return store;
            }
            Class expectedMappingType = null;
            expectedMappingType = mmd.hasMap() ? MapMapping.class : (mmd.hasArray() ? ArrayMapping.class : (mmd.hasCollection() ? CollectionMapping.class : PersistableMapping.class));
            try {
                JavaTypeMapping m;
                AbstractClassMetaData fieldTypeCmd;
                AbstractClassMetaData[] tableOwnerCmds;
                DatastoreClass ownerTable = this.getDatastoreClass(mmd.getClassName(), clr);
                if (ownerTable == null && (tableOwnerCmds = this.getClassesManagingTableForClass(fieldTypeCmd = this.getMetaDataManager().getMetaDataForClass(mmd.getClassName(), clr), clr)) != null && tableOwnerCmds.length == 1) {
                    ownerTable = this.getDatastoreClass(tableOwnerCmds[0].getFullClassName(), clr);
                }
                if (ownerTable != null && !expectedMappingType.isAssignableFrom((m = ownerTable.getMemberMapping(mmd)).getClass())) {
                    String requiredType = type != null ? type.getName() : mmd.getTypeName();
                    NucleusLogger.PERSISTENCE.warn((Object)("Member " + mmd.getFullFieldName() + " in table=" + ownerTable + " has mapping=" + m + " but expected mapping type=" + expectedMappingType));
                    throw new IncompatibleFieldTypeException(mmd.getFullFieldName(), requiredType, m.getType());
                }
            }
            catch (NoTableManagedException ownerTable) {
                // empty catch block
            }
            if (mmd.hasMap()) {
                datastoreTable = this.getTable(mmd);
                store = datastoreTable == null ? new FKMapStore(mmd, this, clr) : new JoinMapStore((MapTable)datastoreTable, clr);
            } else if (mmd.hasArray()) {
                datastoreTable = this.getTable(mmd);
                store = datastoreTable != null ? new JoinArrayStore(mmd, (ArrayTable)datastoreTable, clr) : new FKArrayStore(mmd, this, clr);
            } else if (mmd.hasCollection()) {
                datastoreTable = this.getTable(mmd);
                store = type == null ? (datastoreTable == null ? (Set.class.isAssignableFrom(mmd.getType()) ? new FKSetStore(mmd, this, clr) : (List.class.isAssignableFrom(mmd.getType()) || Queue.class.isAssignableFrom(mmd.getType()) ? new FKListStore(mmd, this, clr) : (mmd.getOrderMetaData() != null ? new FKListStore(mmd, this, clr) : new FKSetStore(mmd, this, clr)))) : (Set.class.isAssignableFrom(mmd.getType()) ? new JoinSetStore(mmd, (CollectionTable)datastoreTable, clr) : (List.class.isAssignableFrom(mmd.getType()) || Queue.class.isAssignableFrom(mmd.getType()) ? new JoinListStore(mmd, (CollectionTable)datastoreTable, clr) : (mmd.getOrderMetaData() != null ? new JoinListStore(mmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(mmd, (CollectionTable)datastoreTable, clr))))) : (datastoreTable == null ? (SCOUtils.isListBased((Class)type) ? new FKListStore(mmd, this, clr) : new FKSetStore(mmd, this, clr)) : (SCOUtils.isListBased((Class)type) ? new JoinListStore(mmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(mmd, (CollectionTable)datastoreTable, clr)));
            } else {
                store = new JoinPersistableRelationStore(mmd, (PersistableJoinTable)this.getTable(mmd), clr);
            }
            this.backingStoreByMemberName.put(mmd.getFullFieldName(), store);
            return store;
        }
    }

    public String getDefaultIdentifierCase() {
        return "UPPERCASE";
    }

    public Map<String, Collection<AbstractMemberMetaData>> getSchemaCallbacks() {
        return this.schemaCallbacks;
    }

    public void addSchemaCallback(String className, AbstractMemberMetaData mmd) {
        Collection<AbstractMemberMetaData> coll = this.schemaCallbacks.get(className);
        if (coll == null) {
            coll = new HashSet<AbstractMemberMetaData>();
            coll.add(mmd);
            this.schemaCallbacks.put(className, coll);
        } else if (!coll.contains(mmd)) {
            coll.add(mmd);
        } else {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("RDBMSStoreManager.addSchemaCallback called for " + mmd.getFullFieldName() + " on class=" + className + " but already registered"));
        }
    }

    public boolean isJdbcStore() {
        return true;
    }

    public String getNativeQueryLanguage() {
        return QueryLanguage.SQL.name();
    }

    public Collection<String> getSupportedQueryLanguages() {
        Collection languages = super.getSupportedQueryLanguages();
        languages.add(QueryLanguage.SQL.name());
        languages.add(QueryLanguage.STOREDPROC.name());
        return languages;
    }

    public boolean supportsQueryLanguage(String language) {
        return language != null && (language.equals(QueryLanguage.JDOQL.name()) || language.equals(QueryLanguage.JPQL.name()) || language.equals(QueryLanguage.SQL.name()) || language.equals(QueryLanguage.STOREDPROC.name()));
    }

    public Query newQuery(String language, ExecutionContext ec) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec);
        }
        if (language.equals(QueryLanguage.SQL.name())) {
            return new SQLQuery((StoreManager)this, ec);
        }
        if (language.equals(QueryLanguage.STOREDPROC.name())) {
            return new StoredProcedureQuery((StoreManager)this, ec);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, String queryString) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec, queryString);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec, queryString);
        }
        if (language.equals(QueryLanguage.SQL.name())) {
            return new SQLQuery((StoreManager)this, ec, queryString);
        }
        if (language.equals(QueryLanguage.STOREDPROC.name())) {
            return new StoredProcedureQuery((StoreManager)this, ec, queryString);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, Query q) {
        if (language.equals(QueryLanguage.JDOQL.name())) {
            return new JDOQLQuery((StoreManager)this, ec, (JDOQLQuery)q);
        }
        if (language.equals(QueryLanguage.JPQL.name())) {
            return new JPQLQuery((StoreManager)this, ec, (JPQLQuery)q);
        }
        if (language.equals(QueryLanguage.SQL.name())) {
            return new SQLQuery((StoreManager)this, ec, (SQLQuery)q);
        }
        if (language.equals(QueryLanguage.STOREDPROC.name())) {
            return new StoredProcedureQuery((StoreManager)this, ec, (StoredProcedureQuery)q);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    protected void logConfiguration() {
        super.logConfiguration();
        if (NucleusLogger.DATASTORE.isDebugEnabled()) {
            NucleusLogger.DATASTORE.debug((Object)("Datastore Adapter : " + this.dba.getClass().getName()));
            NucleusLogger.DATASTORE.debug((Object)("Datastore : name=\"" + this.dba.getDatastoreProductName() + "\" version=\"" + this.dba.getDatastoreProductVersion() + "\""));
            NucleusLogger.DATASTORE.debug((Object)("Datastore Driver : name=\"" + this.dba.getDatastoreDriverName() + "\" version=\"" + this.dba.getDatastoreDriverVersion() + "\""));
            Object primaryDS = null;
            primaryDS = this.getConnectionFactory() != null ? "DataSource[input DataSource]" : (this.getConnectionFactoryName() != null ? "JNDI[" + this.getConnectionFactoryName() + "]" : "URL[" + this.getConnectionURL() + "]");
            NucleusLogger.DATASTORE.debug((Object)("Primary Connection Factory : " + (String)primaryDS));
            Object secondaryDS = null;
            secondaryDS = this.getConnectionFactory2() != null ? "DataSource[input DataSource]" : (this.getConnectionFactory2Name() != null ? "JNDI[" + this.getConnectionFactory2Name() + "]" : (this.getConnectionURL() != null ? "URL[" + this.getConnectionURL() + "]" : primaryDS));
            NucleusLogger.DATASTORE.debug((Object)("Secondary Connection Factory : " + (String)secondaryDS));
            if (this.identifierFactory != null) {
                NucleusLogger.DATASTORE.debug((Object)("Datastore Identifiers : factory=\"" + this.getStringProperty("datanucleus.identifierfactory") + "\" case=" + this.identifierFactory.getNamingCase().toString() + (String)(this.catalogName != null ? " catalog=" + this.catalogName : "") + (String)(this.schemaName != null ? " schema=" + this.schemaName : "")));
                NucleusLogger.DATASTORE.debug((Object)("Supported Identifier Cases : " + (this.dba.supportsOption("LowerCaseIdentifiers") ? "lowercase " : "") + (this.dba.supportsOption("LowerCaseQuotedIdentifiers") ? "\"lowercase\" " : "") + (this.dba.supportsOption("MixedCaseIdentifiers") ? "MixedCase " : "") + (this.dba.supportsOption("MixedCaseQuotedIdentifiers") ? "\"MixedCase\" " : "") + (this.dba.supportsOption("UpperCaseIdentifiers") ? "UPPERCASE " : "") + (this.dba.supportsOption("UpperCaseQuotedIdentifiers") ? "\"UPPERCASE\" " : "") + (this.dba.supportsOption("MixedCaseSensitiveIdentifiers") ? "MixedCase-Sensitive " : "") + (this.dba.supportsOption("MixedCaseQuotedSensitiveIdentifiers") ? "\"MixedCase-Sensitive\" " : "")));
                NucleusLogger.DATASTORE.debug((Object)("Supported Identifier Lengths (max) : Table=" + this.dba.getDatastoreIdentifierMaxLength(IdentifierType.TABLE) + " Column=" + this.dba.getDatastoreIdentifierMaxLength(IdentifierType.COLUMN) + " Constraint=" + this.dba.getDatastoreIdentifierMaxLength(IdentifierType.CANDIDATE_KEY) + " Index=" + this.dba.getDatastoreIdentifierMaxLength(IdentifierType.INDEX) + " Delimiter=" + this.dba.getIdentifierQuoteString()));
                NucleusLogger.DATASTORE.debug((Object)("Support for Identifiers in DDL : catalog=" + this.dba.supportsOption("CatalogInTableDefinition") + " schema=" + this.dba.supportsOption("SchemaInTableDefinition")));
            }
            NucleusLogger.DATASTORE.debug((Object)("Datastore : rdbmsConstraintCreateMode=" + this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_CONSTRAINT_CREATE_MODE) + ", initialiseColumnInfo=" + this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_INIT_COLUMN_INFO) + (this.getBooleanProperty(RDBMSPropertyNames.PROPERTY_RDBMS_CHECK_EXISTS_TABLES_VIEWS) ? ", checkTableViewExistence" : "")));
            int batchLimit = this.getIntProperty(RDBMSPropertyNames.PROPERTY_RDBMS_STATEMENT_BATCH_LIMIT);
            boolean supportBatching = this.dba.supportsOption("StatementBatching");
            if (supportBatching) {
                NucleusLogger.DATASTORE.debug((Object)("Support Statement Batching : yes (max-batch-size=" + (String)(batchLimit == -1 ? "UNLIMITED" : "" + batchLimit) + ")"));
            } else {
                NucleusLogger.DATASTORE.debug((Object)"Support Statement Batching : no");
            }
            NucleusLogger.DATASTORE.debug((Object)("Queries : Results direction=" + this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_QUERY_FETCH_DIRECTION) + ", type=" + this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_QUERY_RESULT_SET_TYPE) + ", concurrency=" + this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_QUERY_RESULT_SET_CONCURRENCY)));
            NucleusLogger.DATASTORE.debug((Object)("Java-Types : string-default-length=" + this.getIntProperty(RDBMSPropertyNames.PROPERTY_RDBMS_STRING_DEFAULT_LENGTH)));
            RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
            if (typesInfo != null && typesInfo.getNumberOfChildren() > 0) {
                StringBuilder typeStr = new StringBuilder();
                Iterator<String> jdbcTypesIter = typesInfo.getChildren().keySet().iterator();
                while (jdbcTypesIter.hasNext()) {
                    String jdbcTypeStr = jdbcTypesIter.next();
                    short jdbcTypeNumber = 0;
                    try {
                        jdbcTypeNumber = Short.parseShort(jdbcTypeStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Object typeName = this.dba.getNameForJDBCType(jdbcTypeNumber);
                    if (typeName == null) {
                        typeName = "[id=" + jdbcTypeNumber + "]";
                    }
                    typeStr.append((String)typeName);
                    if (!jdbcTypesIter.hasNext()) continue;
                    typeStr.append(", ");
                }
                NucleusLogger.DATASTORE.debug((Object)("JDBC-Types : " + typeStr));
            }
            NucleusLogger.DATASTORE.debug((Object)"===========================================================");
        }
    }

    public synchronized void close() {
        this.dba = null;
        super.close();
        this.classAdder = null;
    }

    public NucleusSequence getNucleusSequence(ExecutionContext ec, SequenceMetaData seqmd) {
        return new NucleusSequenceImpl(ec, this, seqmd);
    }

    public SQLController getSQLController() {
        return this.sqlController;
    }

    public SQLExpressionFactory getSQLExpressionFactory() {
        if (this.expressionFactory == null) {
            this.expressionFactory = new SQLExpressionFactory(this);
        }
        return this.expressionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSchema(Connection conn, ClassLoaderResolver clr) throws Exception {
        block12: {
            if (this.schemaName == null && this.catalogName == null && (this.dba.supportsOption("CatalogInTableDefinition") || this.dba.supportsOption("SchemaInTableDefinition"))) {
                try {
                    try {
                        this.catalogName = this.dba.getCatalogName(conn);
                        this.schemaName = this.dba.getSchemaName(conn);
                    }
                    catch (UnsupportedOperationException e) {
                        if (this.getBooleanProperty("datanucleus.readonlydatastore") || !this.getSchemaHandler().isAutoCreateTables()) break block12;
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"020026"));
                        ProbeTable pt = new ProbeTable(this);
                        pt.initialize(clr);
                        pt.create(conn);
                        try {
                            String[] schema_details = pt.findSchemaDetails(conn);
                            if (schema_details != null) {
                                this.catalogName = schema_details[0];
                                this.schemaName = schema_details[1];
                            }
                        }
                        finally {
                            pt.drop(conn);
                        }
                    }
                }
                catch (SQLException e) {
                    String msg = Localiser.msg((String)"050005", (Object[])new Object[]{e.getMessage()}) + " " + Localiser.msg((String)"050006");
                    NucleusLogger.DATASTORE_SCHEMA.warn((Object)msg);
                }
            }
        }
        if (this.getBooleanProperty("datanucleus.readonlydatastore")) {
            String autoStartMechanismName = this.nucleusContext.getConfiguration().getStringProperty("datanucleus.autostartmechanism");
            if ("SchemaTable".equals(autoStartMechanismName)) {
                this.nucleusContext.getConfiguration().setProperty("datanucleus.autostartmechanism", (Object)"None");
            }
        } else {
            this.dba.initialiseDatastore(conn);
        }
    }

    private void clearSchemaData() {
        this.deregisterAllStoreData();
        this.schemaHandler.clear();
        ManagedConnection mc = this.connectionMgr.getConnection(-1);
        try {
            this.dba.initialiseTypes(this.schemaHandler, mc);
        }
        finally {
            mc.release();
        }
        ((RDBMSPersistenceHandler)this.persistenceHandler).removeAllRequests();
    }

    public String getDefaultCatalogName() {
        return this.catalogName;
    }

    public String getDefaultSchemaName() {
        return this.schemaName;
    }

    public Date getDatastoreDate() {
        Date serverDate;
        block15: {
            serverDate = null;
            String dateStmt = this.dba.getDatastoreDateStatement();
            ManagedConnection mconn = null;
            try {
                mconn = this.connectionMgr.getConnection(0);
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = this.getSQLController().getStatementForQuery(mconn, dateStmt);
                    rs = this.getSQLController().executeStatementQuery(null, mconn, dateStmt, ps);
                    if (rs.next()) {
                        Timestamp time = rs.getTimestamp(1, this.getCalendarForDateTimezone());
                        serverDate = new Date(time.getTime());
                        break block15;
                    }
                    Date time = null;
                    return time;
                }
                catch (SQLException sqle) {
                    String msg = Localiser.msg((String)"050052", (Object[])new Object[]{sqle.getMessage()});
                    NucleusLogger.DATASTORE.warn((Object)msg, (Throwable)sqle);
                    throw new NucleusUserException(msg, (Throwable)sqle).setFatal();
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        this.getSQLController().closeStatement(mconn, ps);
                    }
                }
            }
            catch (SQLException sqle) {
                String msg = Localiser.msg((String)"050052", (Object[])new Object[]{sqle.getMessage()});
                NucleusLogger.DATASTORE.warn((Object)msg, (Throwable)sqle);
                throw new NucleusException(msg, (Throwable)sqle).setFatal();
            }
            finally {
                if (mconn != null) {
                    mconn.release();
                }
            }
        }
        return serverDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null || classNames.length == 0) {
            return;
        }
        boolean allManaged = true;
        for (int i = 0; i < classNames.length; ++i) {
            if (this.managesClass(classNames[i])) continue;
            allManaged = false;
            break;
        }
        if (allManaged) {
            return;
        }
        classNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        if (classNames.length == 0) {
            return;
        }
        try {
            this.schemaLock.writeLock().lock();
            if (this.classAdder != null) {
                this.classAdder.addClassTables(classNames, clr);
                return;
            }
            int isolationLevel = this.hasProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION) ? TransactionUtils.getTransactionIsolationLevelForName((String)this.getStringProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION)) : this.dba.getTransactionIsolationForSchemaCreation();
            new ClassAdder(classNames, null, isolationLevel).execute(clr);
        }
        finally {
            this.schemaLock.writeLock().unlock();
        }
    }

    public void unmanageAllClasses(ClassLoaderResolver clr) {
        int isolationLevel = this.hasProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION) ? TransactionUtils.getTransactionIsolationLevelForName((String)this.getStringProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION)) : 2;
        DeleteTablesSchemaTransaction deleteTablesTxn = new DeleteTablesSchemaTransaction(this, isolationLevel, this.storeDataMgr);
        boolean success = true;
        try {
            deleteTablesTxn.execute(clr);
        }
        catch (NucleusException ne) {
            success = false;
            throw ne;
        }
        finally {
            if (success) {
                this.clearSchemaData();
            }
        }
    }

    public Writer getDdlWriter() {
        return this.ddlWriter;
    }

    public boolean getCompleteDDL() {
        return this.completeDDL;
    }

    public boolean hasWrittenDdlStatement(String stmt) {
        return this.writtenDdlStatements != null && this.writtenDdlStatements.contains(stmt);
    }

    public void addWrittenDdlStatement(String stmt) {
        if (this.writtenDdlStatements != null) {
            this.writtenDdlStatements.add(stmt);
        }
    }

    public void validateTable(TableImpl table, ClassLoaderResolver clr) {
        int isolationLevel = this.hasProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION) ? TransactionUtils.getTransactionIsolationLevelForName((String)this.getStringProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION)) : 2;
        ValidateTableSchemaTransaction validateTblTxn = new ValidateTableSchemaTransaction(this, isolationLevel, table);
        validateTblTxn.execute(clr);
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        ArrayList<AbstractClassMetaData> rootCmds = new ArrayList<AbstractClassMetaData>();
        String className = IdentityUtils.getTargetClassNameForIdentity((Object)id);
        if (className != null) {
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (IdentityUtils.isDatastoreIdentity((Object)id) && cmd.getIdentityType() != IdentityType.DATASTORE) {
                throw new NucleusUserException(Localiser.msg((String)"002004", (Object[])new Object[]{id, cmd.getFullClassName()}));
            }
            if (IdentityUtils.isSingleFieldIdentity((Object)id) && (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName()))) {
                throw new NucleusUserException(Localiser.msg((String)"002004", (Object[])new Object[]{id, cmd.getFullClassName()}));
            }
            rootCmds.add(cmd);
        } else {
            Collection pkCmds = this.getMetaDataManager().getClassMetaDataWithApplicationId(id.getClass().getName());
            if (pkCmds != null && pkCmds.size() > 0) {
                for (AbstractClassMetaData pkCmd : pkCmds) {
                    AbstractClassMetaData cmdToSwap = null;
                    boolean toAdd = true;
                    for (AbstractClassMetaData rootCmd : rootCmds) {
                        if (rootCmd.isDescendantOf(pkCmd)) {
                            cmdToSwap = rootCmd;
                            toAdd = false;
                            break;
                        }
                        if (!pkCmd.isDescendantOf(rootCmd)) continue;
                        toAdd = false;
                    }
                    if (cmdToSwap != null) {
                        rootCmds.remove(cmdToSwap);
                        rootCmds.add(pkCmd);
                        continue;
                    }
                    if (!toAdd) continue;
                    rootCmds.add(pkCmd);
                }
            }
            if (rootCmds.size() == 0) {
                return null;
            }
        }
        AbstractClassMetaData rootCmd = (AbstractClassMetaData)rootCmds.get(0);
        if (ec != null) {
            if (rootCmds.size() == 1) {
                Collection subclasses = this.getSubClassesForClass(rootCmd.getFullClassName(), true, clr);
                if (!rootCmd.isImplementationOfPersistentDefinition() && (subclasses == null || subclasses.isEmpty())) {
                    return rootCmd.getFullClassName();
                }
                int numConcrete = 0;
                String concreteClassName = null;
                Class rootCls = clr.classForName(rootCmd.getFullClassName());
                if (!Modifier.isAbstract(rootCls.getModifiers())) {
                    concreteClassName = rootCmd.getFullClassName();
                    ++numConcrete;
                }
                if (subclasses != null) {
                    for (String subclassName : subclasses) {
                        Class subcls = clr.classForName(subclassName);
                        if (Modifier.isAbstract(subcls.getModifiers())) continue;
                        if (concreteClassName == null) {
                            concreteClassName = subclassName;
                        }
                        ++numConcrete;
                    }
                }
                if (numConcrete == 1) {
                    return concreteClassName;
                }
                if (rootCmd.hasDiscriminatorStrategy()) {
                    if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                        NucleusLogger.PERSISTENCE.debug((Object)("Performing query using discriminator on " + rootCmd.getFullClassName() + " and its subclasses to find the class of " + id));
                    }
                    return RDBMSStoreHelper.getClassNameForIdUsingDiscriminator(this, ec, id, rootCmd);
                }
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)("Performing query using UNION on " + rootCmd.getFullClassName() + " and its subclasses to find the class of " + id));
                }
                return RDBMSStoreHelper.getClassNameForIdUsingUnion(this, ec, id, rootCmds);
            }
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuilder str = new StringBuilder();
                Iterator rootCmdIter = rootCmds.iterator();
                while (rootCmdIter.hasNext()) {
                    AbstractClassMetaData cmd = (AbstractClassMetaData)rootCmdIter.next();
                    str.append(cmd.getFullClassName());
                    if (!rootCmdIter.hasNext()) continue;
                    str.append(",");
                }
                NucleusLogger.PERSISTENCE.debug((Object)("Performing query using UNION on " + str.toString() + " and their subclasses to find the class of " + id));
            }
            return RDBMSStoreHelper.getClassNameForIdUsingUnion(this, ec, id, rootCmds);
        }
        if (rootCmds.size() > 1) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)("Id \"" + id + "\" has been determined to be the id of class " + rootCmd.getFullClassName() + " : this is the first of " + rootCmds.size() + " possible, but unable to determine further"));
            }
            return rootCmd.getFullClassName();
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)("Id \"" + id + "\" has been determined to be the id of class " + rootCmd.getFullClassName() + " : unable to determine if actually of a subclass"));
        }
        return rootCmd.getFullClassName();
    }

    public Object getResultValueAtPosition(ResultSet rs, JavaTypeMapping mapping, int position) {
        try {
            return rs.getObject(position);
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException(sqle.getMessage(), (Throwable)sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getNextValueForValueGenerator(ValueGenerator generator, final ExecutionContext ec) {
        Object value = null;
        ValueGenerator valueGenerator = generator;
        synchronized (valueGenerator) {
            if (generator instanceof AbstractConnectedGenerator) {
                AbstractConnectedGenerator.ConnectionPreference connPref = ((AbstractConnectedGenerator)generator).getConnectionPreference();
                final boolean newConnection = connPref == AbstractConnectedGenerator.ConnectionPreference.NONE ? !this.getStringProperty("datanucleus.valuegeneration.transactionattribute").equalsIgnoreCase("EXISTING") : connPref == AbstractConnectedGenerator.ConnectionPreference.NEW;
                ValueGenerationConnectionProvider connProvider = new ValueGenerationConnectionProvider(){
                    ManagedConnection mconn;

                    public ManagedConnection retrieveConnection() {
                        this.mconn = newConnection ? RDBMSStoreManager.this.connectionMgr.getConnection(TransactionUtils.getTransactionIsolationLevelForName((String)RDBMSStoreManager.this.getStringProperty("datanucleus.valuegeneration.transactionisolation"))) : RDBMSStoreManager.this.connectionMgr.getConnection(ec);
                        return this.mconn;
                    }

                    public void releaseConnection() {
                        try {
                            this.mconn.release();
                            this.mconn = null;
                        }
                        catch (NucleusException e) {
                            String msg = Localiser.msg((String)"050025", (Object[])new Object[]{e});
                            NucleusLogger.VALUEGENERATION.error((Object)msg);
                            throw new NucleusDataStoreException(msg, (Throwable)e);
                        }
                    }
                };
                ((AbstractConnectedGenerator)generator).setConnectionProvider(connProvider);
            }
            value = generator.next();
        }
        return value;
    }

    protected Properties getPropertiesForValueGenerator(AbstractClassMetaData cmd, int absoluteFieldNumber, ClassLoaderResolver clr, SequenceMetaData seqmd, TableGeneratorMetaData tablegenmd) {
        Properties properties = new Properties();
        properties.setProperty("class-name", cmd.getFullClassName());
        properties.setProperty("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
        if (cmd.getCatalog() != null) {
            properties.setProperty("catalog-name", cmd.getCatalog());
        } else if (!StringUtils.isWhitespace((String)this.catalogName)) {
            properties.setProperty("catalog-name", this.catalogName);
        }
        if (cmd.getSchema() != null) {
            properties.setProperty("schema-name", cmd.getSchema());
        } else if (!StringUtils.isWhitespace((String)this.schemaName)) {
            properties.setProperty("schema-name", this.schemaName);
        }
        AbstractMemberMetaData mmd = null;
        ValueGenerationStrategy strategy = null;
        String sequence = null;
        Map extensions = null;
        if (absoluteFieldNumber >= 0) {
            mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            properties.setProperty("field-name", mmd.getFullFieldName());
            strategy = mmd.getValueStrategy();
            if (strategy.equals((Object)ValueGenerationStrategy.NATIVE)) {
                strategy = ValueGenerationStrategy.getIdentityStrategy((String)this.getValueGenerationStrategyForNative(mmd));
            }
            if ((sequence = mmd.getSequence()) != null) {
                properties.setProperty("sequence-name", sequence);
            }
            if ((extensions = mmd.getExtensions()) != null && extensions.size() > 0) {
                properties.putAll((Map<?, ?>)extensions);
            }
        } else {
            DatastoreIdentityMetaData idmd = cmd.getBaseDatastoreIdentityMetaData();
            strategy = idmd.getValueStrategy();
            if (strategy.equals((Object)ValueGenerationStrategy.NATIVE)) {
                strategy = ValueGenerationStrategy.getIdentityStrategy((String)this.getValueGenerationStrategyForNative(cmd));
            }
            if ((sequence = idmd.getSequence()) != null) {
                properties.setProperty("sequence-name", sequence);
            }
            if ((extensions = idmd.getExtensions()) != null && extensions.size() > 0) {
                properties.putAll((Map<?, ?>)extensions);
            }
        }
        if (strategy != ValueGenerationStrategy.INCREMENT || tablegenmd == null) {
            DatastoreClass tbl = this.getDatastoreClass(cmd.getBaseAbstractClassMetaData().getFullClassName(), clr);
            if (tbl == null) {
                tbl = this.getTableForStrategy(cmd, absoluteFieldNumber, clr);
            }
            JavaTypeMapping m = null;
            if (mmd != null) {
                m = tbl.getMemberMapping(mmd);
                if (m == null) {
                    tbl = this.getTableForStrategy(cmd, absoluteFieldNumber, clr);
                    m = tbl.getMemberMapping(mmd);
                }
            } else {
                m = tbl.getIdMapping();
            }
            StringBuilder columnsName = new StringBuilder();
            for (int i = 0; i < m.getNumberOfColumnMappings(); ++i) {
                if (i > 0) {
                    columnsName.append(",");
                }
                columnsName.append(m.getColumnMapping(i).getColumn().getIdentifier().toString());
            }
            properties.setProperty("table-name", tbl.getIdentifier().toString());
            properties.setProperty("column-name", columnsName.toString());
        }
        if (strategy == ValueGenerationStrategy.INCREMENT) {
            this.addValueGenerationPropertiesForIncrement(properties, tablegenmd);
        } else if (strategy == ValueGenerationStrategy.SEQUENCE) {
            this.addValueGenerationPropertiesForSequence(properties, seqmd);
        }
        return properties;
    }

    private DatastoreClass getTableForStrategy(AbstractClassMetaData cmd, int fieldNumber, ClassLoaderResolver clr) {
        DatastoreClass t = this.getDatastoreClass(cmd.getFullClassName(), clr);
        if (t == null && cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            throw new NucleusUserException(Localiser.msg((String)"032013", (Object[])new Object[]{cmd.getFullClassName()}));
        }
        if (t == null) {
            throw new NucleusUserException("Attempt to find table for class=" + cmd.getFullClassName() + " but no table found! Check the metadata");
        }
        if (fieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            t = t.getBaseDatastoreClassWithMember(mmd);
        } else {
            boolean hasSuperclass = true;
            while (hasSuperclass) {
                DatastoreClass supert = t.getSuperDatastoreClass();
                if (supert != null) {
                    t = supert;
                    continue;
                }
                hasSuperclass = false;
            }
        }
        return t;
    }

    public boolean supportsValueGenerationStrategy(String strategy) {
        if (strategy.equalsIgnoreCase("IDENTITY") || super.supportsValueGenerationStrategy(strategy)) {
            if (strategy.equalsIgnoreCase("IDENTITY") && !this.dba.supportsOption("IdentityColumns")) {
                return false;
            }
            if (strategy.equalsIgnoreCase("SEQUENCE") && !this.dba.supportsOption("Sequences")) {
                return false;
            }
            if (strategy.equalsIgnoreCase("uuid-string")) {
                return this.dba.supportsOption("ValueGeneratorUUIDString");
            }
            return true;
        }
        return false;
    }

    public String getValueGenerationStrategyForNative(AbstractClassMetaData cmd) {
        if (this.getBooleanProperty(RDBMSPropertyNames.PROPERTY_RDBMS_LEGACY_NATIVE_VALUE_STRATEGY)) {
            String sequence = cmd.getDatastoreIdentityMetaData().getSequence();
            if (this.dba.supportsOption("Sequences") && sequence != null) {
                return ValueGenerationStrategy.SEQUENCE.toString();
            }
            return ValueGenerationStrategy.INCREMENT.toString();
        }
        return super.getValueGenerationStrategyForNative(cmd);
    }

    public String getValueGenerationStrategyForNative(AbstractMemberMetaData mmd) {
        if (this.getBooleanProperty(RDBMSPropertyNames.PROPERTY_RDBMS_LEGACY_NATIVE_VALUE_STRATEGY)) {
            String sequence = mmd.getSequence();
            if (this.dba.supportsOption("Sequences") && sequence != null) {
                return ValueGenerationStrategy.SEQUENCE.toString();
            }
            return ValueGenerationStrategy.INCREMENT.toString();
        }
        return super.getValueGenerationStrategyForNative(mmd);
    }

    public SQLTypeInfo getSQLTypeInfoForJDBCType(int jdbcType) throws UnsupportedDataTypeException {
        return this.getSQLTypeInfoForJDBCType(jdbcType, "DEFAULT");
    }

    public SQLTypeInfo getSQLTypeInfoForJDBCType(int jdbcType, String sqlType) throws UnsupportedDataTypeException {
        RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
        JDBCTypeInfo jdbcTypeInfo = (JDBCTypeInfo)typesInfo.getChild("" + jdbcType);
        if (jdbcTypeInfo.getNumberOfChildren() == 0) {
            throw new UnsupportedDataTypeException(Localiser.msg((String)"051005", (Object[])new Object[]{this.dba.getNameForJDBCType(jdbcType)}));
        }
        SQLTypeInfo sqlTypeInfo = (SQLTypeInfo)jdbcTypeInfo.getChild(sqlType != null ? sqlType : "DEFAULT");
        if (sqlTypeInfo == null && sqlType != null && (sqlTypeInfo = (SQLTypeInfo)jdbcTypeInfo.getChild(sqlType.toUpperCase())) == null && (sqlTypeInfo = (SQLTypeInfo)jdbcTypeInfo.getChild(sqlType.toLowerCase())) == null) {
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Attempt to find JDBC driver 'typeInfo' for jdbc-type=" + this.dba.getNameForJDBCType(jdbcType) + " but sql-type=" + sqlType + " is not found. Using default sql-type for this jdbc-type."));
            sqlTypeInfo = (SQLTypeInfo)jdbcTypeInfo.getChild("DEFAULT");
        }
        return sqlTypeInfo;
    }

    public RDBMSColumnInfo getColumnInfoForColumnName(Table table, Connection conn, DatastoreIdentifier column) throws SQLException {
        return (RDBMSColumnInfo)this.schemaHandler.getSchemaData((Object)conn, "column", new Object[]{table, column.getName()});
    }

    public List<StoreSchemaData> getColumnInfoForTable(Table table, Connection conn) throws SQLException {
        RDBMSTableInfo tableInfo = (RDBMSTableInfo)this.schemaHandler.getSchemaData((Object)conn, "columns", new Object[]{table});
        if (tableInfo == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<StoreSchemaData> cols = new ArrayList<StoreSchemaData>(tableInfo.getNumberOfChildren());
        cols.addAll(tableInfo.getChildren());
        return cols;
    }

    public void invalidateColumnInfoForTable(Table table) {
        RDBMSSchemaInfo schemaInfo = (RDBMSSchemaInfo)this.schemaHandler.getSchemaData(null, "tables", null);
        if (schemaInfo != null && schemaInfo.getNumberOfChildren() > 0) {
            schemaInfo.getChildren().remove(table.getIdentifier().getFullyQualifiedName(true));
        }
    }

    public Collection<Table> getManagedTables(String catalog, String schema) {
        if (this.storeDataMgr == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Table> tables = new HashSet<Table>();
        for (StoreData sd : this.storeDataMgr.getManagedStoreData()) {
            if (sd.getTable() == null) continue;
            DatastoreIdentifier identifier = ((Table)sd.getTable()).getIdentifier();
            boolean catalogMatches = true;
            boolean schemaMatches = true;
            if (catalog != null && identifier.getCatalogName() != null && !catalog.equals(identifier.getCatalogName())) {
                catalogMatches = false;
            }
            if (schema != null && identifier.getSchemaName() != null && !schema.equals(identifier.getSchemaName())) {
                schemaMatches = false;
            }
            if (!catalogMatches || !schemaMatches) continue;
            tables.add((Table)sd.getTable());
        }
        return tables;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolveIdentifierMacro(MacroString.IdentifierMacro im, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        DatastoreClass ct = this.getDatastoreClass(im.className, clr);
        if (im.fieldName == null) {
            im.value = ct.getIdentifier().toString();
            return;
        }
        if (im.fieldName.equals("this")) {
            if (!(ct instanceof ClassTable)) {
                throw new NucleusUserException(Localiser.msg((String)"050034", (Object[])new Object[]{im.className}));
            }
            if (im.subfieldName != null) {
                throw new NucleusUserException(Localiser.msg((String)"050035", (Object[])new Object[]{im.className, im.fieldName, im.subfieldName}));
            }
            m = ct.getIdMapping();
        } else {
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(im.className, clr);
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(im.fieldName);
            m = ct.getMemberMapping(mmd);
            Table t = this.getTable(mmd);
            if (im.subfieldName == null) {
                if (t != null) {
                    im.value = t.getIdentifier().toString();
                    return;
                }
            } else if (t instanceof CollectionTable) {
                CollectionTable collTable = (CollectionTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = collTable.getOwnerMapping();
                } else if (im.subfieldName.equals("element")) {
                    m = collTable.getElementMapping();
                } else {
                    if (!im.subfieldName.equals("index")) throw new NucleusUserException(Localiser.msg((String)"050036", (Object[])new Object[]{im.subfieldName, im}));
                    m = collTable.getOrderMapping();
                }
            } else {
                if (!(t instanceof MapTable)) throw new NucleusUserException(Localiser.msg((String)"050035", (Object[])new Object[]{im.className, im.fieldName, im.subfieldName}));
                MapTable mt = (MapTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = mt.getOwnerMapping();
                } else if (im.subfieldName.equals("key")) {
                    m = mt.getKeyMapping();
                } else {
                    if (!im.subfieldName.equals("value")) throw new NucleusUserException(Localiser.msg((String)"050037", (Object[])new Object[]{im.subfieldName, im}));
                    m = mt.getValueMapping();
                }
            }
        }
        im.value = m.getColumnMapping(0).getColumn().getIdentifier().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printInformation(String category, PrintStream ps) throws Exception {
        DatastoreAdapter dba = this.getDatastoreAdapter();
        super.printInformation(category, ps);
        if (category.equals("DATASTORE")) {
            ps.println(dba.toString());
            ps.println();
            ps.println("Database TypeInfo");
            RDBMSTypesInfo typesInfo = (RDBMSTypesInfo)this.schemaHandler.getSchemaData(null, "types", null);
            if (typesInfo != null) {
                for (String jdbcTypeStr : typesInfo.getChildren().keySet()) {
                    short jdbcTypeNumber = 0;
                    try {
                        jdbcTypeNumber = Short.parseShort(jdbcTypeStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    JDBCTypeInfo jDBCTypeInfo = (JDBCTypeInfo)typesInfo.getChild(jdbcTypeStr);
                    Set sqlTypeNames = jDBCTypeInfo.getChildren().keySet();
                    StringBuilder stringBuilder = new StringBuilder();
                    String defaultSqlTypeName = null;
                    for (String sqlTypeName : sqlTypeNames) {
                        if (!sqlTypeName.equals("DEFAULT")) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append(sqlTypeName);
                            continue;
                        }
                        defaultSqlTypeName = ((SQLTypeInfo)jDBCTypeInfo.getChild(sqlTypeName)).getTypeName();
                    }
                    String typeStr = "JDBC Type=" + dba.getNameForJDBCType(jdbcTypeNumber) + " sqlTypes=" + stringBuilder + (String)(defaultSqlTypeName != null ? " (default=" + defaultSqlTypeName + ")" : "");
                    ps.println(typeStr);
                    for (String sqlTypeName : sqlTypeNames) {
                        if (sqlTypeName.equals("DEFAULT")) continue;
                        SQLTypeInfo sqlType = (SQLTypeInfo)jDBCTypeInfo.getChild(sqlTypeName);
                        ps.println(sqlType.toString("    "));
                    }
                }
            }
            ps.println("");
            ps.println("Database Keywords");
            for (String word : dba.getReservedWords()) {
                ps.println(word);
            }
            ps.println("");
        } else if (category.equals("SCHEMA")) {
            ps.println(dba.toString());
            ps.println();
            ps.println("TABLES");
            ManagedConnection mc = this.connectionMgr.getConnection(-1);
            try {
                Connection conn = (Connection)mc.getConnection();
                RDBMSSchemaInfo schemaInfo = (RDBMSSchemaInfo)this.schemaHandler.getSchemaData((Object)conn, "tables", new Object[]{this.catalogName, this.schemaName});
                if (schemaInfo != null) {
                    for (RDBMSTableInfo rDBMSTableInfo : schemaInfo.getChildren().values()) {
                        ps.println(rDBMSTableInfo);
                        for (RDBMSColumnInfo rDBMSColumnInfo : rDBMSTableInfo.getChildren()) {
                            ps.println(rDBMSColumnInfo);
                        }
                    }
                }
            }
            finally {
                if (mc != null) {
                    mc.release();
                }
            }
            ps.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(String script) {
        script = StringUtils.replaceAll((String)script, (String)"\n", (String)" ");
        script = StringUtils.replaceAll((String)script, (String)"\t", (String)" ");
        ManagedConnection mc = this.connectionMgr.getConnection(-1);
        try {
            Connection conn = (Connection)mc.getConnection();
            try (Statement stmt = conn.createStatement();){
                StringTokenizer tokeniser = new StringTokenizer(script, ";");
                while (tokeniser.hasMoreTokens()) {
                    String token = tokeniser.nextToken().trim();
                    if (StringUtils.isWhitespace((String)token)) continue;
                    NucleusLogger.DATASTORE_NATIVE.debug((Object)("Executing script statement : " + token));
                    stmt.execute(token + ";");
                }
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE_NATIVE.error((Object)"Exception executing user script", (Throwable)e);
            throw new NucleusUserException("Exception executing user script. See nested exception for details", (Throwable)e);
        }
        finally {
            mc.release();
        }
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("NonDurableId");
        set.add("Transaction.ACID");
        set.add("ORM");
        set.add("ORM.SecondaryTable");
        set.add("ORM.EmbeddedPC");
        set.add("ORM.EmbeddedCollection");
        set.add("ORM.EmbeddedMap");
        set.add("ORM.EmbeddedArray");
        set.add("ORM.ForeignKeys");
        set.add("ORM.SerialisedPC");
        set.add("ORM.SerialisedCollectionElement");
        set.add("ORM.SerialisedArrayElement");
        set.add("ORM.SerialisedMapKey");
        set.add("ORM.SerialisedMapValue");
        if (this.dba.supportsOption("TxIsolationReadCommitted")) {
            set.add("TransactionIsolationLevel.read-committed");
        }
        if (this.dba.supportsOption("TxIsolationReadUncommitted")) {
            set.add("TransactionIsolationLevel.read-uncommitted");
        }
        if (this.dba.supportsOption("TxIsolationReadRepeatableRead")) {
            set.add("TransactionIsolationLevel.repeatable-read");
        }
        if (this.dba.supportsOption("TxIsolationSerializable")) {
            set.add("TransactionIsolationLevel.serializable");
        }
        set.add("Query.Cancel");
        set.add("Datastore.Timeout");
        if (this.dba.supportsOption("DateTimeStoresMillisecs")) {
            set.add("Datastore.Time.Millisecs");
        }
        if (this.dba.supportsOption("BitwiseAndOperator")) {
            set.add("Query.JDOQL.BitwiseOperations");
        }
        set.add("Query.JPQL.BulkInsert");
        set.add("Query.JPQL.BulkUpdate");
        set.add("Query.JPQL.BulkDelete");
        set.add("Query.JDOQL.BulkUpdate");
        set.add("Query.JDOQL.BulkDelete");
        return set;
    }

    public boolean allowsBatching() {
        return this.dba.supportsOption("StatementBatching") && this.getIntProperty(RDBMSPropertyNames.PROPERTY_RDBMS_STATEMENT_BATCH_LIMIT) != 0;
    }

    public boolean usesBackedSCOWrappers() {
        return true;
    }

    public boolean useBackedSCOWrapperForMember(AbstractMemberMetaData mmd, ExecutionContext ec) {
        return !mmd.hasCollection() && !mmd.hasMap() || !mmd.hasExtension("type-converter-name");
    }

    public Calendar getCalendarForDateTimezone() {
        if (this.dateTimezoneCalendar == null) {
            String serverTimeZoneID = this.getStringProperty(PropertyNames.PROPERTY_SERVER_TIMEZONE_ID);
            TimeZone tz = serverTimeZoneID != null ? TimeZone.getTimeZone(serverTimeZoneID) : TimeZone.getDefault();
            this.dateTimezoneCalendar = new GregorianCalendar(tz);
        }
        if (this.getBooleanProperty(RDBMSPropertyNames.PROPERTY_RDBMS_CLONE_CALENDAR_FOR_DATE_TIMEZONE)) {
            return (Calendar)this.dateTimezoneCalendar.clone();
        }
        return this.dateTimezoneCalendar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table newJoinTable(Table ownerTable, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        AbstractMemberMetaData[] relatedMmds;
        if (mmd.getJoinMetaData() == null && ((relatedMmds = mmd.getRelatedMemberMetaData(clr)) == null || relatedMmds[0].getJoinMetaData() == null)) {
            Class element_class;
            if (mmd.hasCollection()) {
                element_class = clr.classForName(mmd.getCollection().getElementType());
            } else if (mmd.hasMap()) {
                MapMetaData mapmd = (MapMetaData)mmd.getContainer();
                if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getMappedBy() != null) {
                    element_class = clr.classForName(mapmd.getKeyType());
                } else {
                    if (mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) throw new NucleusUserException(Localiser.msg((String)"050050", (Object[])new Object[]{mmd.getFullFieldName()}));
                    element_class = clr.classForName(mapmd.getValueType());
                }
            } else {
                if (!mmd.hasArray()) return null;
                element_class = clr.classForName(mmd.getTypeName()).getComponentType();
            }
            if (this.getMetaDataManager().getMetaDataForClass(element_class, clr) != null) {
                return null;
            }
            if (!ClassUtils.isReferenceType(element_class)) throw new NucleusUserException(Localiser.msg((String)"050049", (Object[])new Object[]{mmd.getFullFieldName(), mmd.toString()}));
            return null;
        }
        Table joinTable = this.getTable(mmd);
        if (joinTable != null) {
            return joinTable;
        }
        if (this.classAdder == null) {
            throw new IllegalStateException(Localiser.msg((String)"050016"));
        }
        if (mmd.getType().isArray()) {
            return this.classAdder.addJoinTableForContainer(ownerTable, mmd, clr, 3);
        }
        if (Map.class.isAssignableFrom(mmd.getType())) {
            return this.classAdder.addJoinTableForContainer(ownerTable, mmd, clr, 2);
        }
        if (!Collection.class.isAssignableFrom(mmd.getType())) return this.classAdder.addJoinTableForContainer(ownerTable, mmd, clr, 4);
        return this.classAdder.addJoinTableForContainer(ownerTable, mmd, clr, 1);
    }

    public void registerTableInitialized(Table table) {
        if (this.classAdder != null) {
            this.classAdder.tablesRecentlyInitialized.add(table);
        }
    }

    public void createDatabase(String catalogName, String schemaName, Properties props) {
        this.schemaHandler.createDatabase(catalogName, schemaName, props, null);
    }

    public void deleteDatabase(String catalogName, String schemaName, Properties props) {
        this.schemaHandler.deleteDatabase(catalogName, schemaName, props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClasses(Set<String> classNames, Properties props) {
        String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
        String completeDdlProp = props != null ? props.getProperty("completeDdl") : null;
        boolean completeDdl = Boolean.valueOf(completeDdlProp);
        String autoStartProp = props != null ? props.getProperty("autoStartTable") : null;
        boolean autoStart = Boolean.valueOf(autoStartProp);
        if (classNames != null && !classNames.isEmpty()) {
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            OutputStreamWriter ddlFileWriter = null;
            try {
                if (ddlFilename != null) {
                    File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                    if (ddlFile.exists()) {
                        ddlFile.delete();
                    }
                    if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                        ddlFile.getParentFile().mkdirs();
                    }
                    ddlFile.createNewFile();
                    ddlFileWriter = new FileWriter(ddlFile);
                    SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    ddlFileWriter.write("-- ----------------------------------------------------------------\n");
                    ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                    ddlFileWriter.write("-- ----------------------------------------------------------------\n");
                    if (completeDdl) {
                        ddlFileWriter.write("-- Complete schema required for the following classes:-\n");
                    } else {
                        ddlFileWriter.write("-- Schema diff for " + this.getConnectionURL() + " and the following classes:-\n");
                    }
                    Iterator<String> classNameIter = classNames.iterator();
                    while (classNameIter.hasNext()) {
                        ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                    }
                    ddlFileWriter.write("--\n");
                }
                try {
                    String[] classNamesArr;
                    if (ddlFileWriter != null) {
                        this.ddlWriter = ddlFileWriter;
                        this.completeDDL = completeDdl;
                        this.writtenDdlStatements = new HashSet<String>();
                    }
                    if ((classNamesArr = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames.toArray(new String[classNames.size()]))).length > 0) {
                        int isolationLevel = this.hasProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION) ? TransactionUtils.getTransactionIsolationLevelForName((String)this.getStringProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION)) : this.dba.getTransactionIsolationForSchemaCreation();
                        new ClassAdder(classNamesArr, ddlFileWriter, isolationLevel).execute(clr);
                    }
                    if (autoStart) {
                        if (ddlFileWriter != null) {
                            try {
                                ddlFileWriter.write("\n");
                                ddlFileWriter.write("-- ----------------------------------------------------------------\n");
                                ddlFileWriter.write("-- Table for SchemaTable auto-starter\n");
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        new SchemaAutoStarter((StoreManager)this, clr);
                    }
                    if (ddlFileWriter != null) {
                        this.ddlWriter = null;
                        this.completeDDL = false;
                        this.writtenDdlStatements.clear();
                        this.writtenDdlStatements = null;
                    }
                    if (ddlFileWriter != null) {
                        ddlFileWriter.write("\n");
                        ddlFileWriter.write("-- ----------------------------------------------------------------\n");
                        ddlFileWriter.write("-- Sequences and SequenceTables\n");
                    }
                    this.createSchemaSequences(classNames, clr, (FileWriter)ddlFileWriter);
                }
                finally {
                    if (ddlFileWriter != null) {
                        ddlFileWriter.close();
                    }
                }
            }
            catch (IOException ioe) {
                NucleusLogger.DATASTORE_SCHEMA.error((Object)"Exception thrown writing DDL file", (Throwable)ioe);
            }
        } else {
            String msg = Localiser.msg((String)"014039");
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
            System.out.println(msg);
            throw new NucleusException(msg);
        }
    }

    protected void createSchemaSequences(Set<String> classNames, ClassLoaderResolver clr, FileWriter ddlWriter) {
        if (classNames != null && classNames.size() > 0) {
            HashSet<String> seqTablesGenerated = new HashSet<String>();
            HashSet<String> sequencesGenerated = new HashSet<String>();
            for (String className : classNames) {
                int[] valueGenMemberPositions;
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd.getDatastoreIdentityMetaData() != null && cmd.getDatastoreIdentityMetaData().getValueStrategy() != null) {
                    if (cmd.getDatastoreIdentityMetaData().getValueStrategy() == ValueGenerationStrategy.INCREMENT) {
                        this.addSequenceTableForMetaData((MetaData)cmd.getDatastoreIdentityMetaData(), clr, seqTablesGenerated);
                    } else if (cmd.getDatastoreIdentityMetaData().getValueStrategy() == ValueGenerationStrategy.SEQUENCE) {
                        String seqName = cmd.getDatastoreIdentityMetaData().getSequence();
                        if (StringUtils.isWhitespace((String)seqName)) {
                            seqName = cmd.getDatastoreIdentityMetaData().getValueGeneratorName();
                        }
                        if (!StringUtils.isWhitespace((String)seqName)) {
                            this.addSequenceForMetaData((MetaData)cmd.getDatastoreIdentityMetaData(), seqName, clr, sequencesGenerated, ddlWriter);
                        }
                    }
                }
                if ((valueGenMemberPositions = cmd.getValueGenerationMemberPositions()) == null) continue;
                for (int i = 0; i < valueGenMemberPositions.length; ++i) {
                    AbstractMemberMetaData valueGenMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(valueGenMemberPositions[i]);
                    if (valueGenMmd.getValueStrategy() == ValueGenerationStrategy.INCREMENT) {
                        this.addSequenceTableForMetaData((MetaData)valueGenMmd, clr, seqTablesGenerated);
                        continue;
                    }
                    if (valueGenMmd.getValueStrategy() != ValueGenerationStrategy.SEQUENCE) continue;
                    String seqName = valueGenMmd.getSequence();
                    if (StringUtils.isWhitespace((String)seqName)) {
                        seqName = valueGenMmd.getValueGeneratorName();
                    }
                    if (StringUtils.isWhitespace((String)seqName)) continue;
                    this.addSequenceForMetaData((MetaData)valueGenMmd, seqName, clr, sequencesGenerated, ddlWriter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSequenceTableForMetaData(MetaData md, ClassLoaderResolver clr, Set<String> seqTablesGenerated) {
        String catName = null;
        String schName = null;
        String tableName = "SEQUENCE_TABLE";
        String seqColName = "SEQUENCE_NAME";
        String nextValColName = "NEXT_VAL";
        if (md.hasExtension("sequence-catalog-name")) {
            catName = md.getValueForExtension("sequence-catalog-name");
        }
        if (md.hasExtension("sequence-schema-name")) {
            schName = md.getValueForExtension("sequence-schema-name");
        }
        if (md.hasExtension("sequence-table-name")) {
            tableName = md.getValueForExtension("sequence-table-name");
        }
        if (md.hasExtension("sequence-name-column-name")) {
            seqColName = md.getValueForExtension("sequence-name-column-name");
        }
        if (md.hasExtension("sequence-nextval-column-name")) {
            nextValColName = md.getValueForExtension("sequence-nextval-column-name");
        }
        if (!seqTablesGenerated.contains(tableName)) {
            ManagedConnection mconn = this.connectionMgr.getConnection(0);
            Connection conn = (Connection)mconn.getConnection();
            try {
                DatastoreIdentifier tableIdentifier = this.identifierFactory.newTableIdentifier(tableName);
                if (catName != null) {
                    tableIdentifier.setCatalogName(catName);
                }
                if (schName != null) {
                    tableIdentifier.setSchemaName(schName);
                }
                SequenceTable seqTable = new SequenceTable(tableIdentifier, this, seqColName, nextValColName);
                seqTable.initialize(clr);
                seqTable.exists(conn, true);
            }
            catch (Exception exception) {
            }
            finally {
                mconn.release();
            }
            seqTablesGenerated.add(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSequenceForMetaData(MetaData md, String seq, ClassLoaderResolver clr, Set<String> sequencesGenerated, FileWriter ddlWriter) {
        String seqName = seq;
        Integer min = null;
        Integer max = null;
        Integer start = null;
        Integer increment = null;
        Integer cacheSize = null;
        SequenceMetaData seqmd = this.getMetaDataManager().getMetaDataForSequence(clr, seq);
        if (seqmd != null) {
            seqName = seqmd.getDatastoreSequence();
            if (seqmd.getAllocationSize() > 0) {
                increment = seqmd.getAllocationSize();
            }
            if (seqmd.getInitialValue() >= 0) {
                start = seqmd.getInitialValue();
            }
            md = seqmd;
        }
        if (md.hasExtension("key-min-value")) {
            min = Integer.valueOf(md.getValueForExtension("key-min-value"));
        }
        if (md.hasExtension("key-max-value")) {
            max = Integer.valueOf(md.getValueForExtension("key-max-value"));
        }
        if (md.hasExtension("key-cache-size")) {
            increment = Integer.valueOf(md.getValueForExtension("key-cache-size"));
        }
        if (md.hasExtension("key-initial-value")) {
            start = Integer.valueOf(md.getValueForExtension("key-initial-value"));
        }
        if (md.hasExtension("key-database-cache-size")) {
            cacheSize = Integer.valueOf(md.getValueForExtension("key-database-cache-size"));
        }
        if (!sequencesGenerated.contains(seqName)) {
            String stmt = this.getDatastoreAdapter().getSequenceCreateStmt(seqName, min, max, start, increment, cacheSize);
            if (ddlWriter != null) {
                try {
                    ddlWriter.write(stmt + ";\n");
                }
                catch (IOException iOException) {}
            } else {
                PreparedStatement ps = null;
                ManagedConnection mconn = this.connectionMgr.getConnection(0);
                try {
                    ps = this.sqlController.getStatementForUpdate(mconn, stmt, false);
                    this.sqlController.executeStatementUpdate(null, mconn, stmt, ps, true);
                }
                catch (SQLException sQLException) {
                }
                finally {
                    try {
                        if (ps != null) {
                            this.sqlController.closeStatement(mconn, ps);
                        }
                    }
                    catch (SQLException sQLException) {}
                    mconn.release();
                }
            }
            sequencesGenerated.add(seqName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaForClasses(Set<String> classNames, Properties props) {
        if (!classNames.isEmpty()) {
            String ddlFilename = props != null ? props.getProperty("ddlFilename") : null;
            String completeDdlProp = props != null ? props.getProperty("completeDdl") : null;
            boolean completeDdl = completeDdlProp != null && completeDdlProp.equalsIgnoreCase("true");
            String autoStartProp = props != null ? props.getProperty("autoStartTable") : null;
            boolean autoStart = autoStartProp != null && autoStartProp.equalsIgnoreCase("true");
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            FileWriter ddlFileWriter = null;
            try {
                this.performingDeleteSchemaForClasses = true;
                if (ddlFilename != null) {
                    File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                    if (ddlFile.exists()) {
                        ddlFile.delete();
                    }
                    if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                        ddlFile.getParentFile().mkdirs();
                    }
                    ddlFile.createNewFile();
                    ddlFileWriter = new FileWriter(ddlFile);
                    SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    ddlFileWriter.write("------------------------------------------------------------------\n");
                    ddlFileWriter.write("-- DataNucleus SchemaTool (ran at " + fmt.format(new Date()) + ")\n");
                    ddlFileWriter.write("------------------------------------------------------------------\n");
                    ddlFileWriter.write("-- Delete schema required for the following classes:-\n");
                    Iterator<String> classNameIter = classNames.iterator();
                    while (classNameIter.hasNext()) {
                        ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                    }
                    ddlFileWriter.write("--\n");
                }
                try {
                    if (ddlFileWriter != null) {
                        this.ddlWriter = ddlFileWriter;
                        this.completeDDL = completeDdl;
                        this.writtenDdlStatements = new HashSet<String>();
                    }
                    String[] classNameArray = classNames.toArray(new String[classNames.size()]);
                    this.manageClasses(clr, classNameArray);
                    int isolationLevel = this.hasProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION) ? TransactionUtils.getTransactionIsolationLevelForName((String)this.getStringProperty(PropertyNames.PROPERTY_SCHEMA_TXN_ISOLATION)) : 2;
                    DeleteTablesSchemaTransaction deleteTablesTxn = new DeleteTablesSchemaTransaction(this, isolationLevel, this.storeDataMgr);
                    deleteTablesTxn.setWriter(this.ddlWriter);
                    boolean success = true;
                    try {
                        deleteTablesTxn.execute(clr);
                    }
                    catch (NucleusException ne) {
                        success = false;
                        throw ne;
                    }
                    finally {
                        if (success) {
                            this.clearSchemaData();
                        }
                    }
                    if (autoStart) {
                        // empty if block
                    }
                }
                finally {
                    this.performingDeleteSchemaForClasses = false;
                    if (ddlFileWriter != null) {
                        this.ddlWriter = null;
                        this.completeDDL = false;
                        this.writtenDdlStatements.clear();
                        this.writtenDdlStatements = null;
                        ddlFileWriter.close();
                    }
                }
            }
            catch (IOException iOException) {}
        } else {
            String msg = Localiser.msg((String)"014039");
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
            System.out.println(msg);
            throw new NucleusException(msg);
        }
    }

    public void validateSchemaForClasses(Set<String> classNames, Properties props) {
        if (classNames == null || classNames.isEmpty()) {
            String msg = Localiser.msg((String)"014039");
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
            System.out.println(msg);
            throw new NucleusException(msg);
        }
        this.manageClasses(this.nucleusContext.getClassLoaderResolver(null), classNames.toArray(new String[classNames.size()]));
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    }

    private class ClassAdder
    extends AbstractSchemaTransaction {
        public static final int JOIN_TABLE_COLLECTION = 1;
        public static final int JOIN_TABLE_MAP = 2;
        public static final int JOIN_TABLE_ARRAY = 3;
        public static final int JOIN_TABLE_PERSISTABLE = 4;
        private Writer ddlWriter;
        private final boolean checkExistTablesOrViews;
        private Set<RDBMSStoreData> schemaDataAdded;
        private final String[] classNames;
        private List<Table> tablesRecentlyInitialized;
        private int addClassTablesRecursionCounter;

        private ClassAdder(String[] classNames, Writer writer, int isolationLevel) {
            super(RDBMSStoreManager.this, isolationLevel);
            this.ddlWriter = null;
            this.schemaDataAdded = new HashSet<RDBMSStoreData>();
            this.tablesRecentlyInitialized = new ArrayList<Table>();
            this.addClassTablesRecursionCounter = 0;
            this.ddlWriter = writer;
            this.classNames = classNames;
            this.checkExistTablesOrViews = RDBMSStoreManager.this.getBooleanProperty(RDBMSPropertyNames.PROPERTY_RDBMS_CHECK_EXISTS_TABLES_VIEWS);
        }

        @Override
        public String toString() {
            return Localiser.msg((String)"050038", (Object[])new Object[]{RDBMSStoreManager.this.catalogName, RDBMSStoreManager.this.schemaName});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void run(ClassLoaderResolver clr) throws SQLException {
            if (this.classNames == null || this.classNames.length == 0) {
                return;
            }
            try {
                RDBMSStoreManager.this.schemaLock.writeLock().lock();
                RDBMSStoreManager.this.classAdder = this;
                try {
                    RDBMSStoreManager.this.storeDataMgr.begin();
                    boolean completed = false;
                    List tablesCreated = null;
                    List tableConstraintsCreated = null;
                    List viewsCreated = null;
                    try {
                        List autoCreateErrors = new ArrayList();
                        this.addClassTables(this.classNames, clr);
                        List<Table>[] toValidate = this.initializeClassTables(this.classNames, clr);
                        if (!RDBMSStoreManager.this.performingDeleteSchemaForClasses) {
                            List[] result;
                            if (toValidate[0] != null && toValidate[0].size() > 0) {
                                result = this.performTablesValidation(toValidate[0], clr);
                                tablesCreated = result[0];
                                tableConstraintsCreated = result[1];
                                autoCreateErrors = result[2];
                            }
                            if (toValidate[1] != null && toValidate[1].size() > 0) {
                                result = this.performViewsValidation(toValidate[1]);
                                viewsCreated = result[0];
                                autoCreateErrors.addAll(result[1]);
                            }
                            if (!autoCreateErrors.isEmpty()) {
                                for (Throwable exc : autoCreateErrors) {
                                    if (this.rdbmsMgr.getSchemaHandler().isAutoCreateWarnOnError()) {
                                        NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"050044", (Object[])new Object[]{exc}));
                                        continue;
                                    }
                                    NucleusLogger.DATASTORE.error((Object)Localiser.msg((String)"050044", (Object[])new Object[]{exc}));
                                }
                                if (!this.rdbmsMgr.getSchemaHandler().isAutoCreateWarnOnError()) {
                                    throw new NucleusDataStoreException(Localiser.msg((String)"050043"), autoCreateErrors.toArray(new Throwable[autoCreateErrors.size()]));
                                }
                            }
                        }
                        completed = true;
                    }
                    catch (SQLException sqle) {
                        String msg = Localiser.msg((String)"050044", (Object[])new Object[]{sqle});
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                        throw new NucleusDataStoreException(msg, (Throwable)sqle);
                    }
                    catch (Throwable e) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)Localiser.msg((String)"050044", (Object[])new Object[]{e}));
                        if (NucleusException.class.isAssignableFrom(e.getClass())) {
                            throw (NucleusException)e;
                        }
                        throw new NucleusException(e.toString(), e).setFatal();
                    }
                    finally {
                        if (!completed) {
                            RDBMSStoreManager.this.storeDataMgr.rollback();
                            this.rollbackSchemaCreation(viewsCreated, tableConstraintsCreated, tablesCreated);
                        } else {
                            RDBMSStoreManager.this.storeDataMgr.commit();
                        }
                        this.schemaDataAdded.clear();
                    }
                }
                finally {
                    RDBMSStoreManager.this.classAdder = null;
                }
            }
            finally {
                RDBMSStoreManager.this.schemaLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClassTables(String[] classNames, ClassLoaderResolver clr) {
            ++this.addClassTablesRecursionCounter;
            try {
                AutoStartMechanism starter = this.rdbmsMgr.getNucleusContext().getAutoStartMechanism();
                try {
                    if (starter != null && !starter.isOpen()) {
                        starter.open();
                    }
                    Iterator iter = RDBMSStoreManager.this.getMetaDataManager().getReferencedClasses(classNames, clr).iterator();
                    while (iter.hasNext()) {
                        this.addClassTable((ClassMetaData)iter.next(), clr);
                    }
                    for (RDBMSStoreData data : new HashSet<RDBMSStoreData>(this.schemaDataAdded)) {
                        AbstractClassMetaData cmd;
                        InheritanceMetaData imd;
                        if (data.getTable() != null || !data.isFCO() || (imd = (cmd = (AbstractClassMetaData)data.getMetaData()).getInheritanceMetaData()).getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
                        AbstractClassMetaData[] managingCmds = RDBMSStoreManager.this.getClassesManagingTableForClass(cmd, clr);
                        DatastoreClass superTable = null;
                        if (managingCmds == null || managingCmds.length != 1) continue;
                        RDBMSStoreData superData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        if (superData == null) {
                            this.addClassTables(new String[]{managingCmds[0].getFullClassName()}, clr);
                            superData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        }
                        if (superData == null) {
                            String msg = Localiser.msg((String)"050013", (Object[])new Object[]{cmd.getFullClassName()});
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                        superTable = (DatastoreClass)superData.getTable();
                        data.setDatastoreContainerObject(superTable);
                    }
                }
                finally {
                    if (starter != null && starter.isOpen() && this.addClassTablesRecursionCounter <= 1) {
                        starter.close();
                    }
                }
            }
            finally {
                --this.addClassTablesRecursionCounter;
            }
        }

        private void addClassTable(ClassMetaData cmd, ClassLoaderResolver clr) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return;
            }
            if (cmd.getIdentityType() == IdentityType.NONDURABLE && cmd.hasExtension(RDBMSStoreManager.METADATA_NONDURABLE_REQUIRES_TABLE) && cmd.getValueForExtension(RDBMSStoreManager.METADATA_NONDURABLE_REQUIRES_TABLE) != null && cmd.getValueForExtension(RDBMSStoreManager.METADATA_NONDURABLE_REQUIRES_TABLE).equalsIgnoreCase("false")) {
                return;
            }
            if (!RDBMSStoreManager.this.storeDataMgr.managesClass(cmd.getFullClassName())) {
                if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                    String baseClassWithMetaData = cmd.getBaseAbstractClassMetaData().getFullClassName();
                    Collection pkCmds = RDBMSStoreManager.this.getMetaDataManager().getClassMetaDataWithApplicationId(cmd.getObjectidClass());
                    if (pkCmds != null && pkCmds.size() > 0) {
                        boolean inSameTree = false;
                        String sampleClassInOtherTree = null;
                        for (AbstractClassMetaData pkCmd : pkCmds) {
                            String otherClassBaseClass = pkCmd.getBaseAbstractClassMetaData().getFullClassName();
                            if (otherClassBaseClass.equals(baseClassWithMetaData)) {
                                inSameTree = true;
                                break;
                            }
                            sampleClassInOtherTree = pkCmd.getFullClassName();
                        }
                        if (!inSameTree) {
                            String errorMsg = Localiser.msg((String)"050021", (Object[])new Object[]{cmd.getFullClassName(), cmd.getObjectidClass(), sampleClassInOtherTree});
                            NucleusLogger.DATASTORE.error((Object)errorMsg);
                            throw new NucleusUserException(errorMsg);
                        }
                    }
                }
                if (cmd.isEmbeddedOnly()) {
                    NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"032012", (Object[])new Object[]{cmd.getFullClassName()}));
                } else {
                    InheritanceMetaData imd = cmd.getInheritanceMetaData();
                    RDBMSStoreData sdNew = null;
                    if (imd.getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSStoreManager.this.registerStoreData(sdNew);
                    } else if (imd.getStrategy() == InheritanceStrategy.COMPLETE_TABLE && cmd.isAbstract()) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSStoreManager.this.registerStoreData(sdNew);
                    } else if (imd.getStrategy() == InheritanceStrategy.NEW_TABLE || imd.getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
                        DatastoreIdentifier tableName = null;
                        RDBMSStoreData tmpData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(cmd.getFullClassName());
                        tableName = tmpData != null && tmpData.getDatastoreIdentifier() != null ? tmpData.getDatastoreIdentifier() : this.rdbmsMgr.getIdentifierFactory().newTableIdentifier((AbstractClassMetaData)cmd);
                        StoreData[] existingStoreData = RDBMSStoreManager.this.getStoreDataForDatastoreContainerObject(tableName);
                        if (existingStoreData != null) {
                            String existingClass = null;
                            for (int j = 0; j < existingStoreData.length; ++j) {
                                if (existingStoreData[j].getName().equals(cmd.getFullClassName())) continue;
                                existingClass = existingStoreData[j].getName();
                                break;
                            }
                            if (existingClass != null) {
                                NucleusLogger.DATASTORE.warn((Object)Localiser.msg((String)"050015", (Object[])new Object[]{cmd.getFullClassName(), tableName.getName(), existingClass}));
                            }
                        }
                        AbstractTable t = null;
                        boolean hasViewDef = false;
                        if (RDBMSStoreManager.this.dba.getVendorID() != null) {
                            hasViewDef = cmd.hasExtension("view-definition-" + RDBMSStoreManager.this.dba.getVendorID());
                        }
                        if (!hasViewDef) {
                            hasViewDef = cmd.hasExtension("view-definition");
                        }
                        t = hasViewDef ? new ClassView(tableName, RDBMSStoreManager.this, cmd) : new ClassTable(tableName, RDBMSStoreManager.this, cmd);
                        sdNew = new RDBMSStoreData(cmd, t, true);
                        this.rdbmsMgr.registerStoreData(sdNew);
                        t.preInitialize(clr);
                    } else if (imd.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
                        AbstractClassMetaData[] managingCmds = RDBMSStoreManager.this.getClassesManagingTableForClass((AbstractClassMetaData)cmd, clr);
                        Table superTable = null;
                        if (managingCmds != null && managingCmds.length == 1) {
                            RDBMSStoreData superData = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                            if (superData != null) {
                                superTable = (Table)superData.getTable();
                            }
                            sdNew = new RDBMSStoreData(cmd, superTable, false);
                            this.rdbmsMgr.registerStoreData(sdNew);
                        } else {
                            String msg = Localiser.msg((String)"050013", (Object[])new Object[]{cmd.getFullClassName()});
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                    }
                    this.schemaDataAdded.add(sdNew);
                }
            }
        }

        private List<Table>[] initializeClassTables(String[] classNames, ClassLoaderResolver clr) {
            ArrayList<Table> tablesToValidate = new ArrayList<Table>();
            ArrayList<Table> viewsToValidate = new ArrayList<Table>();
            this.tablesRecentlyInitialized.clear();
            int numTablesInitializedInit = 0;
            int numStoreDataInit = 0;
            RDBMSStoreData[] rdbmsStoreData = RDBMSStoreManager.this.storeDataMgr.getManagedStoreData().toArray(new RDBMSStoreData[RDBMSStoreManager.this.storeDataMgr.size()]);
            do {
                numStoreDataInit = rdbmsStoreData.length;
                numTablesInitializedInit = this.tablesRecentlyInitialized.size();
                for (int i = 0; i < rdbmsStoreData.length; ++i) {
                    RDBMSStoreData currentStoreData = rdbmsStoreData[i];
                    if (!currentStoreData.hasTable()) continue;
                    Table t = (Table)currentStoreData.getTable();
                    if (t instanceof DatastoreClass) {
                        ((RDBMSPersistenceHandler)this.rdbmsMgr.getPersistenceHandler()).removeRequestsForTable((DatastoreClass)t);
                    }
                    if (!t.isInitialized()) {
                        t.initialize(clr);
                    }
                    if (currentStoreData.isTableOwner() || ((ClassTable)t).managesClass(currentStoreData.getName())) continue;
                    ((ClassTable)t).manageClass((AbstractClassMetaData)((ClassMetaData)currentStoreData.getMetaData()), clr);
                    if (tablesToValidate.contains(t)) continue;
                    tablesToValidate.add(t);
                }
                rdbmsStoreData = RDBMSStoreManager.this.storeDataMgr.getManagedStoreData().toArray(new RDBMSStoreData[RDBMSStoreManager.this.storeDataMgr.size()]);
            } while (this.tablesRecentlyInitialized.size() > numTablesInitializedInit || rdbmsStoreData.length > numStoreDataInit);
            for (int j = 0; j < this.tablesRecentlyInitialized.size(); ++j) {
                this.tablesRecentlyInitialized.get(j).postInitialize(clr);
            }
            for (Table t : this.tablesRecentlyInitialized) {
                if (t instanceof ViewImpl) {
                    viewsToValidate.add(t);
                    continue;
                }
                if (tablesToValidate.contains(t)) continue;
                tablesToValidate.add(t);
            }
            return new List[]{tablesToValidate, viewsToValidate};
        }

        private List[] performTablesValidation(List<Table> tablesToValidate, ClassLoaderResolver clr) throws SQLException {
            ArrayList<Throwable> autoCreateErrors = new ArrayList<Throwable>();
            ArrayList<TableImpl> tableConstraintsCreated = new ArrayList<TableImpl>();
            ArrayList<TableImpl> tablesCreated = new ArrayList<TableImpl>();
            if (this.ddlWriter != null) {
                ArrayList<Table> tmpTablesToValidate = new ArrayList<Table>();
                for (Table tbl : tablesToValidate) {
                    if (tmpTablesToValidate.contains(tbl)) continue;
                    tmpTablesToValidate.add(tbl);
                }
                tablesToValidate = tmpTablesToValidate;
            }
            for (TableImpl tableImpl : tablesToValidate) {
                boolean columnsValidated = false;
                boolean columnsInitialised = false;
                if (this.checkExistTablesOrViews) {
                    if (this.ddlWriter != null) {
                        try {
                            if (tableImpl instanceof ClassTable) {
                                this.ddlWriter.write("-- Table " + tableImpl.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassTable)tableImpl).getManagedClasses()) + "\n");
                            } else if (tableImpl instanceof JoinTable) {
                                this.ddlWriter.write("-- Table " + tableImpl.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)("error writing DDL into file for table " + tableImpl), (Throwable)ioe);
                        }
                    }
                    if (!tablesCreated.contains(tableImpl) && tableImpl.exists(this.getCurrentConnection(), this.rdbmsMgr.getSchemaHandler().isAutoCreateTables())) {
                        tablesCreated.add(tableImpl);
                        columnsValidated = true;
                    } else if (tableImpl.isInitializedModified() || this.rdbmsMgr.getSchemaHandler().isAutoCreateColumns()) {
                        tableImpl.validateColumns(this.getCurrentConnection(), false, this.rdbmsMgr.getSchemaHandler().isAutoCreateColumns(), autoCreateErrors);
                        columnsValidated = true;
                    }
                }
                if (this.rdbmsMgr.getSchemaHandler().isValidateTables() && !columnsValidated) {
                    tableImpl.validate(this.getCurrentConnection(), this.rdbmsMgr.getSchemaHandler().isValidateColumns(), false, autoCreateErrors);
                    columnsInitialised = this.rdbmsMgr.getSchemaHandler().isValidateColumns();
                }
                if (!columnsInitialised) {
                    String initInfo = RDBMSStoreManager.this.getStringProperty(RDBMSPropertyNames.PROPERTY_RDBMS_INIT_COLUMN_INFO).toUpperCase();
                    if (initInfo.equals("PK")) {
                        tableImpl.initializeColumnInfoForPrimaryKeyColumns(this.getCurrentConnection());
                    } else if (initInfo.equals("ALL")) {
                        tableImpl.initializeColumnInfoFromDatastore(this.getCurrentConnection());
                    }
                }
                RDBMSStoreManager.this.invalidateColumnInfoForTable(tableImpl);
            }
            for (TableImpl tableImpl : tablesToValidate) {
                if (!this.rdbmsMgr.getSchemaHandler().isValidateConstraints() && !this.rdbmsMgr.getSchemaHandler().isAutoCreateConstraints()) continue;
                if (this.ddlWriter != null) {
                    try {
                        if (tableImpl instanceof ClassTable) {
                            this.ddlWriter.write("-- Constraints for table " + tableImpl.toString() + " for class(es) " + StringUtils.objectArrayToString((Object[])((ClassTable)tableImpl).getManagedClasses()) + "\n");
                        } else {
                            this.ddlWriter.write("-- Constraints for table " + tableImpl.toString() + "\n");
                        }
                    }
                    catch (IOException ioe) {
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)("error writing DDL into file for table " + tableImpl), (Throwable)ioe);
                    }
                }
                if (tablesCreated.contains(tableImpl) && !this.hasDuplicateTablesFromList(tablesToValidate)) {
                    if (tableImpl.createConstraints(this.getCurrentConnection(), autoCreateErrors, clr)) {
                        tableConstraintsCreated.add(tableImpl);
                    }
                } else if (tableImpl.validateConstraints(this.getCurrentConnection(), this.rdbmsMgr.getSchemaHandler().isAutoCreateConstraints(), autoCreateErrors, clr)) {
                    tableConstraintsCreated.add(tableImpl);
                }
                if (this.ddlWriter == null) continue;
                try {
                    this.ddlWriter.write("\n");
                }
                catch (IOException ioe) {
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)("error writing DDL into file for table " + tableImpl), (Throwable)ioe);
                }
            }
            return new List[]{tablesCreated, tableConstraintsCreated, autoCreateErrors};
        }

        private boolean hasDuplicateTablesFromList(List<Table> newTables) {
            HashMap<String, Table> map = new HashMap<String, Table>();
            for (int i = 0; i < newTables.size(); ++i) {
                Table t1 = newTables.get(i);
                if (map.containsKey(t1.getIdentifier().getName())) {
                    return true;
                }
                map.put(t1.getIdentifier().getName(), t1);
            }
            return false;
        }

        private List[] performViewsValidation(List<Table> viewsToValidate) throws SQLException {
            ArrayList<ViewImpl> viewsCreated = new ArrayList<ViewImpl>();
            ArrayList<Throwable> autoCreateErrors = new ArrayList<Throwable>();
            for (ViewImpl viewImpl : viewsToValidate) {
                if (this.checkExistTablesOrViews && viewImpl.exists(this.getCurrentConnection(), this.rdbmsMgr.getSchemaHandler().isAutoCreateTables())) {
                    viewsCreated.add(viewImpl);
                }
                if (this.rdbmsMgr.getSchemaHandler().isValidateTables()) {
                    viewImpl.validate(this.getCurrentConnection(), true, false, autoCreateErrors);
                }
                RDBMSStoreManager.this.invalidateColumnInfoForTable(viewImpl);
            }
            return new List[]{viewsCreated, autoCreateErrors};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rollbackSchemaCreation(List<Table> viewsCreated, List<Table> tableConstraintsCreated, List<Table> tablesCreated) {
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"050040"));
            }
            try {
                ListIterator<Table> li;
                if (viewsCreated != null) {
                    li = viewsCreated.listIterator(viewsCreated.size());
                    while (li.hasPrevious()) {
                        ((ViewImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
                if (tableConstraintsCreated != null) {
                    li = tableConstraintsCreated.listIterator(tableConstraintsCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).dropConstraints(this.getCurrentConnection());
                    }
                }
                if (tablesCreated != null) {
                    li = tablesCreated.listIterator(tablesCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)Localiser.msg((String)"050041", (Object[])new Object[]{e}));
            }
            AutoStartMechanism starter = this.rdbmsMgr.getNucleusContext().getAutoStartMechanism();
            if (starter != null) {
                try {
                    if (!starter.isOpen()) {
                        starter.open();
                    }
                    for (RDBMSStoreData sd : this.schemaDataAdded) {
                        starter.deleteClass(sd.getName());
                    }
                }
                finally {
                    if (starter.isOpen()) {
                        starter.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Table addJoinTableForContainer(Table ownerTable, AbstractMemberMetaData mmd, ClassLoaderResolver clr, int type) {
            DatastoreIdentifier tableName;
            RDBMSStoreData sd = (RDBMSStoreData)RDBMSStoreManager.this.storeDataMgr.get(mmd);
            tableName = sd != null && sd.getDatastoreIdentifier() != null ? (tableName = sd.getDatastoreIdentifier()) : RDBMSStoreManager.this.identifierFactory.newTableIdentifier(mmd);
            JoinTable join = null;
            if (type == 1) {
                join = new CollectionTable(ownerTable, tableName, mmd, RDBMSStoreManager.this);
            } else if (type == 2) {
                join = new MapTable(ownerTable, tableName, mmd, RDBMSStoreManager.this);
            } else if (type == 3) {
                join = new ArrayTable(ownerTable, tableName, mmd, RDBMSStoreManager.this);
            } else if (type == 4) {
                join = new PersistableJoinTable(ownerTable, tableName, mmd, RDBMSStoreManager.this);
            }
            AutoStartMechanism starter = this.rdbmsMgr.getNucleusContext().getAutoStartMechanism();
            try {
                if (starter != null && !starter.isOpen()) {
                    starter.open();
                }
                RDBMSStoreData data = new RDBMSStoreData(mmd, join);
                this.schemaDataAdded.add(data);
                this.rdbmsMgr.registerStoreData(data);
            }
            finally {
                if (starter != null && starter.isOpen()) {
                    starter.close();
                }
            }
            return join;
        }
    }
}

