/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.DatastoreIdMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractClassTable
extends TableImpl {
    protected Map<AbstractMemberMetaData, JavaTypeMapping> memberMappingsMap = new LinkedHashMap<AbstractMemberMetaData, JavaTypeMapping>();
    protected JavaTypeMapping[] pkMappings;
    protected JavaTypeMapping idMapping;
    protected JavaTypeMapping datastoreIdMapping;
    protected JavaTypeMapping versionMapping;
    protected JavaTypeMapping discriminatorMapping;
    protected JavaTypeMapping multitenancyMapping;
    protected JavaTypeMapping softDeleteMapping;
    protected JavaTypeMapping createUserMapping;
    protected JavaTypeMapping updateUserMapping;
    protected JavaTypeMapping createTimestampMapping;
    protected JavaTypeMapping updateTimestampMapping;
    protected VersionMetaData versionMetaData;
    protected DiscriminatorMetaData discriminatorMetaData;
    protected int highestMemberNumber = 0;

    public AbstractClassTable(DatastoreIdentifier tableName, RDBMSStoreManager storeMgr) {
        super(tableName, storeMgr);
    }

    public Table getPrimaryTable() {
        return this;
    }

    protected abstract void initializePK(ClassLoaderResolver var1);

    public boolean managesMember(String memberName) {
        if (memberName == null) {
            return false;
        }
        return this.getMappingForMemberName(memberName) != null;
    }

    protected JavaTypeMapping getMappingForMemberName(String memberName) {
        for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> memberMapEntry : this.memberMappingsMap.entrySet()) {
            AbstractMemberMetaData mmd = memberMapEntry.getKey();
            if (!mmd.getFullFieldName().equals(memberName)) continue;
            return memberMapEntry.getValue();
        }
        return null;
    }

    public boolean managesMapping(JavaTypeMapping mapping) {
        if (this.memberMappingsMap.values().contains(mapping)) {
            return true;
        }
        if (mapping == this.discriminatorMapping) {
            return true;
        }
        if (mapping == this.versionMapping) {
            return true;
        }
        if (mapping == this.datastoreIdMapping) {
            return true;
        }
        if (mapping == this.idMapping) {
            return true;
        }
        return mapping == this.multitenancyMapping;
    }

    final void addApplicationIdUsingClassTableId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        ColumnMetaData[] userdefinedCols = null;
        int nextUserdefinedCol = 0;
        if (columnContainer != null) {
            userdefinedCols = columnContainer.getColumnMetaData();
        }
        this.pkMappings = new JavaTypeMapping[cmd.getPKMemberPositions().length];
        for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
            JavaTypeMapping mapping = refTable.getMemberMapping(mmd);
            if (mapping == null) {
                throw new NucleusUserException("Cannot find mapping for field " + mmd.getFullFieldName() + " in table " + refTable.toString() + " " + StringUtils.collectionToString((Collection)refTable.getColumns()));
            }
            JavaTypeMapping masterMapping = this.storeMgr.getMappingManager().getMapping(clr.classForName(mapping.getType()));
            masterMapping.setMemberMetaData(mmd);
            masterMapping.setTable(this);
            this.pkMappings[i] = masterMapping;
            for (int j = 0; j < mapping.getNumberOfColumnMappings(); ++j) {
                JavaTypeMapping m = masterMapping;
                Column refColumn = mapping.getColumnMapping(j).getColumn();
                if (mapping instanceof PersistableMapping) {
                    m = this.storeMgr.getMappingManager().getMapping(clr.classForName(refColumn.getJavaTypeMapping().getType()));
                    ((PersistableMapping)masterMapping).addJavaTypeMapping(m);
                }
                ColumnMetaData userdefinedColumn = null;
                if (userdefinedCols != null) {
                    for (int k = 0; k < userdefinedCols.length; ++k) {
                        if (!refColumn.getIdentifier().toString().equals(userdefinedCols[k].getTarget())) continue;
                        userdefinedColumn = userdefinedCols[k];
                        break;
                    }
                    if (userdefinedColumn == null && nextUserdefinedCol < userdefinedCols.length) {
                        userdefinedColumn = userdefinedCols[nextUserdefinedCol++];
                    }
                }
                Column idColumn = null;
                idColumn = userdefinedColumn != null ? this.addColumn(refColumn.getStoredJavaType(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, userdefinedColumn.getName()), m, refColumn.getColumnMetaData()) : this.addColumn(refColumn.getStoredJavaType(), refColumn.getIdentifier(), m, refColumn.getColumnMetaData());
                if (mapping.getColumnMapping(j).getColumn().getColumnMetaData() != null) {
                    refColumn.copyConfigurationTo(idColumn);
                }
                idColumn.setPrimaryKey();
                this.getStoreManager().getMappingManager().createColumnMapping(m, idColumn, refColumn.getJavaTypeMapping().getType());
            }
            int absoluteFieldNumber = mmd.getAbsoluteFieldNumber();
            if (absoluteFieldNumber <= this.highestMemberNumber) continue;
            this.highestMemberNumber = absoluteFieldNumber;
        }
    }

    void addDatastoreId(ColumnMetaData columnMetaData, DatastoreClass refTable, AbstractClassMetaData cmd) {
        this.datastoreIdMapping = new DatastoreIdMapping();
        this.datastoreIdMapping.setTable(this);
        this.datastoreIdMapping.initialize(this.storeMgr, cmd.getFullClassName());
        ColumnMetaData colmd = null;
        colmd = columnMetaData == null ? new ColumnMetaData() : columnMetaData;
        if (colmd.getName() == null) {
            if (refTable != null) {
                colmd.setName(this.storeMgr.getIdentifierFactory().newColumnIdentifier(refTable.getIdentifier().getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(DatastoreId.class), FieldRole.ROLE_OWNER, false).getName());
            } else {
                colmd.setName(this.storeMgr.getIdentifierFactory().newColumnIdentifier(this.identifier.getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(DatastoreId.class), FieldRole.ROLE_NONE, false).getName());
            }
        }
        Column idColumn = this.addColumn(DatastoreId.class.getName(), this.storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.COLUMN, colmd.getName()), this.datastoreIdMapping, colmd);
        idColumn.setPrimaryKey();
        String strategyName = cmd.getIdentityMetaData().getValueStrategy().toString();
        if (cmd.getIdentityMetaData().getValueStrategy().equals((Object)ValueGenerationStrategy.CUSTOM)) {
            strategyName = cmd.getIdentityMetaData().getValueStrategy().getCustomName();
        }
        if (strategyName != null && ValueGenerationStrategy.NATIVE.toString().equals(strategyName)) {
            strategyName = this.storeMgr.getValueGenerationStrategyForNative(cmd, -1);
        }
        Class valueGeneratedType = Long.class;
        if (strategyName != null && ValueGenerationStrategy.IDENTITY.toString().equals(strategyName)) {
            if ((valueGeneratedType = this.dba.getIdentityJavaTypeForType(valueGeneratedType)) != Long.class) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Class " + cmd.getFullClassName() + " uses IDENTITY strategy and rather than using BIGINT  for the column type, using " + valueGeneratedType.getName() + " since the datastore requires that"));
            }
        } else {
            valueGeneratedType = this.storeMgr.getValueGenerationManager().getTypeForValueGeneratorForMember(strategyName, this.storeMgr.getValueGenerationManager().getMemberKey(cmd, -1));
        }
        this.storeMgr.getMappingManager().createColumnMapping(this.datastoreIdMapping, idColumn, valueGeneratedType.getName());
        this.logMapping("DATASTORE_ID", this.datastoreIdMapping);
        if (this.isObjectIdDatastoreAttributed() && this instanceof DatastoreClass && ((DatastoreClass)((Object)this)).isBaseDatastoreClass()) {
            idColumn.setIdentity(true);
        }
        if (idColumn.isIdentity() && !this.dba.supportsOption("IdentityColumns")) {
            throw new NucleusException(Localiser.msg((String)"057020", (Object[])new Object[]{cmd.getFullClassName(), "datastore-identity"})).setFatal();
        }
    }

    protected void addMemberMapping(JavaTypeMapping fieldMapping) {
        AbstractMemberMetaData mmd = fieldMapping.getMemberMetaData();
        this.logMapping(mmd.getFullFieldName(), fieldMapping);
        this.memberMappingsMap.put(mmd, fieldMapping);
        int absoluteFieldNumber = mmd.getAbsoluteFieldNumber();
        if (absoluteFieldNumber > this.highestMemberNumber) {
            this.highestMemberNumber = absoluteFieldNumber;
        }
    }

    public abstract IdentityType getIdentityType();

    public abstract boolean isObjectIdDatastoreAttributed();

    @Override
    public Column getSurrogateColumn(SurrogateColumnType colType) {
        this.assertIsInitialized();
        if (colType == SurrogateColumnType.DATASTORE_ID) {
            return this.datastoreIdMapping != null ? this.datastoreIdMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.DISCRIMINATOR) {
            return this.discriminatorMapping != null ? this.discriminatorMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.MULTITENANCY) {
            return this.multitenancyMapping != null ? this.multitenancyMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.VERSION) {
            return this.versionMapping != null ? this.versionMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.SOFTDELETE) {
            return this.softDeleteMapping != null ? this.softDeleteMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.CREATE_USER) {
            return this.createUserMapping != null ? this.createUserMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.CREATE_TIMESTAMP) {
            return this.createTimestampMapping != null ? this.createTimestampMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.UPDATE_USER) {
            return this.updateUserMapping != null ? this.updateUserMapping.getColumnMapping(0).getColumn() : null;
        }
        if (colType == SurrogateColumnType.UPDATE_TIMESTAMP) {
            return this.updateTimestampMapping != null ? this.updateTimestampMapping.getColumnMapping(0).getColumn() : null;
        }
        return null;
    }

    @Override
    public JavaTypeMapping getSurrogateMapping(SurrogateColumnType colType, boolean allowSuperclasses) {
        this.assertIsInitialized();
        if (colType == SurrogateColumnType.DISCRIMINATOR) {
            return this.discriminatorMapping;
        }
        if (colType == SurrogateColumnType.MULTITENANCY) {
            return this.multitenancyMapping;
        }
        if (colType == SurrogateColumnType.VERSION) {
            return this.versionMapping;
        }
        if (colType == SurrogateColumnType.DATASTORE_ID) {
            return this.datastoreIdMapping;
        }
        if (colType == SurrogateColumnType.SOFTDELETE) {
            return this.softDeleteMapping;
        }
        if (colType == SurrogateColumnType.CREATE_USER) {
            return this.createUserMapping;
        }
        if (colType == SurrogateColumnType.CREATE_TIMESTAMP) {
            return this.createTimestampMapping;
        }
        if (colType == SurrogateColumnType.UPDATE_USER) {
            return this.updateUserMapping;
        }
        if (colType == SurrogateColumnType.UPDATE_TIMESTAMP) {
            return this.updateTimestampMapping;
        }
        return super.getSurrogateMapping(colType, allowSuperclasses);
    }

    public abstract void providePrimaryKeyMappings(MappingConsumer var1);

    public final void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        for (Map.Entry<AbstractMemberMetaData, JavaTypeMapping> memberMapEntry : this.memberMappingsMap.entrySet()) {
            AbstractMemberMetaData mmd = memberMapEntry.getKey();
            JavaTypeMapping memberMapping = memberMapEntry.getValue();
            if (memberMapping == null || mmd.isPrimaryKey()) continue;
            consumer.consumeMapping(memberMapping, mmd);
        }
    }

    public void provideMappingsForMembers(MappingConsumer consumer, AbstractMemberMetaData[] mmds, boolean includeSecondaryTables) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        for (int i = 0; i < mmds.length; ++i) {
            JavaTypeMapping fieldMapping = this.memberMappingsMap.get(mmds[i]);
            if (fieldMapping == null || mmds[i].isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, mmds[i]);
        }
    }

    public final void provideSurrogateMapping(SurrogateColumnType colType, MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestMemberNumber + 1);
        if (colType == SurrogateColumnType.DATASTORE_ID) {
            if (this.getIdentityType() == IdentityType.DATASTORE) {
                consumer.consumeMapping(this.datastoreIdMapping, MappingType.DATASTORE_ID);
            }
        } else if (colType == SurrogateColumnType.DISCRIMINATOR) {
            JavaTypeMapping discrimMapping = this.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
            if (discrimMapping != null) {
                consumer.consumeMapping(discrimMapping, MappingType.DISCRIMINATOR);
            }
        } else if (colType == SurrogateColumnType.MULTITENANCY) {
            if (this.multitenancyMapping != null) {
                consumer.consumeMapping(this.multitenancyMapping, MappingType.MULTITENANCY);
            }
        } else if (colType == SurrogateColumnType.VERSION) {
            JavaTypeMapping versionMapping = this.getSurrogateMapping(SurrogateColumnType.VERSION, false);
            if (versionMapping != null) {
                consumer.consumeMapping(versionMapping, MappingType.VERSION);
            }
        } else if (colType == SurrogateColumnType.SOFTDELETE) {
            if (this.softDeleteMapping != null) {
                consumer.consumeMapping(this.softDeleteMapping, MappingType.SOFTDELETE);
            }
        } else if (colType == SurrogateColumnType.CREATE_USER) {
            if (this.createUserMapping != null) {
                consumer.consumeMapping(this.createUserMapping, MappingType.CREATEUSER);
            }
        } else if (colType == SurrogateColumnType.CREATE_TIMESTAMP) {
            if (this.createTimestampMapping != null) {
                consumer.consumeMapping(this.createTimestampMapping, MappingType.CREATETIMESTAMP);
            }
        } else if (colType == SurrogateColumnType.UPDATE_USER) {
            if (this.updateUserMapping != null) {
                consumer.consumeMapping(this.updateUserMapping, MappingType.UPDATEUSER);
            }
        } else if (colType == SurrogateColumnType.UPDATE_TIMESTAMP) {
            if (this.updateTimestampMapping != null) {
                consumer.consumeMapping(this.updateTimestampMapping, MappingType.UPDATETIMESTAMP);
            }
        } else {
            NucleusLogger.PERSISTENCE.warn((Object)("Dont currently support surrogate field of type " + colType + ". Ignored"));
        }
    }
}

