/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import java.util.List;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;

public class CharacterExpression
extends SQLExpression {
    public CharacterExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public CharacterExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List args) {
        super(stmt, mapping, functionName, args, null);
    }

    public CharacterExpression(SQLStatement stmt, JavaTypeMapping mapping, String functionName, List args, List types) {
        super(stmt, mapping, functionName, args, types);
    }

    @Override
    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof ColumnExpression || expr instanceof CharacterExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringLiteral) {
            Object value = ((StringLiteral)expr).getValue();
            if (value instanceof String && ((String)value).length() > 1) {
                throw new NucleusUserException("Can't perform equality comparison between a character and a String of more than 1 character (" + value + ") !");
            }
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).eq(expr);
        }
        return super.eq(expr);
    }

    @Override
    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof ColumnExpression || expr instanceof CharacterExpression || expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).ne(expr);
        }
        return super.ne(expr);
    }

    @Override
    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.lt(this);
        }
        if (expr instanceof ColumnExpression || expr instanceof CharacterExpression || expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).lt(expr);
        }
        return super.lt(expr);
    }

    @Override
    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.le(this);
        }
        if (expr instanceof ColumnExpression || expr instanceof CharacterExpression || expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).le(expr);
        }
        return super.le(expr);
    }

    @Override
    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.gt(this);
        }
        if (expr instanceof ColumnExpression || expr instanceof CharacterExpression || expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).gt(expr);
        }
        return super.gt(expr);
    }

    @Override
    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.ge(this);
        }
        if (expr instanceof ColumnExpression || expr instanceof CharacterExpression || expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof NumericExpression) {
            return ExpressionUtils.getNumericExpression(this).ge(expr);
        }
        return super.ge(expr);
    }

    @Override
    public SQLExpression add(SQLExpression expr) {
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_ADD, ExpressionUtils.getNumericExpression(expr));
        }
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_ADD, expr);
        }
        return super.add(expr);
    }

    @Override
    public SQLExpression sub(SQLExpression expr) {
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_SUB, ExpressionUtils.getNumericExpression(expr));
        }
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_SUB, expr);
        }
        return super.sub(expr);
    }

    @Override
    public SQLExpression mul(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_MUL, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_MUL, ExpressionUtils.getNumericExpression(expr));
        }
        return super.mul(expr);
    }

    @Override
    public SQLExpression div(SQLExpression expr) {
        if (expr instanceof NumericExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_DIV, expr);
        }
        if (expr instanceof CharacterExpression) {
            return new NumericExpression(ExpressionUtils.getNumericExpression(this), Expression.OP_DIV, ExpressionUtils.getNumericExpression(expr));
        }
        return super.div(expr);
    }

    @Override
    public SQLExpression mod(SQLExpression expr) {
        try {
            if (expr instanceof CharacterExpression) {
                return this.stmt.getSQLExpressionFactory().invokeOperation("mod", ExpressionUtils.getNumericExpression(this), ExpressionUtils.getNumericExpression(expr)).encloseInParentheses();
            }
            if (expr instanceof NumericExpression) {
                return this.stmt.getSQLExpressionFactory().invokeOperation("mod", ExpressionUtils.getNumericExpression(this), expr);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new NumericExpression(this, Expression.OP_MOD, expr);
    }

    @Override
    public SQLExpression neg() {
        return new NumericExpression(Expression.OP_NEG, ExpressionUtils.getNumericExpression(this));
    }

    @Override
    public SQLExpression com() {
        return ExpressionUtils.getNumericExpression(this).neg().sub(new IntegerLiteral(this.stmt, this.mapping, BigInteger.ONE, null));
    }

    @Override
    public BooleanExpression in(SQLExpression expr, boolean not) {
        return new BooleanExpression(this, not ? Expression.OP_NOTIN : Expression.OP_IN, expr);
    }

    @Override
    public SQLExpression invoke(String methodName, List args) {
        if (methodName.equals("toUpperCase") || methodName.equals("toLowerCase")) {
            return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, String.class.getName(), methodName, this, args);
        }
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Character.class.getName(), methodName, this, args);
    }
}

