/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.sql.AbstractSelectStatementGenerator;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSQueryUtils
extends QueryUtils {
    public static final String QUERY_RESULTSET_TYPE_SCROLL_SENSITIVE = "scroll-sensitive";
    public static final String QUERY_RESULTSET_TYPE_SCROLL_INSENSITIVE = "scroll-insensitive";
    public static final String QUERY_RESULTSET_TYPE_FORWARD_ONLY = "forward-only";
    public static final String QUERY_RESULTSET_CONCURRENCY_READONLY = "read-only";
    public static final String QUERY_RESULTSET_CONCURRENCY_UPDATEABLE = "updateable";

    public static String getClassNameFromDiscriminatorResultSetRow(JavaTypeMapping discrimMapping, DiscriminatorMetaData dismd, ResultSet rs, ExecutionContext ec) {
        String rowClassName = null;
        if (discrimMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
            try {
                String discriminatorColName = discrimMapping.getColumnMapping(0).getColumn().getIdentifier().getName();
                String discriminatorValue = rs.getString(discriminatorColName);
                rowClassName = ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discriminatorValue, dismd);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return rowClassName;
    }

    public static AbstractRDBMSQueryResult getQueryResultForQuery(Query q, ResultObjectFactory rof, ResultSet rs, Collection candidates) {
        String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery(q);
        AbstractRDBMSQueryResult qr = null;
        qr = resultSetType.equals(QUERY_RESULTSET_TYPE_SCROLL_INSENSITIVE) || resultSetType.equals(QUERY_RESULTSET_TYPE_SCROLL_SENSITIVE) ? new ScrollableQueryResult(q, rof, rs, q.getFetchPlan(), candidates) : new ForwardQueryResult(q, rof, rs, q.getFetchPlan(), candidates);
        return qr;
    }

    public static String getResultSetTypeForQuery(Query query) {
        String rsTypeString = query.getExecutionContext().getNucleusContext().getConfiguration().getStringProperty("datanucleus.rdbms.query.resultSetType");
        Object rsTypeExt = query.getExtension("datanucleus.rdbms.query.resultSetType");
        if (rsTypeExt != null) {
            rsTypeString = (String)rsTypeExt;
        }
        return rsTypeString;
    }

    public static String getResultSetConcurrencyForQuery(Query query) {
        String rsConcurrencyString = query.getExecutionContext().getNucleusContext().getConfiguration().getStringProperty("datanucleus.rdbms.query.resultSetConcurrency");
        Object rsConcurrencyExt = query.getExtension("datanucleus.rdbms.query.resultSetConcurrency");
        if (rsConcurrencyExt != null) {
            rsConcurrencyString = (String)rsConcurrencyExt;
        }
        return rsConcurrencyString;
    }

    public static boolean useUpdateLockForQuery(Query query) {
        if (query.getSerializeRead() != null) {
            if (!query.getExecutionContext().getTransaction().isActive()) {
                return false;
            }
            return query.getSerializeRead();
        }
        return query.getExecutionContext().getSerializeReadForClass(query.getCandidateClassName());
    }

    public static PreparedStatement getPreparedStatementForQuery(ManagedConnection conn, String queryStmt, Query query) throws SQLException {
        String rsConcurrencyString;
        String rsTypeString = RDBMSQueryUtils.getResultSetTypeForQuery(query);
        if (!(rsTypeString == null || rsTypeString.equals(QUERY_RESULTSET_TYPE_SCROLL_SENSITIVE) || rsTypeString.equals(QUERY_RESULTSET_TYPE_FORWARD_ONLY) || rsTypeString.equals(QUERY_RESULTSET_TYPE_SCROLL_INSENSITIVE))) {
            throw new NucleusUserException(Localiser.msg((String)"052510"));
        }
        if (rsTypeString != null) {
            DatastoreAdapter dba = ((RDBMSStoreManager)query.getStoreManager()).getDatastoreAdapter();
            if (rsTypeString.equals(QUERY_RESULTSET_TYPE_SCROLL_SENSITIVE) && !dba.supportsOption("ResultSetTypeScrollSens")) {
                rsTypeString = QUERY_RESULTSET_TYPE_FORWARD_ONLY;
                NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Query requested to run with result-set type of " + rsTypeString + " yet not supported by adapter. Using " + rsTypeString));
            } else if (rsTypeString.equals(QUERY_RESULTSET_TYPE_SCROLL_INSENSITIVE) && !dba.supportsOption("ResultSetTypeScrollInsens")) {
                rsTypeString = QUERY_RESULTSET_TYPE_FORWARD_ONLY;
                NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Query requested to run with result-set type of " + rsTypeString + " yet not supported by adapter. Using " + rsTypeString));
            } else if (rsTypeString.equals(QUERY_RESULTSET_TYPE_FORWARD_ONLY) && !dba.supportsOption("ResultSetTypeForwardOnly")) {
                rsTypeString = QUERY_RESULTSET_TYPE_SCROLL_SENSITIVE;
                NucleusLogger.DATASTORE_RETRIEVE.info((Object)("Query requested to run with result-set type of " + rsTypeString + " yet not supported by adapter. Using " + rsTypeString));
            }
        }
        if ((rsConcurrencyString = RDBMSQueryUtils.getResultSetConcurrencyForQuery(query)) != null && !rsConcurrencyString.equals(QUERY_RESULTSET_CONCURRENCY_READONLY) && !rsConcurrencyString.equals(QUERY_RESULTSET_CONCURRENCY_UPDATEABLE)) {
            throw new NucleusUserException(Localiser.msg((String)"052511"));
        }
        SQLController sqlControl = ((RDBMSStoreManager)query.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, queryStmt, rsTypeString, rsConcurrencyString);
        return ps;
    }

    public static void prepareStatementForExecution(PreparedStatement ps, Query query, boolean applyTimeout) throws SQLException {
        Integer timeout;
        if (applyTimeout && (timeout = query.getDatastoreReadTimeoutMillis()) != null && timeout > 0) {
            ps.setQueryTimeout(timeout / 1000);
        }
        int fetchSize = 0;
        if (query.getFetchPlan().getFetchSize() > 0) {
            fetchSize = query.getFetchPlan().getFetchSize();
        }
        if (((RDBMSStoreManager)query.getStoreManager()).getDatastoreAdapter().supportsQueryFetchSize(fetchSize)) {
            ps.setFetchSize(fetchSize);
        }
        Configuration conf = query.getExecutionContext().getNucleusContext().getConfiguration();
        String fetchDir = conf.getStringProperty("datanucleus.rdbms.query.fetchDirection");
        Object fetchDirExt = query.getExtension("datanucleus.rdbms.query.fetchDirection");
        if (!(fetchDirExt == null || (fetchDir = (String)fetchDirExt).equals("forward") || fetchDir.equals("reverse") || fetchDir.equals("unknown"))) {
            throw new NucleusUserException(Localiser.msg((String)"052512"));
        }
        if (fetchDir.equals("reverse")) {
            ps.setFetchDirection(1001);
        } else if (fetchDir.equals("unknown")) {
            ps.setFetchDirection(1002);
        }
        long toExclNo = query.getRangeToExcl();
        if (toExclNo != 0L && toExclNo != Long.MAX_VALUE) {
            if (toExclNo > Integer.MAX_VALUE) {
                ps.setMaxRows(Integer.MAX_VALUE);
            } else {
                ps.setMaxRows((int)toExclNo);
            }
        }
    }

    public static SelectStatement getStatementForCandidates(RDBMSStoreManager storeMgr, SQLStatement parentStmt, AbstractClassMetaData cmd, StatementClassMapping clsMapping, ExecutionContext ec, Class candidateCls, boolean subclasses, String result, String candidateAlias, String candidateTableGroupName, Set<String> options) {
        SelectStatement stmt = null;
        DatastoreIdentifier candidateAliasId = null;
        if (candidateAlias != null) {
            candidateAliasId = storeMgr.getIdentifierFactory().newTableIdentifier(candidateAlias);
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        ArrayList<DatastoreClass> candidateTables = new ArrayList<DatastoreClass>();
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
            Collection subclassNames;
            DatastoreClass candidateTable = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
            if (candidateTable != null) {
                candidateTables.add(candidateTable);
            }
            if (subclasses && (subclassNames = storeMgr.getSubClassesForClass(cmd.getFullClassName(), subclasses, clr)) != null) {
                for (String subclassName : subclassNames) {
                    DatastoreClass tbl = storeMgr.getDatastoreClass(subclassName, clr);
                    if (tbl == null) continue;
                    candidateTables.add(tbl);
                }
            }
            Iterator iter = candidateTables.iterator();
            int maxClassNameLength = cmd.getFullClassName().length();
            while (iter.hasNext()) {
                DatastoreClass cls = (DatastoreClass)iter.next();
                String className = cls.getType();
                if (className.length() <= maxClassNameLength) continue;
                maxClassNameLength = className.length();
            }
            for (DatastoreClass cls : candidateTables) {
                SelectStatement tblStmt = new SelectStatement(parentStmt, storeMgr, cls, candidateAliasId, candidateTableGroupName);
                tblStmt.setClassLoaderResolver(clr);
                tblStmt.setCandidateClassName(cls.getType());
                JavaTypeMapping m = storeMgr.getMappingManager().getMapping(String.class);
                String nuctypeName = cls.getType();
                if (maxClassNameLength > nuctypeName.length()) {
                    nuctypeName = StringUtils.leftAlignedPaddedString((String)nuctypeName, (int)maxClassNameLength);
                }
                StringLiteral lit = new StringLiteral((SQLStatement)tblStmt, m, (Object)nuctypeName, null);
                tblStmt.select(lit, "DN_TYPE");
                if (stmt == null) {
                    stmt = tblStmt;
                    continue;
                }
                stmt.union(tblStmt);
            }
            if (clsMapping != null) {
                clsMapping.setNucleusTypeColumnName("DN_TYPE");
            }
        } else {
            DatastoreClass table;
            ArrayList<Class> candidateClasses = new ArrayList<Class>();
            if (ClassUtils.isReferenceType((Class)candidateCls)) {
                String[] clsNames = storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(candidateCls.getName(), clr);
                for (int i = 0; i < clsNames.length; ++i) {
                    Class cls = clr.classForName(clsNames[i]);
                    table = storeMgr.getDatastoreClass(clsNames[i], clr);
                    candidateClasses.add(cls);
                    candidateTables.add(table);
                    AbstractClassMetaData implCmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(cls, clr);
                    if (implCmd.getIdentityType() != cmd.getIdentityType()) {
                        throw new NucleusUserException("You are querying an interface (" + cmd.getFullClassName() + ") yet one of its implementations (" + implCmd.getFullClassName() + ") uses a different identity type!");
                    }
                    if (cmd.getIdentityType() != IdentityType.APPLICATION || cmd.getPKMemberPositions().length == implCmd.getPKMemberPositions().length) continue;
                    throw new NucleusUserException("You are querying an interface (" + cmd.getFullClassName() + ") yet one of its implementations (" + implCmd.getFullClassName() + ") has a different number of PK members!");
                }
            } else {
                DatastoreClass candidateTable = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
                if (candidateTable != null) {
                    candidateClasses.add(candidateCls);
                    candidateTables.add(candidateTable);
                } else {
                    AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(cmd, clr);
                    if (cmds != null && cmds.length > 0) {
                        for (int i = 0; i < cmds.length; ++i) {
                            table = storeMgr.getDatastoreClass(cmds[i].getFullClassName(), clr);
                            Iterator<String> cls = clr.classForName(cmds[i].getFullClassName());
                            candidateClasses.add((Class)((Object)cls));
                            candidateTables.add(table);
                        }
                    } else {
                        throw new UnsupportedOperationException("No tables for query of " + cmd.getFullClassName());
                    }
                }
            }
            for (int i = 0; i < candidateTables.size(); ++i) {
                DatastoreClass tbl = (DatastoreClass)candidateTables.get(i);
                Class cls = (Class)candidateClasses.get(i);
                AbstractSelectStatementGenerator stmtGen = null;
                if (tbl.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, true) != null || QueryUtils.resultHasOnlyAggregates((String)result)) {
                    stmtGen = new DiscriminatorStatementGenerator(storeMgr, clr, cls, subclasses, candidateAliasId, candidateTableGroupName);
                    stmtGen.setOption("restrictDiscriminator");
                    if (options != null) {
                        if (options.contains("dontRestrictDiscriminator")) {
                            stmtGen.unsetOption("restrictDiscriminator");
                        }
                        for (String option : options) {
                            stmtGen.setOption(option);
                        }
                    }
                } else {
                    stmtGen = new UnionStatementGenerator(storeMgr, clr, cls, subclasses, candidateAliasId, candidateTableGroupName);
                    if (options != null) {
                        for (String option : options) {
                            stmtGen.setOption(option);
                        }
                    }
                    if (result == null) {
                        stmtGen.setOption("selectDnType");
                        if (clsMapping != null) {
                            clsMapping.setNucleusTypeColumnName("DN_TYPE");
                        }
                    }
                }
                stmtGen.setParentStatement(parentStmt);
                SelectStatement tblStmt = stmtGen.getStatement(ec);
                if (stmt == null) {
                    stmt = tblStmt;
                    continue;
                }
                stmt.union(tblStmt);
            }
        }
        return stmt;
    }

    public static ResultObjectFactory getResultObjectFactoryForNoCandidateClass(ExecutionContext ec, ResultSet rs, Class resultClass) {
        Class requiredResultClass = resultClass;
        int numberOfColumns = 0;
        String[] resultFieldNames = null;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            numberOfColumns = rsmd.getColumnCount();
            if (requiredResultClass == null) {
                requiredResultClass = numberOfColumns == 1 ? Object.class : Object[].class;
            }
            resultFieldNames = new String[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                String colName = rsmd.getColumnName(i + 1);
                String colLabel = rsmd.getColumnLabel(i + 1);
                resultFieldNames[i] = StringUtils.isWhitespace((String)colLabel) ? colName : colLabel;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new ResultClassROF(ec, rs, requiredResultClass, resultFieldNames);
    }
}

