/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.ArrayExpression;
import org.datanucleus.store.rdbms.sql.expression.ArrayLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.InExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.ArrayTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.NucleusLogger;

public class ArrayContainsMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        Class<?> elemCls;
        AbstractMemberMetaData mmd;
        if (args == null || args.size() != 1) {
            throw new NucleusException("Incorrect arguments for Array.contains(SQLExpression)");
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        ArrayExpression arrExpr = (ArrayExpression)expr;
        SQLExpression elemExpr = args.get(0);
        if (elemExpr.isParameter() && (mmd = arrExpr.getJavaTypeMapping().getMemberMetaData()) != null) {
            stmt.getQueryGenerator().bindParameter(elemExpr.getParameterName(), mmd.getType().getComponentType());
        }
        if (expr instanceof ArrayLiteral) {
            if (elemExpr instanceof UnboundExpression) {
                elemCls = clr.classForName(arrExpr.getJavaTypeMapping().getType()).getComponentType();
                elemExpr = stmt.getQueryGenerator().bindVariable((UnboundExpression)elemExpr, elemCls);
            }
            ArrayLiteral lit = (ArrayLiteral)expr;
            Object array = lit.getValue();
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            if (array == null || Array.getLength(array) == 0) {
                return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, false));
            }
            if (arrExpr.isParameter()) {
                stmt.getQueryGenerator().useParameterExpressionAsLiteral((ArrayLiteral)arrExpr);
            }
            boolean useInExpression = false;
            List<SQLExpression> collElementExprs = lit.getElementExpressions();
            if (collElementExprs != null && !collElementExprs.isEmpty()) {
                SQLExpression collElementExpr2;
                boolean incompatible = true;
                Class elemtype = clr.classForName(elemExpr.getJavaTypeMapping().getType());
                for (SQLExpression collElementExpr2 : collElementExprs) {
                    Class collElemType = clr.classForName(collElementExpr2.getJavaTypeMapping().getType());
                    if (!this.elementTypeCompatible(elemtype, collElemType)) continue;
                    incompatible = false;
                    break;
                }
                if (incompatible) {
                    return exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, false));
                }
                collElementExpr2 = collElementExprs.get(0);
                if (collElementExpr2 instanceof StringExpression || collElementExpr2 instanceof NumericExpression || collElementExpr2 instanceof TemporalExpression || collElementExpr2 instanceof CharacterExpression || collElementExpr2 instanceof EnumExpression) {
                    useInExpression = true;
                }
            }
            if (useInExpression) {
                SQLExpression[] exprs = collElementExprs != null ? collElementExprs.toArray(new SQLExpression[collElementExprs.size()]) : null;
                return new InExpression(elemExpr, exprs);
            }
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = lit.getElementExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                SQLExpression arrElemExpr = elementExprs.get(i);
                bExpr = bExpr == null ? arrElemExpr.eq(elemExpr) : ((BooleanExpression)bExpr).ior(arrElemExpr.eq(elemExpr));
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        if (arrExpr.getElementExpressions() != null) {
            if (elemExpr instanceof UnboundExpression) {
                elemCls = clr.classForName(arrExpr.getJavaTypeMapping().getType()).getComponentType();
                elemExpr = stmt.getQueryGenerator().bindVariable((UnboundExpression)elemExpr, elemCls);
            }
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = arrExpr.getElementExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                SQLExpression arrElemExpr = elementExprs.get(i);
                bExpr = bExpr == null ? arrElemExpr.eq(elemExpr) : ((BooleanExpression)bExpr).ior(arrElemExpr.eq(elemExpr));
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        return this.containsAsSubquery(stmt, arrExpr, elemExpr);
    }

    protected SQLExpression containsAsSubquery(SQLStatement stmt, ArrayExpression arrExpr, SQLExpression elemExpr) {
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> Array.contains binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        AbstractMemberMetaData mmd = arrExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr);
        ArrayTable joinTbl = (ArrayTable)storeMgr.getTable(mmd);
        SelectStatement subStmt = null;
        if (joinTbl != null) {
            if (elemCmd == null) {
                subStmt = new SelectStatement(stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, arrExpr.getSQLTable(), arrExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                }
            } else {
                DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getArray().getElementType(), clr);
                subStmt = new SelectStatement(stmt, storeMgr, elemTbl, null, null);
                subStmt.setClassLoaderResolver(clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.join(SQLJoin.JoinType.INNER_JOIN, subStmt.getPrimaryTable(), elemTbl.getIdMapping(), null, joinTbl, null, joinTbl.getElementMapping(), null, null, null, true, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, arrExpr.getSQLTable(), arrExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                if (elemIsUnbound) {
                    stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                }
            }
        } else {
            throw new NucleusException("Dont support evaluation of ARRAY.contains when no join table is used");
        }
        return new BooleanSubqueryExpression(stmt, "EXISTS", subStmt);
    }

    protected boolean elementTypeCompatible(Class elementType, Class collectionElementType) {
        if (!elementType.isPrimitive() && collectionElementType.isPrimitive() && !collectionElementType.isAssignableFrom(elementType) && !elementType.isAssignableFrom(collectionElementType)) {
            return false;
        }
        if (elementType.isPrimitive()) {
            boolean collectionElemTypeFloatPt;
            boolean collectionElemTypeIntegral;
            if (elementType == Boolean.TYPE && collectionElementType == Boolean.class) {
                return true;
            }
            if (elementType == Byte.TYPE && collectionElementType == Byte.class) {
                return true;
            }
            if (elementType == Character.TYPE && collectionElementType == Character.class) {
                return true;
            }
            boolean elementTypeIntegral = elementType == Integer.TYPE || elementType == Short.TYPE || elementType == Long.TYPE;
            boolean bl = collectionElemTypeIntegral = collectionElementType == Integer.class || collectionElementType == Short.class || collectionElementType == Long.class || collectionElementType == BigInteger.class;
            if (elementTypeIntegral && collectionElemTypeIntegral) {
                return true;
            }
            boolean elementTypeFloatPt = elementType == Float.TYPE || elementType == Double.TYPE;
            boolean bl2 = collectionElemTypeFloatPt = collectionElementType == Float.class || collectionElementType == Double.class || collectionElementType == BigDecimal.class;
            return elementTypeFloatPt && collectionElemTypeFloatPt;
        }
        return true;
    }
}

