/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public class MapGetMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"get", "MapExpression", 1}));
        }
        MapExpression mapExpr = (MapExpression)expr;
        SQLExpression keyValExpr = args.get(0);
        if (keyValExpr instanceof UnboundExpression) {
            throw new NucleusException("Dont currently support binding of unbound variables using Map.get");
        }
        if (mapExpr instanceof MapLiteral && keyValExpr instanceof SQLLiteral) {
            MapLiteral lit = (MapLiteral)expr;
            if (lit.getValue() == null) {
                return new NullLiteral(stmt, null, null, null);
            }
            return lit.getKeyLiteral().invoke("get", args);
        }
        if (mapExpr instanceof MapLiteral) {
            throw new NucleusUserException("We do not support MapLiteral.get(SQLExpression) since SQL doesnt allow such constructs");
        }
        if (stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER || stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.ORDERING) {
            return this.getAsInnerJoin(stmt, mapExpr, keyValExpr);
        }
        if (stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.RESULT || stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.HAVING) {
            return this.getAsSubquery(stmt, mapExpr, keyValExpr);
        }
        throw new NucleusException("Map.get() is not supported for " + mapExpr + " with argument " + keyValExpr + " for query component " + stmt.getQueryGenerator().getCompilationComponent());
    }

    protected SQLExpression getAsSubquery(SQLStatement stmt, MapExpression mapExpr, SQLExpression keyValExpr) {
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        MapMetaData mapmd = mmd.getMap();
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        JavaTypeMapping ownerMapping = null;
        JavaTypeMapping keyMapping = null;
        JavaTypeMapping valMapping = null;
        Table mapTbl = null;
        if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            mapTbl = storeMgr.getTable(mmd);
            ownerMapping = ((MapTable)mapTbl).getOwnerMapping();
            keyMapping = ((MapTable)mapTbl).getKeyMapping();
            valMapping = ((MapTable)mapTbl).getValueMapping();
        } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valCmd = mapmd.getValueClassMetaData(clr);
            mapTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), clr);
            ownerMapping = mmd.getMappedBy() != null ? mapTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            String keyFieldName = mmd.getKeyMetaData().getMappedBy();
            AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(keyFieldName);
            keyMapping = mapTbl.getMemberMapping(valKeyMmd);
            valMapping = mapTbl.getIdMapping();
        } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mapmd.getKeyClassMetaData(clr);
            mapTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), clr);
            ownerMapping = mmd.getMappedBy() != null ? mapTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            keyMapping = mapTbl.getIdMapping();
            String valFieldName = mmd.getValueMetaData().getMappedBy();
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(valFieldName);
            valMapping = mapTbl.getMemberMapping(keyValMmd);
        } else {
            throw new NucleusException("Invalid map for " + mapExpr + " in get() call");
        }
        SelectStatement subStmt = new SelectStatement(stmt, storeMgr, mapTbl, null, null);
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        subStmt.setClassLoaderResolver(clr);
        SQLExpression valExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
        subStmt.select(valExpr, null);
        SQLExpression elementOwnerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        SQLExpression keyExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyMapping);
        subStmt.whereAnd(keyExpr.eq(keyValExpr), true);
        SubqueryExpression subExpr = new SubqueryExpression(stmt, subStmt);
        subExpr.setJavaTypeMapping(valMapping);
        return subExpr;
    }

    protected SQLExpression getAsInnerJoin(SQLStatement stmt, MapExpression mapExpr, SQLExpression keyValExpr) {
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        JavaTypeMapping m = mapExpr.getJavaTypeMapping();
        AbstractMemberMetaData mmd = m.getMemberMetaData();
        if (mmd != null) {
            MapMetaData mapmd = mmd.getMap();
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
                MapTable joinTbl = (MapTable)stmt.getRDBMSManager().getTable(mmd);
                SQLTable joinSqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                SQLExpression keyExpr = exprFactory.newExpression(stmt, joinSqlTbl, joinTbl.getKeyMapping());
                stmt.whereAnd(keyExpr.eq(keyValExpr), true);
                if (mapmd.getValueClassMetaData(clr) != null) {
                    DatastoreClass valTable = stmt.getRDBMSManager().getDatastoreClass(mapmd.getValueType(), clr);
                    SQLTable valueSqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, joinSqlTbl, joinTbl.getValueMapping(), valTable, null, valTable.getIdMapping(), null, null);
                    return exprFactory.newExpression(stmt, valueSqlTbl, valTable.getIdMapping());
                }
                SQLExpression valueExpr = exprFactory.newExpression(stmt, joinSqlTbl, joinTbl.getValueMapping());
                return valueExpr;
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
                DatastoreClass valTable = stmt.getRDBMSManager().getDatastoreClass(mapmd.getValueType(), clr);
                AbstractClassMetaData valCmd = mapmd.getValueClassMetaData(clr);
                JavaTypeMapping mapTblOwnerMapping = mmd.getMappedBy() != null ? valTable.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTable.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
                SQLTable valSqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), valTable, null, mapTblOwnerMapping, null, null);
                JavaTypeMapping keyMapping = valTable.getMemberMapping(valCmd.getMetaDataForMember(mmd.getKeyMetaData().getMappedBy()));
                SQLExpression keyExpr = exprFactory.newExpression(stmt, valSqlTbl, keyMapping);
                stmt.whereAnd(keyExpr.eq(keyValExpr), true);
                SQLExpression valueExpr = exprFactory.newExpression(stmt, valSqlTbl, valTable.getIdMapping());
                return valueExpr;
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
                DatastoreClass keyTable = stmt.getRDBMSManager().getDatastoreClass(mapmd.getKeyType(), clr);
                AbstractClassMetaData keyCmd = mapmd.getKeyClassMetaData(clr);
                JavaTypeMapping mapTblOwnerMapping = mmd.getMappedBy() != null ? keyTable.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTable.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
                SQLTable keySqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), keyTable, null, mapTblOwnerMapping, null, null);
                SQLExpression keyExpr = exprFactory.newExpression(stmt, keySqlTbl, keyTable.getIdMapping());
                stmt.whereAnd(keyExpr.eq(keyValExpr), true);
                JavaTypeMapping valueMapping = keyTable.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getValueMetaData().getMappedBy()));
                SQLExpression valueExpr = exprFactory.newExpression(stmt, keySqlTbl, valueMapping);
                return valueExpr;
            }
        }
        throw new NucleusException("Map.get() for the filter is not supported for " + mapExpr + " with an argument of " + keyValExpr + ". Why not contribute support for it?");
    }
}

