/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public final class ColumnMappingFactory {
    private static Map DATASTORE_MAPPING_CONSTRUCTOR_BY_CLASS = new HashMap();
    private static final Class[] DATASTORE_MAPPING_CTR_ARG_CLASSES = new Class[]{JavaTypeMapping.class, RDBMSStoreManager.class, Column.class};

    private ColumnMappingFactory() {
    }

    public static ColumnMapping createMapping(Class<? extends ColumnMapping> mappingClass, JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column column) {
        ColumnMapping obj = null;
        try {
            Object[] args = new Object[]{mapping, storeMgr, column};
            Constructor<? extends ColumnMapping> ctr = (Constructor<? extends ColumnMapping>)DATASTORE_MAPPING_CONSTRUCTOR_BY_CLASS.get(mappingClass);
            if (ctr == null) {
                ctr = mappingClass.getConstructor(DATASTORE_MAPPING_CTR_ARG_CLASSES);
                DATASTORE_MAPPING_CONSTRUCTOR_BY_CLASS.put(mappingClass, ctr);
            }
            try {
                obj = ctr.newInstance(args);
            }
            catch (InvocationTargetException e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mappingClass.getName(), e.getTargetException()}), e.getTargetException()).setFatal();
            }
            catch (Exception e) {
                throw new NucleusException(Localiser.msg((String)"041009", (Object[])new Object[]{mappingClass.getName(), e}), (Throwable)e).setFatal();
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new NucleusException(Localiser.msg((String)"041007", (Object[])new Object[]{JavaTypeMapping.class, RDBMSStoreManager.class, Column.class, mappingClass.getName()})).setFatal();
        }
        return obj;
    }
}

