/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.autostart;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;

public class SchemaTable
extends TableImpl {
    private JavaTypeMapping classMapping = null;
    private JavaTypeMapping tableMapping = null;
    private JavaTypeMapping typeMapping = null;
    private JavaTypeMapping ownerMapping = null;
    private JavaTypeMapping versionMapping = null;
    private JavaTypeMapping interfaceNameMapping = null;
    private String insertStmt = null;
    private String deleteStmt = null;
    private String deleteAllStmt = null;
    private String fetchAllStmt = null;
    private String fetchStmt = null;

    public SchemaTable(RDBMSStoreManager storeMgr, String tableName) {
        super(storeMgr.getIdentifierFactory().newTableIdentifier(tableName != null ? tableName : "NUCLEUS_TABLES"), storeMgr);
    }

    @Override
    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        MappingManager mapMgr = this.getStoreManager().getMappingManager();
        this.classMapping = mapMgr.getMapping(String.class);
        Column class_column = this.addColumn(String.class.getName(), idFactory.newColumnIdentifier("CLASS_NAME"), this.classMapping, null);
        mapMgr.createColumnMapping(this.classMapping, class_column, String.class.getName());
        class_column.getColumnMetaData().setLength(Integer.valueOf(128));
        class_column.getColumnMetaData().setJdbcType(JdbcType.VARCHAR);
        class_column.setPrimaryKey();
        this.tableMapping = mapMgr.getMapping(String.class);
        Column table_column = this.addColumn(String.class.getName(), idFactory.newColumnIdentifier("TABLE_NAME"), this.tableMapping, null);
        mapMgr.createColumnMapping(this.tableMapping, table_column, String.class.getName());
        table_column.getColumnMetaData().setLength(Integer.valueOf(128));
        table_column.getColumnMetaData().setJdbcType(JdbcType.VARCHAR);
        this.typeMapping = mapMgr.getMapping(String.class);
        Column type_column = this.addColumn(String.class.getName(), idFactory.newColumnIdentifier("TYPE"), this.typeMapping, null);
        mapMgr.createColumnMapping(this.typeMapping, type_column, String.class.getName());
        type_column.getColumnMetaData().setLength(Integer.valueOf(4));
        type_column.getColumnMetaData().setJdbcType(JdbcType.VARCHAR);
        this.ownerMapping = mapMgr.getMapping(String.class);
        Column owner_column = this.addColumn(String.class.getName(), idFactory.newColumnIdentifier("OWNER"), this.ownerMapping, null);
        mapMgr.createColumnMapping(this.ownerMapping, owner_column, String.class.getName());
        owner_column.getColumnMetaData().setLength(Integer.valueOf(2));
        owner_column.getColumnMetaData().setJdbcType(JdbcType.VARCHAR);
        this.versionMapping = mapMgr.getMapping(String.class);
        Column version_column = this.addColumn(String.class.getName(), idFactory.newColumnIdentifier("VERSION"), this.versionMapping, null);
        mapMgr.createColumnMapping(this.versionMapping, version_column, String.class.getName());
        version_column.getColumnMetaData().setLength(Integer.valueOf(20));
        version_column.getColumnMetaData().setJdbcType(JdbcType.VARCHAR);
        this.interfaceNameMapping = mapMgr.getMapping(String.class);
        Column interfaceName_column = this.addColumn(String.class.getName(), idFactory.newColumnIdentifier("INTERFACE_NAME"), this.interfaceNameMapping, null);
        mapMgr.createColumnMapping(this.interfaceNameMapping, interfaceName_column, String.class.getName());
        interfaceName_column.getColumnMetaData().setLength(Integer.valueOf(255));
        interfaceName_column.getColumnMetaData().setJdbcType(JdbcType.VARCHAR);
        interfaceName_column.setNullable(true);
        this.insertStmt = "INSERT INTO " + this.identifier.getFullyQualifiedName(false) + " (" + class_column.getIdentifier() + "," + table_column.getIdentifier() + "," + type_column.getIdentifier() + "," + owner_column.getIdentifier() + "," + version_column.getIdentifier() + "," + interfaceName_column.getIdentifier() + ") VALUES (?,?,?,?,?,?)";
        this.deleteStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + idFactory.getIdentifierInAdapterCase("CLASS_NAME") + "=?";
        this.deleteAllStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false);
        this.fetchAllStmt = "SELECT " + class_column.getIdentifier() + "," + table_column.getIdentifier() + "," + type_column.getIdentifier() + "," + owner_column.getIdentifier() + "," + version_column.getIdentifier() + "," + interfaceName_column.getIdentifier() + " FROM " + this.identifier.getFullyQualifiedName(false) + " ORDER BY " + table_column.getIdentifier();
        this.fetchStmt = "SELECT 1 FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + idFactory.getIdentifierInAdapterCase("CLASS_NAME") + " = ? ";
        this.state = 2;
    }

    @Override
    public JavaTypeMapping getIdMapping() {
        throw new NucleusException("Attempt to get ID mapping of SchemaTable!").setFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getAllClasses(ManagedConnection conn) throws SQLException {
        HashSet<RDBMSStoreData> schema_data = new HashSet<RDBMSStoreData>();
        if (this.storeMgr.getDdlWriter() != null && !this.tableExists((Connection)conn.getConnection())) {
            return schema_data;
        }
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.fetchAllStmt);
        try (ResultSet rs = sqlControl.executeStatementQuery(null, conn, this.fetchAllStmt, ps);){
            while (rs.next()) {
                RDBMSStoreData data = new RDBMSStoreData(rs.getString(1), rs.getString(2), rs.getString(4).equals("1"), rs.getString(3).equals("FCO") ? StoreData.Type.FCO : StoreData.Type.SCO, rs.getString(6));
                schema_data.add(data);
            }
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
        return schema_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(RDBMSStoreData data, ManagedConnection conn) throws SQLException {
        if (this.storeMgr.getDdlWriter() != null) {
            return;
        }
        if (this.hasClass(data, conn)) {
            return;
        }
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.insertStmt, false);
        try {
            int jdbc_id = 1;
            this.classMapping.setString(null, ps, MappingHelper.getMappingIndices(jdbc_id, this.classMapping), data.getName());
            this.tableMapping.setString(null, ps, MappingHelper.getMappingIndices(jdbc_id += this.classMapping.getNumberOfColumnMappings(), this.tableMapping), data.hasTable() ? data.getTableName() : "");
            this.typeMapping.setString(null, ps, MappingHelper.getMappingIndices(jdbc_id += this.tableMapping.getNumberOfColumnMappings(), this.typeMapping), data.isFCO() ? "FCO" : "SCO");
            this.ownerMapping.setString(null, ps, MappingHelper.getMappingIndices(jdbc_id += this.typeMapping.getNumberOfColumnMappings(), this.ownerMapping), data.isTableOwner() ? "1" : "0");
            this.versionMapping.setString(null, ps, MappingHelper.getMappingIndices(jdbc_id += this.ownerMapping.getNumberOfColumnMappings(), this.versionMapping), "DataNucleus");
            this.interfaceNameMapping.setString(null, ps, MappingHelper.getMappingIndices(jdbc_id += this.versionMapping.getNumberOfColumnMappings(), this.interfaceNameMapping), data.getInterfaceName());
            jdbc_id += this.interfaceNameMapping.getNumberOfColumnMappings();
            sqlControl.executeStatementUpdate(null, conn, this.insertStmt, ps, true);
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasClass(StoreData data, ManagedConnection conn) throws SQLException {
        if (!this.tableExists((Connection)conn.getConnection())) {
            return false;
        }
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.fetchStmt);
        try {
            int jdbc_id = 1;
            this.tableMapping.setString(null, ps, MappingHelper.getMappingIndices(jdbc_id, this.tableMapping), data.getName());
            try (ResultSet rs = sqlControl.executeStatementQuery(null, conn, this.fetchStmt, ps);){
                if (rs.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClass(String class_name, ManagedConnection conn) throws SQLException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.deleteStmt, false);
        try {
            ps.setString(1, class_name);
            sqlControl.executeStatementUpdate(null, conn, this.deleteStmt, ps, true);
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllClasses(ManagedConnection conn) throws SQLException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.deleteAllStmt, false);
        try {
            sqlControl.executeStatementUpdate(null, conn, this.deleteAllStmt, ps, true);
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    private boolean tableExists(Connection conn) throws SQLException {
        try {
            this.exists(conn, false);
            return true;
        }
        catch (MissingTableException mte) {
            return false;
        }
    }

    @Override
    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        return null;
    }
}

