/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class HikariCPConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        long validationTimeout;
        long connectionTimeout;
        long maxLifeTime;
        long threshold;
        int idle;
        int size;
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.zaxxer.hikari.HikariConfig", (String)"hikaricp.jar");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(storeMgr.getConnectionURL());
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        config.setUsername(dbUser);
        String dbPassword = storeMgr.getConnectionPassword();
        if (dbPassword == null) {
            dbPassword = "";
        }
        config.setPassword(dbPassword);
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, clr);
            config.setDriverClassName(dbDriver);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
            config.setMaximumPoolSize(size);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minIdle") && (idle = storeMgr.getIntProperty("datanucleus.connectionPool.minIdle")) >= 0) {
            config.setMinimumIdle(idle);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (idle = (long)storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) >= 0L) {
            config.setIdleTimeout(idle);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.leakThreshold") && (threshold = (long)storeMgr.getIntProperty("datanucleus.connectionPool.leakThreshold")) >= 0L) {
            config.setLeakDetectionThreshold(threshold);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxLifetime") && (maxLifeTime = (long)storeMgr.getIntProperty("datanucleus.connectionPool.maxLifetime")) >= 0L) {
            config.setMaxLifetime(maxLifeTime);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.autoCommit")) {
            boolean autoCommit = storeMgr.getBooleanProperty("datanucleus.connectionPool.autoCommit");
            config.setAutoCommit(autoCommit);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.connectionWaitTimeout") && (connectionTimeout = (long)storeMgr.getIntProperty("datanucleus.connectionPool.connectionWaitTimeout")) >= 0L) {
            config.setConnectionTimeout(connectionTimeout);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.testSQL")) {
            String connectionTestQuery = storeMgr.getStringProperty("datanucleus.connectionPool.testSQL");
            config.setConnectionTestQuery(connectionTestQuery);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.name")) {
            String poolName = storeMgr.getStringProperty("datanucleus.connectionPool.name");
            config.setPoolName(poolName);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.transactionIsolation")) {
            String transactionIsolation = storeMgr.getStringProperty("datanucleus.connectionPool.transactionIsolation");
            config.setTransactionIsolation(transactionIsolation);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.catalog")) {
            String catalog = storeMgr.getStringProperty("datanucleus.connectionPool.catalog");
            config.setCatalog(catalog);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.readOnly")) {
            boolean readOnly = storeMgr.getBooleanProperty("datanucleus.connectionPool.readOnly");
            config.setReadOnly(readOnly);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.allowPoolSuspension")) {
            boolean allowPoolSuspension = storeMgr.getBooleanProperty("datanucleus.connectionPool.allowPoolSuspension");
            config.setAllowPoolSuspension(allowPoolSuspension);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.validationTimeout") && (validationTimeout = (long)storeMgr.getIntProperty("datanucleus.connectionPool.validationTimeout")) >= 0L) {
            config.setValidationTimeout(validationTimeout);
        }
        HikariDataSource ds = new HikariDataSource(config);
        return new HikariCPConnectionPool(ds);
    }

    public class HikariCPConnectionPool
    implements ConnectionPool {
        final HikariDataSource dataSource;

        public HikariCPConnectionPool(HikariDataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public void close() {
            this.dataSource.close();
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

