/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.DoubleRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class FloatRDBMSMapping
extends DoubleRDBMSMapping {
    public FloatRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    public int getJDBCType() {
        return 6;
    }

    @Override
    public float getFloat(ResultSet rs, int param) {
        float value;
        try {
            value = rs.getFloat(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"float", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setFloat(PreparedStatement ps, int param, float value) {
        try {
            ps.setFloat(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"float", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.useDefaultWhenNull()) {
                    ps.setFloat(param, Float.valueOf(this.column.getDefaultValue().toString()).floatValue());
                } else {
                    ps.setNull(param, this.getJDBCType());
                }
            } else if (value instanceof Integer) {
                ps.setFloat(param, ((Integer)value).floatValue());
            } else if (value instanceof Long) {
                ps.setFloat(param, ((Long)value).floatValue());
            } else if (value instanceof Short) {
                ps.setFloat(param, ((Short)value).floatValue());
            } else if (value instanceof BigInteger) {
                ps.setFloat(param, ((BigInteger)value).floatValue());
            } else if (value instanceof BigDecimal) {
                ps.setFloat(param, ((BigDecimal)value).floatValue());
            } else if (value instanceof Character) {
                ps.setFloat(param, value.toString().charAt(0));
            } else if (value instanceof Float) {
                ps.setFloat(param, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                ps.setDouble(param, (Double)value);
            } else if (value instanceof String) {
                ps.setFloat(param, Float.parseFloat((String)value));
            } else {
                ps.setFloat(param, ((Number)value).floatValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Object", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Number value;
        try {
            float d = rs.getFloat(param);
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                value = rs.wasNull() ? null : Integer.valueOf((int)d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_LONG)) {
                value = rs.wasNull() ? null : Long.valueOf((long)d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_FLOAT)) {
                value = rs.wasNull() ? null : new Float(d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_DOUBLE)) {
                double dbl = rs.getDouble(param);
                value = rs.wasNull() ? null : Double.valueOf(dbl);
            } else {
                value = rs.wasNull() ? null : Double.valueOf(d);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"Object", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }
}

