/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.exceptions.NoDatastoreMappingException;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.scostore.SetStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.util.Localiser;

public abstract class AbstractContainerMapping
extends SingleFieldMapping {
    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        super.initialize(mmd, table, clr);
        if (mmd.getContainer() == null) {
            throw new NucleusUserException(Localiser.msg((String)"041023", (Object[])new Object[]{mmd.getFullFieldName()}));
        }
        if (!this.containerIsStoredInSingleColumn()) {
            this.storeMgr.newJoinTable(table, mmd, clr);
        }
    }

    @Override
    public boolean hasSimpleDatastoreRepresentation() {
        return false;
    }

    @Override
    protected void prepareDatastoreMapping() {
        if (this.containerIsStoredInSingleColumn()) {
            MappingManager mmgr = this.storeMgr.getMappingManager();
            ColumnMetaData colmd = null;
            ColumnMetaData[] colmds = this.mmd.getColumnMetaData();
            if (colmds != null && colmds.length > 0) {
                colmd = colmds[0];
            } else if (this.mmd.hasCollection() || this.mmd.hasArray()) {
                ColumnMetaData[] columnMetaDataArray = colmds = this.mmd.getElementMetaData() != null ? this.mmd.getElementMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    colmd = colmds[0];
                }
            }
            Column col = mmgr.createColumn((JavaTypeMapping)this, this.getJavaTypeForDatastoreMapping(0), colmd);
            mmgr.createDatastoreMapping(this, this.mmd, 0, col);
        }
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            if (this.mmd.hasCollection() || this.mmd.hasArray()) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = this.mmd.getElementMetaData() != null ? this.mmd.getElementMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null && colmds[0].getJdbcType().equals((Object)JdbcType.ARRAY)) {
                    return Collection.class.getName();
                }
                colmds = this.mmd.getColumnMetaData();
                if (colmds != null && colmds.length == 1 && colmds[0].getJdbcType() != null && colmds[0].getJdbcType().equals((Object)JdbcType.ARRAY)) {
                    return Collection.class.getName();
                }
            }
            return ClassNameConstants.JAVA_IO_SERIALIZABLE;
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (this.mmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("setObject")).setFatal();
        }
        ObjectProvider[] sms = null;
        ApiAdapter api = ec.getApiAdapter();
        if (value != null) {
            HashSet<ObjectProvider> smsColl = null;
            if (value instanceof Collection) {
                for (Object elem : (Collection)value) {
                    ObjectProvider sm;
                    if (!api.isPersistable(elem) || (sm = ec.findObjectProvider(elem)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet<ObjectProvider>();
                    }
                    smsColl.add(sm);
                }
            } else if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    ObjectProvider sm;
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (api.isPersistable(key) && (sm = ec.findObjectProvider(key)) != null) {
                        if (smsColl == null) {
                            smsColl = new HashSet();
                        }
                        smsColl.add(sm);
                    }
                    if (!api.isPersistable(val) || (sm = ec.findObjectProvider(val)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet();
                    }
                    smsColl.add(sm);
                }
            }
            if (smsColl != null) {
                sms = smsColl.toArray(new ObjectProvider[smsColl.size()]);
            }
        }
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].setStoringPC();
            }
        }
        this.getDatastoreMapping(0).setObject(ps, exprIndex[0], value);
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].unsetStoringPC();
            }
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.mmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("getObject")).setFatal();
        }
        return this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
    }

    @Override
    public Table getTable() {
        if (this.containerIsStoredInSingleColumn()) {
            return this.table;
        }
        return null;
    }

    @Override
    public int getNumberOfDatastoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getNumberOfDatastoreMappings();
        }
        return 0;
    }

    @Override
    public DatastoreMapping getDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDatastoreMapping(index);
        }
        throw new NoDatastoreMappingException(this.mmd.getName());
    }

    @Override
    public DatastoreMapping[] getDatastoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDatastoreMappings();
        }
        throw new NoDatastoreMappingException(this.mmd.getName());
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (this.mmd != null && this.mmd.isSerialized()) {
            return true;
        }
        if (this.mmd != null && this.mmd.hasCollection() && SCOUtils.collectionHasSerialisedElements((AbstractMemberMetaData)this.mmd)) {
            return true;
        }
        if (this.mmd != null && this.mmd.hasMap() && SCOUtils.mapHasSerialisedKeysAndValues((AbstractMemberMetaData)this.mmd)) {
            return true;
        }
        if (this.mmd != null && this.mmd.hasArray() && SCOUtils.arrayIsStoredInSingleColumn((AbstractMemberMetaData)this.mmd, (MetaDataManager)this.storeMgr.getMetaDataManager())) {
            return !MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.mmd);
        }
        return false;
    }

    @Override
    public boolean includeInFetchStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    @Override
    public boolean includeInUpdateStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    @Override
    public boolean includeInInsertStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    protected SCO replaceFieldWithWrapper(ObjectProvider op, Object value) {
        Class type = this.mmd.getType();
        if (value != null) {
            type = value.getClass();
        } else if (this.mmd.getOrderMetaData() != null && type.isAssignableFrom(List.class)) {
            type = List.class;
            Store backingStore = this.storeMgr.getExistingBackingStoreForMember(this.mmd);
            if (backingStore != null && backingStore instanceof SetStore) {
                type = this.mmd.getType();
            }
        }
        ExecutionContext ec = op.getExecutionContext();
        if (this.mmd.getAbsoluteFieldNumber() < 0) {
            this.mmd = ec.getMetaDataManager().getMetaDataForClass(this.mmd.getClassName(true), ec.getClassLoaderResolver()).getMetaDataForMember(this.mmd.getName());
        }
        return ec.getTypeManager().createSCOInstance(op, this.mmd, type, value, true);
    }

    public void postFetch(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        this.replaceFieldWithWrapper(sm, null);
    }
}

